/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import org.exoplatform.services.jcr.datamodel.InternalQName;

public class JCRName {
    protected final String prefix;
    protected final String name;
    protected final String namespace;
    protected final String stringName;
    protected final int hashCode;

    JCRName(String namespace, String name, String prefix) {
        this.name = name.intern();
        this.namespace = namespace.intern();
        this.prefix = prefix.intern();
        this.stringName = (this.prefix.length() == 0 ? "" : this.prefix + ":") + this.name;
        int hk = 31 + this.namespace.hashCode();
        hk = hk * 31 + this.name.hashCode();
        this.hashCode = hk * 31 + this.prefix.hashCode();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public InternalQName getInternalName() {
        return new InternalQName(this.namespace, this.name);
    }

    public String getAsString() {
        return this.stringName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JCRName) {
            return this.hashCode == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return super.toString() + " (" + this.getAsString() + ")";
    }
}

