/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.log.ExoLogger;

public abstract class FileValueStorage
extends ValueStoragePlugin {
    private Log log = ExoLogger.getLogger((String)"jcr.FileValueStorage");
    public static final String PATH = "path";
    protected File rootDir;
    protected FileCleaner cleaner = new FileCleaner();

    public void init(Properties props) throws IOException, RepositoryConfigurationException {
        this.prepareRootDir(props.getProperty(PATH));
    }

    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
    }

    public boolean match(String storageId) {
        return this.getId().equals(storageId);
    }

    protected void prepareRootDir(String rootDirPath) throws IOException, RepositoryConfigurationException {
        this.rootDir = new File(rootDirPath);
        if (!this.rootDir.exists()) {
            if (this.rootDir.mkdirs()) {
                this.log.info((Object)("Directory created: " + this.rootDir.getAbsolutePath()));
            } else {
                this.log.warn((Object)("Directory IS NOT created: " + this.rootDir.getAbsolutePath()));
            }
        } else if (!this.rootDir.isDirectory()) {
            throw new RepositoryConfigurationException("File exists but is not a directory " + rootDirPath);
        }
    }
}

