/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public class SwapFile
extends SpoolFile {
    protected static Map<String, SwapFile> inShare = new HashMap<String, SwapFile>();
    protected CountDownLatch spoolLatch = null;

    protected SwapFile(File parent, String child) {
        super(parent, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SwapFile get(File parent, String child) throws IOException {
        Map<String, SwapFile> map = inShare;
        synchronized (map) {
            SwapFile newsf = new SwapFile(parent, child);
            String absPath = newsf.getAbsolutePath();
            SwapFile swapped = inShare.get(absPath);
            if (swapped != null) {
                CountDownLatch spoolLatch = swapped.spoolLatch;
                if (spoolLatch != null) {
                    try {
                        spoolLatch.await();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Swap file read error " + swapped.getAbsolutePath() + ". " + e){

                            public Throwable getCause() {
                                return e;
                            }
                        };
                    }
                }
                return swapped;
            }
            newsf.spoolLatch = new CountDownLatch(1);
            inShare.put(absPath, newsf);
            return newsf;
        }
    }

    public boolean isSpooled() {
        return this.spoolLatch == null;
    }

    public void spoolDone() {
        CountDownLatch sl = this.spoolLatch;
        this.spoolLatch = null;
        sl.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        Map<String, SwapFile> map = inShare;
        synchronized (map) {
            if (super.delete()) {
                inShare.remove(this.getAbsolutePath());
                return true;
            }
            return false;
        }
    }

    public static SwapFile createTempFile(String prefix, String suffix, File directory) throws IOException {
        throw new IOException("Not applicable. Call get(File, String) method instead");
    }
}

