/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.EditableValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public class TransientValueData
extends AbstractValueData
implements Externalizable {
    private static final long serialVersionUID = -5280857006905550884L;
    protected byte[] data;
    protected InputStream tmpStream;
    protected File spoolFile;
    protected FileChannel spoolChannel;
    protected FileCleaner fileCleaner;
    protected int maxBufferSize;
    protected File tempDirectory;
    protected boolean spooled = false;
    private final boolean deleteSpoolFile;

    protected static byte[] stringToBytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    protected TransientValueData(byte[] value, int orderNumber) {
        super(orderNumber);
        this.data = value;
        this.deleteSpoolFile = true;
    }

    protected TransientValueData(InputStream stream, int orderNumber) {
        super(orderNumber);
        this.tmpStream = stream;
        this.deleteSpoolFile = true;
    }

    public TransientValueData(int orderNumber, byte[] bytes, InputStream stream, File spoolFile, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory, boolean deleteSpoolFile) throws IOException {
        super(orderNumber);
        this.data = bytes;
        this.tmpStream = stream;
        this.spoolFile = spoolFile;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.tempDirectory = tempDirectory;
        this.deleteSpoolFile = deleteSpoolFile;
        if (spoolFile != null) {
            if (spoolFile instanceof SpoolFile) {
                ((SpoolFile)spoolFile).acquire(this);
            }
            this.spooled = true;
        }
    }

    public TransientValueData(InputStream stream) {
        this(stream, 0);
    }

    public TransientValueData(String value) {
        this(TransientValueData.stringToBytes(value), 0);
    }

    public TransientValueData(boolean value) {
        this(Boolean.valueOf(value).toString().getBytes(), 0);
    }

    public TransientValueData(Calendar value) {
        this(new JCRDateFormat().serialize(value), 0);
    }

    public TransientValueData(double value) {
        this(Double.valueOf(value).toString().getBytes(), 0);
    }

    public TransientValueData(long value) {
        this(Long.valueOf(value).toString().getBytes(), 0);
    }

    public TransientValueData(InternalQName value) {
        this(TransientValueData.stringToBytes(value.getAsString()), 0);
    }

    public TransientValueData(QPath value) {
        this(TransientValueData.stringToBytes(value.getAsString()), 0);
    }

    public TransientValueData(Identifier value) {
        this(value.getString().getBytes(), 0);
    }

    public TransientValueData(AccessControlEntry value) {
        this(TransientValueData.stringToBytes(value.getAsString()), 0);
    }

    public byte[] getAsByteArray() throws IOException {
        this.spoolInputStream();
        if (this.data != null) {
            byte[] bytes = new byte[this.data.length];
            System.arraycopy(this.data, 0, bytes, 0, this.data.length);
            return bytes;
        }
        return this.fileToByteArray();
    }

    public InputStream getAsStream() throws IOException {
        this.spoolInputStream();
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.spoolFile != null) {
            return new FileInputStream(this.spoolFile);
        }
        throw new NullPointerException("Null Stream data ");
    }

    public long getLength() {
        this.spoolInputStream();
        if (this.data == null) {
            return this.spoolFile.length();
        }
        return this.data.length;
    }

    public boolean isByteArray() {
        this.spoolInputStream();
        return this.data != null;
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        if (this.isByteArray()) {
            byte[] newBytes = new byte[this.data.length];
            System.arraycopy(this.data, 0, newBytes, 0, newBytes.length);
            try {
                return new TransientValueData(this.orderNumber, newBytes, null, null, this.fileCleaner, this.maxBufferSize, this.tempDirectory, this.deleteSpoolFile);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return this;
    }

    public EditableValueData createEditableCopy() throws RepositoryException {
        if (this.isByteArray()) {
            byte[] newBytes = new byte[this.data.length];
            System.arraycopy(this.data, 0, newBytes, 0, newBytes.length);
            try {
                return new EditableValueData(newBytes, this.orderNumber, this.fileCleaner, this.maxBufferSize, this.tempDirectory);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            EditableValueData copy = new EditableValueData(this.spoolFile, this.orderNumber, this.fileCleaner, this.maxBufferSize, this.tempDirectory);
            return copy;
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException("Create transient copy error. " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Create transient copy error. " + e, (Throwable)e);
        }
    }

    public long read(OutputStream stream, long length, long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Position must be higher or equals 0. But given " + position);
        }
        if (length < 0L) {
            throw new IOException("Length must be higher or equals 0. But given " + length);
        }
        this.spoolInputStream();
        if (this.isByteArray()) {
            if (position >= (long)this.data.length && position > 0L) {
                throw new IOException("Position " + position + " out of value size " + this.data.length);
            }
            if (position + length >= (long)this.data.length) {
                length = (long)this.data.length - position;
            }
            stream.write(this.data, (int)position, (int)length);
            return length;
        }
        if (this.spoolChannel == null) {
            this.spoolChannel = new FileInputStream(this.spoolFile).getChannel();
        }
        if (position >= this.spoolChannel.size() && position > 0L) {
            throw new IOException("Position " + position + " out of value size " + this.spoolChannel.size());
        }
        if (position + length >= this.spoolChannel.size()) {
            length = this.spoolChannel.size() - position;
        }
        MappedByteBuffer bb = this.spoolChannel.map(FileChannel.MapMode.READ_ONLY, position, length);
        WritableByteChannel ch = Channels.newChannel(stream);
        ch.write(bb);
        ch.close();
        return length;
    }

    public File getSpoolFile() {
        this.spoolInputStream();
        return this.spoolFile;
    }

    public String getString() throws IOException {
        return new String(this.getAsByteArray(), "UTF-8");
    }

    public void setFileCleaner(FileCleaner cleaner) {
        this.fileCleaner = cleaner;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    protected void finalize() throws Throwable {
        if (this.spoolChannel != null) {
            this.spoolChannel.close();
        }
        if (this.spoolFile != null) {
            if (this.spoolFile instanceof SpoolFile) {
                ((SpoolFile)this.spoolFile).release(this);
            }
            if (this.deleteSpoolFile && this.spoolFile.exists() && !this.spoolFile.delete()) {
                if (this.fileCleaner != null) {
                    this.fileCleaner.addFile(this.spoolFile);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Could not remove file. Add to fileCleaner " + this.spoolFile.getAbsolutePath()));
                    }
                } else {
                    log.warn((Object)("Could not remove temporary file on finalize " + this.spoolFile.getAbsolutePath()));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransientValueData) {
            TransientValueData other = (TransientValueData)obj;
            if (this.isByteArray() != other.isByteArray()) {
                return false;
            }
            try {
                if (this.isByteArray()) {
                    return Arrays.equals(this.getAsByteArray(), other.getAsByteArray());
                }
                return this.getSpoolFile().equals(other.getSpoolFile());
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private void spoolInputStream() {
        if (this.spooled || this.tmpStream == null) {
            return;
        }
        byte[] buffer = new byte[]{};
        byte[] tmpBuff = new byte[2048];
        int read = 0;
        int len = 0;
        SpoolFile sf = null;
        OutputStream sfout = null;
        try {
            while ((read = this.tmpStream.read(tmpBuff)) >= 0) {
                if (sfout != null) {
                    sfout.write(tmpBuff, 0, read);
                    len += read;
                    continue;
                }
                if (len + read > this.maxBufferSize && this.fileCleaner != null) {
                    sf = SpoolFile.createTempFile("jcrvd", null, this.tempDirectory);
                    sf.acquire(this);
                    sfout = new FileOutputStream(sf);
                    sfout.write(buffer, 0, len);
                    sfout.write(tmpBuff, 0, read);
                    buffer = null;
                    len += read;
                    continue;
                }
                byte[] newBuffer = new byte[len + read];
                System.arraycopy(buffer, 0, newBuffer, 0, len);
                System.arraycopy(tmpBuff, 0, newBuffer, len, read);
                buffer = newBuffer;
                len += read;
            }
            if (sf != null) {
                sfout.close();
                this.spoolFile = sf;
                this.data = null;
            } else {
                this.spoolFile = null;
                this.data = buffer;
            }
            this.tmpStream = null;
            this.spooled = true;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fileToByteArray() throws IOException {
        ByteBuffer bb;
        FileChannel fch;
        block4: {
            byte[] byArray;
            fch = new FileInputStream(this.spoolFile).getChannel();
            if (log.isDebugEnabled() && fch.size() > (long)this.maxBufferSize) {
                log.warn((Object)("Potential lack of memory due to call getAsByteArray() on stream data exceeded " + fch.size() + " bytes"));
            }
            try {
                bb = ByteBuffer.allocate((int)fch.size());
                fch.read(bb);
                if (!bb.hasArray()) break block4;
                byArray = bb.array();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                fch.close();
                throw throwable;
            }
            fch.close();
            return byArray;
        }
        byte[] tmpb = new byte[bb.capacity()];
        bb.get(tmpb);
        byte[] byArray = tmpb;
        Object var6_6 = null;
        fch.close();
        return byArray;
    }

    public TransientValueData() {
        super(0);
        this.deleteSpoolFile = true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.isByteArray()) {
            out.writeInt(1);
            int f = this.data.length;
            out.writeInt(f);
            out.write(this.data);
        } else {
            out.writeInt(2);
        }
        out.writeInt(this.orderNumber);
        out.writeInt(this.maxBufferSize);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readInt();
        if (type == 1) {
            this.data = new byte[in.readInt()];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = in.readByte();
            }
        }
        this.orderNumber = in.readInt();
        this.maxBufferSize = in.readInt();
    }

    public void setStream(InputStream in) {
        this.spooled = false;
        this.tmpStream = in;
    }
}

