/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class FileStreamPersistedValueData
extends AbstractValueData {
    protected final File file;

    public FileStreamPersistedValueData(File file, int orderNumber) {
        super(orderNumber);
        this.file = file;
    }

    public InputStream getAsStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public byte[] getAsByteArray() throws IllegalStateException {
        throw new IllegalStateException("It is illegal to call on FileStreamPersistedValueData due to potential lack of memory");
    }

    public long getLength() {
        return this.file.length();
    }

    public boolean isByteArray() {
        return false;
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        try {
            return new TransientValueData(this.orderNumber, null, null, this.file, null, -1, null, false);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

