/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

public class TreeFile
extends File {
    private static Log fLog = ExoLogger.getLogger((String)"jcr.TreeFile");
    private static final long serialVersionUID = 5125295927077006487L;
    private final FileCleaner cleaner;
    private final File rootDir;

    TreeFile(String fileName, FileCleaner cleaner, File rootDir) {
        super(fileName);
        this.cleaner = cleaner;
        this.rootDir = rootDir;
    }

    public boolean delete() {
        boolean res = super.delete();
        if (res) {
            this.deleteParent(new File(this.getParent()));
        }
        return res;
    }

    protected boolean deleteParent(File fp) {
        String rootPath;
        boolean res = false;
        String fpPath = fp.getAbsolutePath();
        if (fpPath.startsWith(rootPath = this.rootDir.getAbsolutePath()) && fpPath.length() > rootPath.length()) {
            if (fp.isDirectory()) {
                String[] ls = fp.list();
                if (ls.length <= 0) {
                    res = fp.delete();
                    if (res) {
                        res = this.deleteParent(new File(fp.getParent()));
                    } else {
                        fLog.warn((Object)("Parent directory can not be deleted now. " + fp.getAbsolutePath()));
                        this.cleaner.addFile(new TreeFile(fp.getAbsolutePath(), this.cleaner, this.rootDir));
                    }
                }
            } else {
                fLog.warn((Object)("Parent can not be a file but found " + fp.getAbsolutePath()));
            }
        }
        return res;
    }
}

