/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.observation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.SessionLifecycleListener;
import org.exoplatform.services.jcr.impl.core.observation.ListenerCriteria;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.util.EntityCollection;

public class ObservationManagerImpl
implements ObservationManager,
SessionLifecycleListener {
    protected String sessionId;
    private List<EventListener> sessionListeners = new ArrayList<EventListener>();
    private ObservationManagerRegistry registry;

    ObservationManagerImpl(ObservationManagerRegistry registry, String sessionId) {
        this.sessionId = sessionId;
        this.registry = registry;
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        this.registry.addEventListener(listener, new ListenerCriteria(eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal, this.sessionId));
        this.sessionListeners.add(listener);
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        this.registry.removeEventListener(listener);
        this.sessionListeners.remove(listener);
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        return new EntityCollection(new ArrayList<EventListener>(this.sessionListeners));
    }

    public void onCloseSession(ExtendedSession targetSession) {
    }
}

