/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.value.EditableBinaryValue;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.EditableValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

public class BinaryValue
extends BaseValue
implements EditableBinaryValue {
    public static final int TYPE = 2;
    protected EditableValueData changedData = null;
    protected boolean changed = false;
    protected static Log log = ExoLogger.getLogger((String)"jcr.BinaryValue");

    public BinaryValue(String text) throws IOException {
        super(2, new TransientValueData(text));
    }

    public BinaryValue(InputStream stream, FileCleaner fileCleaner, File tempDirectory, int maxFufferSize) throws IOException {
        this(new TransientValueData(stream), fileCleaner, tempDirectory, maxFufferSize);
    }

    BinaryValue(TransientValueData data) throws IOException {
        super(2, data);
    }

    BinaryValue(TransientValueData data, FileCleaner fileCleaner, File tempDirectory, int maxFufferSize) throws IOException {
        super(2, data);
        this.internalData.setFileCleaner(fileCleaner);
        this.internalData.setTempDirectory(tempDirectory);
        this.internalData.setMaxBufferSize(maxFufferSize);
    }

    public TransientValueData getInternalData() {
        if (this.changedData != null) {
            return this.changedData;
        }
        return super.getInternalData();
    }

    protected BaseValue.LocalTransientValueData getLocalData(boolean asStream) throws IOException {
        if (this.changed) {
            this.data = null;
            this.changed = false;
        }
        return super.getLocalData(asStream);
    }

    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getInternalString();
    }

    public void update(InputStream stream, long length, long position) throws IOException, RepositoryException {
        if (this.changedData == null) {
            this.changedData = this.getInternalData().createEditableCopy();
        }
        this.changedData.update(stream, length, position);
        this.changed = true;
    }

    public void setLength(long size) throws IOException, RepositoryException {
        if (this.changedData == null) {
            this.changedData = this.getInternalData().createEditableCopy();
        }
        this.changedData.setLength(size);
        this.changed = true;
    }
}

