/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class DISCARD
extends Protocol {
    final Vector members = new Vector();
    double up = 0.0;
    double down = 0.0;
    boolean excludeItself = false;
    Address localAddress;
    int num_down = 0;
    int num_up = 0;
    final Set<Address> ignoredMembers = new HashSet<Address>();

    public String getName() {
        return "DISCARD";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("up");
        if (str != null) {
            this.up = Double.parseDouble(str);
            props.remove("up");
        }
        if ((str = props.getProperty("down")) != null) {
            this.down = Double.parseDouble(str);
            props.remove("down");
        }
        if ((str = props.getProperty("excludeitself")) != null) {
            this.excludeItself = Boolean.valueOf(str);
            props.remove("excludeitself");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("DISCARD.setProperties(): these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void addIgnoreMember(Address sender) {
        this.ignoredMembers.add(sender);
    }

    public void resetIgnoredMembers() {
        this.ignoredMembers.clear();
    }

    public Object up(Event evt) {
        if (evt.getType() == 8) {
            this.localAddress = (Address)evt.getArg();
        }
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            Address sender = msg.getSrc();
            DiscardHeader dh = (DiscardHeader)msg.getHeader(this.getName());
            if (dh != null) {
                this.ignoredMembers.clear();
                this.ignoredMembers.addAll(dh.dropMessages);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("will potentially drop messages from " + this.ignoredMembers));
                }
            } else {
                double r;
                boolean dropMessage = this.ignoredMembers.contains(sender);
                if (dropMessage) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("dropping message from " + sender));
                    }
                    ++this.num_up;
                    return null;
                }
                if (this.up > 0.0 && (r = Math.random()) < this.up) {
                    if (this.excludeItself && sender.equals(this.localAddress)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"excluding itself");
                        }
                    } else {
                        dropMessage = this.ignoredMembers.contains(sender);
                        if (dropMessage) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("dropping message from " + sender));
                            }
                            ++this.num_up;
                            return null;
                        }
                    }
                }
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        if (evt.getType() == 1) {
            double r;
            Message msg = (Message)evt.getArg();
            if (this.down > 0.0 && (r = Math.random()) < this.down) {
                if (this.excludeItself && msg.getSrc().equals(this.localAddress)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"excluding itself");
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"dropping message");
                    }
                    ++this.num_down;
                    return null;
                }
            }
        }
        return this.down_prot.down(evt);
    }

    public void resetStats() {
        super.resetStats();
        this.num_up = 0;
        this.num_down = 0;
    }

    public Map dumpStats() {
        HashMap<String, Integer> m = new HashMap<String, Integer>(2);
        m.put("num_dropped_down", new Integer(this.num_down));
        m.put("num_dropped_up", new Integer(this.num_up));
        return m;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiscardHeader
    extends Header
    implements Streamable {
        private final Set<Address> dropMessages;

        public DiscardHeader() {
            this.dropMessages = new HashSet<Address>();
        }

        public DiscardHeader(Set<Address> ignoredAddresses) {
            this.dropMessages = ignoredAddresses;
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int size = in.readShort();
            if (size > 0) {
                this.dropMessages.clear();
                for (int i = 0; i < size; ++i) {
                    this.dropMessages.add(Util.readAddress(in));
                }
            }
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            if (this.dropMessages != null && !this.dropMessages.isEmpty()) {
                out.writeShort(this.dropMessages.size());
                for (Address addr : this.dropMessages) {
                    Util.writeAddress(addr, out);
                }
            } else {
                out.writeShort(0);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Set tmp = (Set)in.readObject();
            this.dropMessages.clear();
            this.dropMessages.addAll(tmp);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.dropMessages);
        }
    }
}

