/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log;

import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.LogService;

public class LogUtil {
    private static Log defaultInstance_ = null;

    public static Log getLog(String category) {
        ExoContainer manager = ExoContainerContext.getTopContainer();
        LogService service = (LogService)manager.getComponentInstanceOfType(LogService.class);
        Log log = service.getLog(category);
        return log;
    }

    public static Log getLog(Class clazz) {
        ExoContainer manager = ExoContainerContext.getTopContainer();
        LogService service = (LogService)manager.getComponentInstanceOfType(LogService.class);
        Log log = service.getLog(clazz);
        return log;
    }

    public static void setLevel(String category, int level, boolean recursive) throws Exception {
        ExoContainer manager = ExoContainerContext.getTopContainer();
        LogService service = (LogService)manager.getComponentInstanceOfType(LogService.class);
        service.setLogLevel(category, level, recursive);
    }

    public static void debug(String msg) {
        LogUtil.getDefault().debug((Object)msg);
    }

    public static void debug(String msg, Throwable t) {
        LogUtil.getDefault().debug((Object)msg, t);
    }

    public static void info(String msg) {
        LogUtil.getDefault().info((Object)msg);
    }

    public static void info(String msg, Throwable t) {
        LogUtil.getDefault().info((Object)msg, t);
    }

    public static void warn(String msg) {
        LogUtil.getDefault().warn((Object)msg);
    }

    public static void warn(String msg, Throwable t) {
        LogUtil.getDefault().warn((Object)msg, t);
    }

    public static void error(String msg) {
        LogUtil.getDefault().error((Object)msg);
    }

    public static void error(String msg, Throwable t) {
        LogUtil.getDefault().error((Object)msg, t);
    }

    public static final Log getDefault() {
        if (defaultInstance_ == null) {
            defaultInstance_ = LogUtil.getLog("default");
        }
        return defaultInstance_;
    }
}

