/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexMerger;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueueStore;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Recovery;
import org.exoplatform.services.jcr.impl.core.query.lucene.RedoLog;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.VolatileIndex;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIndex {
    private static final Log log = ExoLogger.getLogger(MultiIndex.class);
    private static final String REDO_LOG = "redo.log";
    private static final String INDEXING_QUEUE_FILE = "indexing_queue.log";
    private final IndexInfos indexNames = new IndexInfos("indexes");
    private final IndexInfos deletable = new IndexInfos("deletable");
    private final List<PersistentIndex> indexes = new ArrayList<PersistentIndex>();
    private final NamespaceMappings nsMappings;
    private final File indexDir;
    private final SearchIndex handler;
    private VolatileIndex volatileIndex;
    private boolean updateInProgress = false;
    private CachingMultiIndexReader multiReader;
    private final DocNumberCache cache;
    private final Object updateMonitor = new Object();
    private boolean redoLogApplied = false;
    private long lastFlushTime;
    private final IndexMerger merger;
    private static final Timer FLUSH_TIMER = new Timer(true);
    private final TimerTask flushTask;
    private final RedoLog redoLog;
    private IndexingQueue indexingQueue;
    private long nextTransactionId = 0L;
    private long currentTransactionId = -1L;
    private boolean reindexing = false;
    private final IndexFormatVersion version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MultiIndex(File indexDir, SearchIndex handler, NamespaceMappings mapping) throws IOException {
        this.indexDir = indexDir;
        this.handler = handler;
        this.cache = new DocNumberCache(handler.getQueryHandlerConfig().getCacheSize());
        this.redoLog = new RedoLog(new File(indexDir, REDO_LOG));
        log.info((Object)("Index dir = " + indexDir.getAbsolutePath()));
        log.info((Object)("Redo log = " + new File(indexDir, REDO_LOG).getAbsoluteFile()));
        this.nsMappings = mapping;
        if (this.indexNames.exists(indexDir)) {
            this.indexNames.read(indexDir);
        }
        if (this.deletable.exists(indexDir)) {
            this.deletable.read(indexDir);
        }
        this.attemptDelete();
        this.merger = new IndexMerger(this);
        this.merger.setMaxMergeDocs(handler.getQueryHandlerConfig().getMaxMergeDocs());
        this.merger.setMergeFactor(handler.getQueryHandlerConfig().getMergeFactor());
        this.merger.setMinMergeDocs(handler.getQueryHandlerConfig().getMinMergeDocs());
        this.indexingQueue = new IndexingQueue(new IndexingQueueStore(indexDir, INDEXING_QUEUE_FILE), this);
        for (int i = 0; i < this.indexNames.size(); ++i) {
            File sub = new File(indexDir, this.indexNames.getName(i));
            if (!sub.exists()) {
                log.debug((Object)("index does not exist anymore: " + sub.getAbsolutePath()));
                continue;
            }
            PersistentIndex index = new PersistentIndex(this.indexNames.getName(i), sub, handler.getTextAnalyzer(), this.cache, this.indexingQueue);
            index.setMaxMergeDocs(handler.getQueryHandlerConfig().getMaxMergeDocs());
            index.setMergeFactor(handler.getQueryHandlerConfig().getMergeFactor());
            index.setMinMergeDocs(handler.getQueryHandlerConfig().getMinMergeDocs());
            index.setMaxFieldLength(handler.getQueryHandlerConfig().getMaxFieldLength());
            index.setUseCompoundFile(handler.getQueryHandlerConfig().getUseCompoundFile());
            this.indexes.add(index);
            this.merger.indexAdded(index.getName(), index.getNumDocuments());
        }
        this.resetVolatileIndex();
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            this.version = IndexFormatVersion.getVersion((IndexReader)reader);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        this.redoLogApplied = this.redoLog.hasEntries();
        Recovery.run(this, this.redoLog);
        this.merger.start();
        if (this.redoLogApplied) {
            block19: {
                Object object;
                try {
                    try {
                        this.merger.waitUntilIdle();
                    }
                    catch (InterruptedException e) {
                        Object var10_13 = null;
                        Object object3 = this.updateMonitor;
                        synchronized (object3) {
                            this.updateInProgress = false;
                            this.updateMonitor.notifyAll();
                            if (this.multiReader != null) {
                                this.multiReader.close();
                                this.multiReader = null;
                            }
                            break block19;
                        }
                    }
                    Object var10_12 = null;
                    object = this.updateMonitor;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    Object object2 = this.updateMonitor;
                    synchronized (object2) {
                        this.updateInProgress = false;
                        this.updateMonitor.notifyAll();
                        if (this.multiReader != null) {
                            this.multiReader.close();
                            this.multiReader = null;
                        }
                        throw throwable;
                    }
                }
                synchronized (object) {
                    this.updateInProgress = false;
                    this.updateMonitor.notifyAll();
                    if (this.multiReader != null) {
                        this.multiReader.close();
                        this.multiReader = null;
                    }
                }
            }
            this.flush();
        }
        this.flushTask = new TimerTask(){

            public void run() {
                MultiIndex.this.checkIndexingQueue();
                MultiIndex.this.checkFlush();
            }
        };
        if (this.indexNames.size() > 0) {
            this.scheduleFlushTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numDocs() throws IOException {
        int n;
        if (this.indexNames.size() == 0) {
            return this.volatileIndex.getNumDocuments();
        }
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            n = reader.numDocs();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return n;
    }

    IndexFormatVersion getIndexFormatVersion() {
        return this.version;
    }

    void createInitialIndex(ItemDataConsumer stateMgr, String rootId) throws IOException {
        block5: {
            if (this.indexNames.size() == 0) {
                this.reindexing = true;
                try {
                    try {
                        this.executeAndLog(new Start(-1L));
                        NodeData rootState = (NodeData)stateMgr.getItemData(rootId);
                        this.createIndex(rootState, stateMgr);
                        this.executeAndLog(new Commit(this.getTransactionId()));
                        this.scheduleFlushTask();
                    }
                    catch (Exception e) {
                        String msg = "Error indexing workspace";
                        IOException ex = new IOException(msg);
                        ex.initCause(e);
                        throw ex;
                    }
                    Object var7_5 = null;
                    this.reindexing = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.reindexing = false;
                    throw throwable;
                }
            }
            throw new IllegalStateException("Index already present");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update(Iterator<String> remove, Iterator<Document> add) throws IOException {
        Object object;
        Object object2 = this.updateMonitor;
        synchronized (object2) {
            this.updateInProgress = true;
        }
        try {
            long transactionId = this.nextTransactionId++;
            this.executeAndLog(new Start(transactionId));
            boolean flush = false;
            while (remove.hasNext()) {
                this.executeAndLog(new DeleteNode(transactionId, remove.next()));
            }
            while (add.hasNext()) {
                Document doc = add.next();
                if (doc == null) continue;
                this.executeAndLog(new AddNode(transactionId, doc));
                flush |= this.checkVolatileCommit();
            }
            this.executeAndLog(new Commit(transactionId));
            if (flush) {
                this.flush();
            }
            Object var8_8 = null;
            object = this.updateMonitor;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Object object3 = this.updateMonitor;
            synchronized (object3) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                if (this.multiReader != null) {
                    this.multiReader.close();
                    this.multiReader = null;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.updateInProgress = false;
            this.updateMonitor.notifyAll();
            if (this.multiReader != null) {
                this.multiReader.close();
                this.multiReader = null;
            }
        }
    }

    void addDocument(Document doc) throws IOException {
        List<Document> add = Arrays.asList(doc);
        this.update(EmptyIterator.INSTANCE, add.iterator());
    }

    void removeDocument(String uuid) throws IOException {
        List<String> remove = Arrays.asList(uuid);
        this.update(remove.iterator(), EmptyIterator.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int removeAllDocuments(String uuid) throws IOException {
        Object object;
        int num;
        Object object2 = this.updateMonitor;
        synchronized (object2) {
            this.updateInProgress = true;
        }
        try {
            Term idTerm = new Term(FieldNames.UUID, uuid.toString());
            this.executeAndLog(new Start(-1L));
            num = this.volatileIndex.removeDocument(idTerm);
            if (num > 0) {
                this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
            }
            for (int i = 0; i < this.indexes.size(); ++i) {
                PersistentIndex index = this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                int removed = index.removeDocument(idTerm);
                if (removed > 0) {
                    this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
                }
                num += removed;
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
            Object var8_9 = null;
            object = this.updateMonitor;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Object object3 = this.updateMonitor;
            synchronized (object3) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                if (this.multiReader != null) {
                    this.multiReader.close();
                    this.multiReader = null;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.updateInProgress = false;
            this.updateMonitor.notifyAll();
            if (this.multiReader != null) {
                this.multiReader.close();
                this.multiReader = null;
            }
        }
        return num;
    }

    synchronized IndexReader[] getIndexReaders(String[] indexNames, IndexListener listener) throws IOException {
        HashSet<String> names = new HashSet<String>(Arrays.asList(indexNames));
        HashMap<ReadOnlyIndexReader, PersistentIndex> indexReaders = new HashMap<ReadOnlyIndexReader, PersistentIndex>();
        try {
            for (PersistentIndex index : this.indexes) {
                if (!names.contains(index.getName())) continue;
                indexReaders.put(index.getReadOnlyIndexReader(listener), index);
            }
        }
        catch (IOException e) {
            for (ReadOnlyIndexReader reader : indexReaders.keySet()) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    log.warn((Object)("Exception closing index reader: " + ex));
                }
                ((PersistentIndex)indexReaders.get((Object)reader)).resetListener();
            }
            throw e;
        }
        return indexReaders.keySet().toArray(new IndexReader[indexReaders.size()]);
    }

    synchronized PersistentIndex getOrCreateIndex(String indexName) throws IOException {
        File sub;
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return idx;
        }
        if (indexName == null) {
            sub = this.newIndexFolder();
            indexName = sub.getName();
        } else {
            sub = new File(this.indexDir, indexName);
        }
        PersistentIndex index = new PersistentIndex(indexName, sub, this.handler.getTextAnalyzer(), this.cache, this.indexingQueue);
        index.setMaxMergeDocs(this.handler.getQueryHandlerConfig().getMaxMergeDocs());
        index.setMergeFactor(this.handler.getQueryHandlerConfig().getMergeFactor());
        index.setMinMergeDocs(this.handler.getQueryHandlerConfig().getMinMergeDocs());
        index.setMaxFieldLength(this.handler.getQueryHandlerConfig().getMaxFieldLength());
        index.setUseCompoundFile(this.handler.getQueryHandlerConfig().getUseCompoundFile());
        this.indexes.add(index);
        return index;
    }

    synchronized boolean hasIndex(String indexName) {
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return true;
        }
        return new File(this.indexDir, indexName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceIndexes(String[] obsoleteIndexes, PersistentIndex index, Collection<Term> deleted) throws IOException {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            Object object;
            Object object2 = this.updateMonitor;
            synchronized (object2) {
                this.updateInProgress = true;
            }
            try {
                if (!this.reindexing) {
                    this.executeAndLog(new Start(-2L));
                }
                HashSet<String> names = new HashSet<String>(Arrays.asList(obsoleteIndexes));
                for (String indexName : names) {
                    if (!this.indexNames.contains(indexName)) continue;
                    this.executeAndLog(new DeleteIndex(this.getTransactionId(), indexName));
                }
                this.executeAndLog(new CreateIndex(this.getTransactionId(), index.getName()));
                this.executeAndLog(new AddIndex(this.getTransactionId(), index.getName()));
                for (Term id : deleted) {
                    index.removeDocument(id);
                }
                index.commit();
                if (!this.reindexing) {
                    this.executeAndLog(new Commit(this.getTransactionId()));
                }
                Object var9_9 = null;
                object = this.updateMonitor;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Object object3 = this.updateMonitor;
                synchronized (object3) {
                    this.updateInProgress = false;
                    this.updateMonitor.notifyAll();
                    if (this.multiReader != null) {
                        this.multiReader.close();
                        this.multiReader = null;
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                if (this.multiReader != null) {
                    this.multiReader.close();
                    this.multiReader = null;
                }
            }
        }
        if (this.reindexing) {
            this.attemptDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachingMultiIndexReader getIndexReader() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            if (this.multiReader != null) {
                this.multiReader.incrementRefCount();
                return this.multiReader;
            }
            while (this.updateInProgress) {
                try {
                    this.updateMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting to aquire reader");
                }
            }
            if (this.multiReader == null) {
                ArrayList<ReadOnlyIndexReader> readerList = new ArrayList<ReadOnlyIndexReader>();
                for (int i = 0; i < this.indexes.size(); ++i) {
                    PersistentIndex pIdx = this.indexes.get(i);
                    if (!this.indexNames.contains(pIdx.getName())) continue;
                    readerList.add(pIdx.getReadOnlyIndexReader());
                }
                readerList.add(this.volatileIndex.getReadOnlyIndexReader());
                ReadOnlyIndexReader[] readers = readerList.toArray(new ReadOnlyIndexReader[readerList.size()]);
                this.multiReader = new CachingMultiIndexReader(readers, this.cache);
            }
            this.multiReader.incrementRefCount();
            return this.multiReader;
        }
    }

    VolatileIndex getVolatileIndex() {
        return this.volatileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.merger.dispose();
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            this.flushTask.cancel();
            if (this.multiReader != null) {
                try {
                    this.multiReader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Exception while closing search index.", (Throwable)e);
                }
                this.multiReader = null;
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                log.error((Object)"Exception while closing search index.", (Throwable)e);
            }
            this.volatileIndex.close();
            for (int i = 0; i < this.indexes.size(); ++i) {
                this.indexes.get(i).close();
            }
            try {
                this.indexingQueue.close();
            }
            catch (IOException e) {
                log.error((Object)"Exception while closing search index.", (Throwable)e);
            }
        }
    }

    NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    Document createDocument(NodeData node) throws RepositoryException {
        return this.handler.createDocument(node, this.nsMappings, this.version);
    }

    Document createDocument(String id) throws RepositoryException {
        ItemData data = this.handler.getContext().getItemStateManager().getItemData(id);
        if (data == null) {
            throw new ItemNotFoundException("Item id=" + id + " not found");
        }
        if (!data.isNode()) {
            throw new RepositoryException("Item with id " + id + " is not a node");
        }
        return this.createDocument((NodeData)data);
    }

    boolean getRedoLogApplied() {
        return this.redoLogApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteIndex(PersistentIndex index) {
        this.indexes.remove(index);
        this.indexNames.removeName(index.getName());
        IndexInfos indexInfos = this.deletable;
        synchronized (indexInfos) {
            if (!this.deletable.contains(index.getName())) {
                this.deletable.addName(index.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            this.executeAndLog(new Start(-1L));
            this.commitVolatileIndex();
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                PersistentIndex index = this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                index.commit();
                if (index.getNumDocuments() != 0) continue;
                this.executeAndLog(new DeleteIndex(this.getTransactionId(), index.getName()));
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
            this.indexNames.write(this.indexDir);
            this.redoLog.clear();
            this.lastFlushTime = System.currentTimeMillis();
        }
        this.attemptDelete();
    }

    private void scheduleFlushTask() {
        this.lastFlushTime = System.currentTimeMillis();
        FLUSH_TIMER.schedule(this.flushTask, 0L, 1000L);
    }

    private void resetVolatileIndex() throws IOException {
        this.volatileIndex = new VolatileIndex(this.handler.getTextAnalyzer(), this.indexingQueue);
        this.volatileIndex.setUseCompoundFile(this.handler.getQueryHandlerConfig().getUseCompoundFile());
        this.volatileIndex.setMaxFieldLength(this.handler.getQueryHandlerConfig().getMaxFieldLength());
        this.volatileIndex.setBufferSize(this.handler.getQueryHandlerConfig().getBufferSize());
    }

    private long getTransactionId() {
        return this.currentTransactionId;
    }

    private Action executeAndLog(Action a) throws IOException {
        a.execute(this);
        this.redoLog.append(a);
        if (a.getType() == 3 || a.getType() == 6) {
            this.redoLog.flush();
            this.indexingQueue.commit();
        }
        return a;
    }

    private boolean checkVolatileCommit() throws IOException {
        if (this.volatileIndex.getNumDocuments() >= this.handler.getQueryHandlerConfig().getMinMergeDocs()) {
            this.commitVolatileIndex();
            return true;
        }
        return false;
    }

    private void commitVolatileIndex() throws IOException {
        if (this.volatileIndex.getNumDocuments() > 0) {
            long time = System.currentTimeMillis();
            CreateIndex create = new CreateIndex(this.getTransactionId(), null);
            this.executeAndLog(create);
            this.executeAndLog(new VolatileCommit(this.getTransactionId(), create.getIndexName()));
            AddIndex add = new AddIndex(this.getTransactionId(), create.getIndexName());
            this.executeAndLog(add);
            this.resetVolatileIndex();
            time = System.currentTimeMillis() - time;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committed in-memory index in " + time + "ms."));
            }
        }
    }

    private void createIndex(NodeData node, ItemDataConsumer stateMgr) throws IOException, RepositoryException {
        String id = node.getIdentifier();
        this.executeAndLog(new AddNode(this.getTransactionId(), id));
        this.checkVolatileCommit();
        List<NodeData> children = stateMgr.getChildNodesData(node);
        for (NodeData nodeData : children) {
            this.createIndex(nodeData, stateMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDelete() {
        IndexInfos indexInfos = this.deletable;
        synchronized (indexInfos) {
            for (int i = this.deletable.size() - 1; i >= 0; --i) {
                String indexName = this.deletable.getName(i);
                File dir = new File(this.indexDir, indexName);
                if (this.deleteIndex(dir)) {
                    this.deletable.removeName(i);
                    continue;
                }
                log.info((Object)("Unable to delete obsolete index: " + indexName));
            }
            try {
                this.deletable.write(this.indexDir);
            }
            catch (IOException e) {
                log.warn((Object)("Exception while writing deletable indexes: " + e));
            }
        }
    }

    private boolean deleteIndex(File directory) {
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].delete()) continue;
            return false;
        }
        return directory.delete();
    }

    private File newIndexFolder() throws IOException {
        File sub;
        while ((sub = new File(this.indexDir, this.indexNames.newName())).exists()) {
        }
        if (!sub.mkdir()) {
            throw new IOException("Unable to create directory: " + sub.getAbsolutePath());
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkFlush() {
        block15: {
            long idleTime = System.currentTimeMillis() - this.lastFlushTime;
            if (this.handler.getQueryHandlerConfig().getVolatileIdleTime() > 0 && idleTime > (long)(this.handler.getQueryHandlerConfig().getVolatileIdleTime() * 1000)) {
                try {
                    Object object;
                    if (!this.redoLog.hasEntries()) break block15;
                    log.debug((Object)("Flushing index after being idle for " + idleTime + " ms."));
                    Object object2 = this.updateMonitor;
                    synchronized (object2) {
                        this.updateInProgress = true;
                    }
                    try {
                        this.flush();
                        Object var6_5 = null;
                        object = this.updateMonitor;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        Object object3 = this.updateMonitor;
                        synchronized (object3) {
                            this.updateInProgress = false;
                            this.updateMonitor.notifyAll();
                            if (this.multiReader != null) {
                                this.multiReader.close();
                                this.multiReader = null;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        this.updateInProgress = false;
                        this.updateMonitor.notifyAll();
                        if (this.multiReader != null) {
                            this.multiReader.close();
                            this.multiReader = null;
                        }
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Unable to commit volatile index" + e), (Throwable)e);
                }
            }
        }
    }

    private synchronized void checkIndexingQueue() {
        Document[] docs = this.indexingQueue.getFinishedDocuments();
        HashMap<String, Document> finished = new HashMap<String, Document>();
        for (int i = 0; i < docs.length; ++i) {
            String uuid = docs[i].get(FieldNames.UUID);
            finished.put(uuid, docs[i]);
        }
        if (!finished.isEmpty()) {
            log.debug((Object)("updating index with " + new Long(finished.size()) + " nodes from indexing queue."));
            Iterator it = finished.keySet().iterator();
            while (it.hasNext()) {
                try {
                    this.indexingQueue.removeDocument((String)it.next());
                }
                catch (IOException e) {
                    log.error((Object)("Failed to remove node from indexing queue" + e));
                }
            }
            try {
                this.update(finished.keySet().iterator(), finished.values().iterator());
            }
            catch (IOException e) {
                log.warn((Object)("Failed to update index with deferred text extraction" + e));
            }
        }
    }

    File getIndexDir() {
        return this.indexDir;
    }

    private static class VolatileCommit
    extends Action {
        private final String targetIndex;

        VolatileCommit(long transactionId, String targetIndex) {
            super(transactionId, 4);
            this.targetIndex = targetIndex;
        }

        static VolatileCommit fromString(long transactionId, String arguments) {
            return new VolatileCommit(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            VolatileIndex volatileIndex = index.getVolatileIndex();
            PersistentIndex persistentIndex = index.getOrCreateIndex(this.targetIndex);
            persistentIndex.copyIndex(volatileIndex);
            index.resetVolatileIndex();
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("VOL_COM");
            logLine.append(' ');
            logLine.append(this.targetIndex);
            return logLine.toString();
        }
    }

    private static class Start
    extends Action {
        Start(long transactionId) {
            super(transactionId, 0);
        }

        static Start fromString(long transactionId, String arguments) {
            return new Start(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.currentTransactionId = this.getTransactionId();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "STR";
        }
    }

    private static class DeleteNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "DEL".length() + 32 + 2;
        private final String uuid;

        DeleteNode(long transactionId, String uuid) {
            super(transactionId, 2);
            this.uuid = uuid;
        }

        static DeleteNode fromString(long transactionId, String arguments) {
            if (arguments.length() != 32) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new DeleteNode(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            String uuidString = this.uuid;
            Document doc = index.indexingQueue.removeDocument(uuidString);
            if (doc != null) {
                Util.disposeDocument(doc);
            }
            Term idTerm = new Term(FieldNames.UUID, uuidString);
            int num = index.volatileIndex.removeDocument(idTerm);
            if (num == 0) {
                for (int i = index.indexes.size() - 1; i >= 0; --i) {
                    PersistentIndex idx = (PersistentIndex)index.indexes.get(i);
                    if (!index.indexNames.contains(idx.getName()) || (num = idx.removeDocument(idTerm)) <= 0) continue;
                    return;
                }
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class DeleteIndex
    extends Action {
        private String indexName;

        DeleteIndex(long transactionId, String indexName) {
            super(transactionId, 7);
            this.indexName = indexName;
        }

        static DeleteIndex fromString(long transactionId, String arguments) {
            return new DeleteIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            for (PersistentIndex idx : index.indexes) {
                if (!idx.getName().equals(this.indexName)) continue;
                idx.close();
                index.deleteIndex(idx);
                break;
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    private static class CreateIndex
    extends Action {
        private String indexName;

        CreateIndex(long transactionId, String indexName) {
            super(transactionId, 5);
            this.indexName = indexName;
        }

        static CreateIndex fromString(long transactionId, String arguments) {
            return new CreateIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            this.indexName = idx.getName();
        }

        public void undo(MultiIndex index) throws IOException {
            if (index.hasIndex(this.indexName)) {
                PersistentIndex idx = index.getOrCreateIndex(this.indexName);
                idx.close();
                index.deleteIndex(idx);
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("CRE_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }

        String getIndexName() {
            return this.indexName;
        }
    }

    private static class Commit
    extends Action {
        Commit(long transactionId) {
            super(transactionId, 3);
        }

        static Commit fromString(long transactionId, String arguments) {
            return new Commit(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.lastFlushTime = System.currentTimeMillis();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "COM";
        }
    }

    private static class AddNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "ADD".length() + 32 + 2;
        private final String uuid;
        private Document doc;

        AddNode(long transactionId, String uuid) {
            super(transactionId, 1);
            this.uuid = uuid;
        }

        AddNode(long transactionId, Document doc) {
            this(transactionId, doc.get(FieldNames.UUID));
            this.doc = doc;
        }

        static AddNode fromString(long transactionId, String arguments) throws IllegalArgumentException {
            if (arguments.length() != 32) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new AddNode(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            if (this.doc == null) {
                try {
                    this.doc = index.createDocument(this.uuid);
                }
                catch (RepositoryException e) {
                    log.debug((Object)e.getMessage());
                }
            }
            if (this.doc != null) {
                index.volatileIndex.addDocuments(new Document[]{this.doc});
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class AddIndex
    extends Action {
        private String indexName;

        AddIndex(long transactionId, String indexName) {
            super(transactionId, 6);
            this.indexName = indexName;
        }

        static AddIndex fromString(long transactionId, String arguments) {
            return new AddIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            if (!index.indexNames.contains(this.indexName)) {
                index.indexNames.addName(this.indexName);
                index.merger.indexAdded(this.indexName, idx.getNumDocuments());
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    public static abstract class Action {
        static final String START = "STR";
        public static final int TYPE_START = 0;
        static final String ADD_NODE = "ADD";
        public static final int TYPE_ADD_NODE = 1;
        static final String DELETE_NODE = "DEL";
        public static final int TYPE_DELETE_NODE = 2;
        static final String COMMIT = "COM";
        public static final int TYPE_COMMIT = 3;
        static final String VOLATILE_COMMIT = "VOL_COM";
        public static final int TYPE_VOLATILE_COMMIT = 4;
        static final String CREATE_INDEX = "CRE_IDX";
        public static final int TYPE_CREATE_INDEX = 5;
        static final String ADD_INDEX = "ADD_IDX";
        public static final int TYPE_ADD_INDEX = 6;
        static final String DELETE_INDEX = "DEL_IDX";
        public static final int TYPE_DELETE_INDEX = 7;
        static final long INTERNAL_TRANSACTION = -1L;
        static final long INTERNAL_TRANS_REPL_INDEXES = -2L;
        private final long transactionId;
        private final int type;

        Action(long transactionId, int type) {
            this.transactionId = transactionId;
            this.type = type;
        }

        long getTransactionId() {
            return this.transactionId;
        }

        int getType() {
            return this.type;
        }

        public abstract void execute(MultiIndex var1) throws IOException;

        public void undo(MultiIndex index) throws IOException {
        }

        public abstract String toString();

        static Action fromString(String line) throws IllegalArgumentException {
            Action a;
            long transactionId;
            int endTransIdx = line.indexOf(32);
            if (endTransIdx == -1) {
                throw new IllegalArgumentException(line);
            }
            try {
                transactionId = Long.parseLong(line.substring(0, endTransIdx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(line);
            }
            int endActionIdx = line.indexOf(32, endTransIdx + 1);
            if (endActionIdx == -1) {
                endActionIdx = line.length();
            }
            String actionLabel = line.substring(endTransIdx + 1, endActionIdx);
            String arguments = "";
            if (endActionIdx + 1 <= line.length()) {
                arguments = line.substring(endActionIdx + 1);
            }
            if (actionLabel.equals(ADD_NODE)) {
                a = AddNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(ADD_INDEX)) {
                a = AddIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(COMMIT)) {
                a = Commit.fromString(transactionId, arguments);
            } else if (actionLabel.equals(CREATE_INDEX)) {
                a = CreateIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_INDEX)) {
                a = DeleteIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_NODE)) {
                a = DeleteNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(START)) {
                a = Start.fromString(transactionId, arguments);
            } else if (actionLabel.equals(VOLATILE_COMMIT)) {
                a = VolatileCommit.fromString(transactionId, arguments);
            } else {
                throw new IllegalArgumentException(line);
            }
            return a;
        }
    }
}

