/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FileStreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;

public abstract class FileIOChannel
implements ValueIOChannel {
    private static Log log = ExoLogger.getLogger((String)"jcr.FileIOChannel");
    public static final int IOBUFFER_SIZE = 32768;
    protected final File rootDir;
    protected final FileCleaner cleaner;
    protected String storageId;

    public FileIOChannel(File rootDir, FileCleaner cleaner, String storageId) {
        this.rootDir = rootDir;
        this.cleaner = cleaner;
        this.storageId = storageId;
    }

    public boolean delete(String propertyId) throws IOException {
        boolean result = true;
        for (File valueFile : this.getFiles(propertyId)) {
            if (valueFile.delete()) continue;
            result = false;
            this.cleaner.addFile(valueFile);
        }
        return result;
    }

    public void close() {
    }

    public ValueData read(String propertyId, int orderNumber, int maxBufferSize) throws IOException {
        return this.readValue(this.getFile(propertyId, orderNumber), orderNumber, maxBufferSize);
    }

    public void write(String propertyId, ValueData value) throws IOException {
        this.writeValue(this.getFile(propertyId, value.getOrderNumber()), value);
    }

    protected abstract String makeFilePath(String var1, int var2);

    protected abstract File getFile(String var1, int var2) throws IOException;

    protected abstract File[] getFiles(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValue(File file, int orderNum, int maxBufferSize) throws IOException {
        ByteArrayPersistedValueData byteArrayPersistedValueData;
        long fileSize;
        FileInputStream is;
        block4: {
            is = new FileInputStream(file);
            fileSize = file.length();
            if (fileSize <= (long)maxBufferSize) break block4;
            FileStreamPersistedValueData fileStreamPersistedValueData = new FileStreamPersistedValueData(file, orderNum);
            Object var14_8 = null;
            is.close();
            return fileStreamPersistedValueData;
        }
        try {
            int buffSize = (int)fileSize;
            byte[] res = new byte[buffSize];
            int rpos = 0;
            int r = -1;
            byte[] buff = new byte[32768 > buffSize ? 32768 : buffSize];
            while ((r = is.read(buff)) >= 0) {
                System.arraycopy(buff, 0, res, rpos, r);
                rpos += r;
            }
            byteArrayPersistedValueData = new ByteArrayPersistedValueData(res, orderNum);
            Object var14_9 = null;
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return byteArrayPersistedValueData;
    }

    protected void writeValue(File file, ValueData value) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.writeOutput(out, value);
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutput(OutputStream out, ValueData value) throws IOException {
        if (value.isByteArray()) {
            byte[] buff = value.getAsByteArray();
            out.write(buff);
        } else {
            byte[] buffer = new byte[32768];
            InputStream in = value.getAsStream();
            try {
                int len;
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    public String getStorageId() {
        return this.storageId;
    }
}

