/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.afmparser.AFMParser;
import org.pdfbox.afmtypes.CharMetric;
import org.pdfbox.afmtypes.FontMetric;
import org.pdfbox.encoding.AFMEncoding;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.font.PDFontDescriptor;
import org.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.pdfbox.pdmodel.font.PDType1Font;
import org.pdfbox.pfb.PfbParser;

public class PDType1AfmPfbFont
extends PDType1Font {
    private static final int BUFFERSIZE = 65535;
    private PDFontDescriptorDictionary fd;
    private FontMetric metric;

    public PDType1AfmPfbFont(PDDocument doc, String afmname) throws IOException {
        BufferedInputStream afmin = new BufferedInputStream(new FileInputStream(afmname), 65535);
        String pfbname = afmname.replaceAll(".AFM", "").replaceAll(".afm", "") + ".pfb";
        BufferedInputStream pfbin = new BufferedInputStream(new FileInputStream(pfbname), 65535);
        this.load(doc, afmin, pfbin);
    }

    public PDType1AfmPfbFont(PDDocument doc, InputStream afm, InputStream pfb) throws IOException {
        this.load(doc, afm, pfb);
    }

    private void load(PDDocument doc, InputStream afm, InputStream pfb) throws IOException {
        this.fd = new PDFontDescriptorDictionary();
        this.setFontDescriptor(this.fd);
        PfbParser pfbparser = new PfbParser(pfb);
        pfb.close();
        PDStream fontStream = new PDStream(doc, pfbparser.getInputStream(), false);
        fontStream.getStream().setInt("Length", pfbparser.size());
        for (int i = 0; i < pfbparser.getLengths().length; ++i) {
            fontStream.getStream().setInt("Length" + (i + 1), pfbparser.getLengths()[i]);
        }
        fontStream.addCompression();
        this.fd.setFontFile(fontStream);
        AFMParser parser = new AFMParser(afm);
        parser.parse();
        this.metric = parser.getResult();
        this.setEncoding(new AFMEncoding(this.metric));
        this.setBaseFont(this.metric.getFontName());
        this.fd.setFontName(this.metric.getFontName());
        this.fd.setFontFamily(this.metric.getFamilyName());
        this.fd.setNonSymbolic(true);
        this.fd.setFontBoundingBox(new PDRectangle(this.metric.getFontBBox()));
        this.fd.setItalicAngle(this.metric.getItalicAngle());
        this.fd.setAscent(this.metric.getAscender());
        this.fd.setDescent(this.metric.getDescender());
        this.fd.setCapHeight(this.metric.getCapHeight());
        this.fd.setXHeight(this.metric.getXHeight());
        this.fd.setAverageWidth(this.metric.getAverageCharacterWidth());
        this.fd.setCharacterSet(this.metric.getCharacterSet());
        int firstchar = 255;
        int lastchar = 0;
        List listmetric = this.metric.getCharMetrics();
        int maxWidths = 256;
        ArrayList<Number> widths = new ArrayList<Number>(maxWidths);
        Integer zero = new Integer(0);
        for (CharMetric m : listmetric) {
            int n = m.getCharacterCode();
            if (n <= 0) continue;
            firstchar = Math.min(firstchar, n);
            lastchar = Math.max(lastchar, n);
            if (m.getWx() > 0.0f) {
                float width = m.getWx();
                widths.add(new Float(width));
                continue;
            }
            widths.add(zero);
        }
        this.setFirstChar(firstchar);
        this.setLastChar(lastchar);
        this.setWidths(widths);
    }

    public PDFontDescriptor getFontDescriptor() throws IOException {
        return this.fd;
    }
}

