/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class TBSCertList
extends ASN1Encodable {
    ASN1Sequence seq;
    DERInteger version;
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time thisUpdate;
    Time nextUpdate;
    CRLEntry[] revokedCertificates;
    X509Extensions crlExtensions;

    public static TBSCertList getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertList.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertList getInstance(Object object) {
        if (object instanceof TBSCertList) {
            return (TBSCertList)object;
        }
        if (object instanceof ASN1Sequence) {
            return new TBSCertList((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public TBSCertList(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 3 || aSN1Sequence.size() > 7) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        int n = 0;
        this.seq = aSN1Sequence;
        this.version = aSN1Sequence.getObjectAt(n) instanceof DERInteger ? DERInteger.getInstance(aSN1Sequence.getObjectAt(n++)) : new DERInteger(0);
        this.signature = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n++));
        this.issuer = X509Name.getInstance(aSN1Sequence.getObjectAt(n++));
        this.thisUpdate = Time.getInstance(aSN1Sequence.getObjectAt(n++));
        if (n < aSN1Sequence.size() && (aSN1Sequence.getObjectAt(n) instanceof DERUTCTime || aSN1Sequence.getObjectAt(n) instanceof DERGeneralizedTime || aSN1Sequence.getObjectAt(n) instanceof Time)) {
            this.nextUpdate = Time.getInstance(aSN1Sequence.getObjectAt(n++));
        }
        if (n < aSN1Sequence.size() && !(aSN1Sequence.getObjectAt(n) instanceof DERTaggedObject)) {
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n++));
            this.revokedCertificates = new CRLEntry[aSN1Sequence2.size()];
            for (int i = 0; i < this.revokedCertificates.length; ++i) {
                this.revokedCertificates[i] = new CRLEntry(ASN1Sequence.getInstance(aSN1Sequence2.getObjectAt(i)));
            }
        }
        if (n < aSN1Sequence.size() && aSN1Sequence.getObjectAt(n) instanceof DERTaggedObject) {
            this.crlExtensions = X509Extensions.getInstance(aSN1Sequence.getObjectAt(n++));
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        return this.revokedCertificates;
    }

    public X509Extensions getExtensions() {
        return this.crlExtensions;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }

    public class CRLEntry
    extends ASN1Encodable {
        ASN1Sequence seq;
        DERInteger userCertificate;
        Time revocationDate;
        X509Extensions crlEntryExtensions;

        public CRLEntry(ASN1Sequence aSN1Sequence) {
            if (aSN1Sequence.size() < 2 || aSN1Sequence.size() > 3) {
                throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
            }
            this.seq = aSN1Sequence;
            this.userCertificate = DERInteger.getInstance(aSN1Sequence.getObjectAt(0));
            this.revocationDate = Time.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() == 3) {
                this.crlEntryExtensions = X509Extensions.getInstance(aSN1Sequence.getObjectAt(2));
            }
        }

        public DERInteger getUserCertificate() {
            return this.userCertificate;
        }

        public Time getRevocationDate() {
            return this.revocationDate;
        }

        public X509Extensions getExtensions() {
            return this.crlEntryExtensions;
        }

        public DERObject toASN1Object() {
            return this.seq;
        }
    }
}

