/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.rmi.exception.NamingExceptionHelper;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.objectweb.carol.util.configuration.ProtocolConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class MultiContext
implements Context {
    private Map contextsOfConfigurations = null;
    private Context currentInitialContext = null;
    private Hashtable environment = null;

    public MultiContext(Hashtable env) throws NamingException {
        this.environment = env;
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.MultiContext(env), env = " + env);
        }
        String activeConfigName = null;
        try {
            activeConfigName = ConfigurationRepository.getCurrentConfiguration().getName();
        }
        catch (Error err) {
            throw NamingExceptionHelper.create("Could not get a configuration", err);
        }
        ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
        this.contextsOfConfigurations = new HashMap();
        for (int i = 0; i < protocolConfigurations.length; ++i) {
            Context ctx = protocolConfigurations[i].getInitialContext(env);
            if (protocolConfigurations[i].getName().equals(activeConfigName)) {
                this.currentInitialContext = ctx;
            }
            this.contextsOfConfigurations.put(protocolConfigurations[i], ctx);
        }
        if (this.currentInitialContext == null) {
            throw new NamingException("No current initial context was set. Active environment was '" + activeConfigName + "'. Error in carol with environment = " + env);
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.currentInitialContext.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.currentInitialContext.lookup(name);
    }

    public void bind(String name, Object obj) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).bind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).bind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).rebind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).rebind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void unbind(String name) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).unbind(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void unbind(Name name) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).unbind(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).rename(oldName, newName);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).rename(oldName, newName);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.currentInitialContext.list(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.currentInitialContext.list(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.currentInitialContext.listBindings(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.currentInitialContext.listBindings(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).destroySubcontext(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).destroySubcontext(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.currentInitialContext.createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.currentInitialContext.createSubcontext(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.currentInitialContext.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.currentInitialContext.lookupLink(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.currentInitialContext.getNameParser(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.currentInitialContext.getNameParser(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.currentInitialContext.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment;
    }

    public void close() throws NamingException {
        Iterator it = this.contextsOfConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)it.next();
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            ((Context)this.contextsOfConfigurations.get(protocolConfiguration)).close();
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this.currentInitialContext.getNameInNamespace();
    }
}

