/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hwpf.model.FormattedDiskPage;
import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.model.ParagraphHeight;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.util.LittleEndian;

public class PAPFormattedDiskPage
extends FormattedDiskPage {
    private static final int BX_SIZE = 13;
    private static final int FC_SIZE = 4;
    private ArrayList _papxList = new ArrayList();
    private ArrayList _overFlow;
    private byte[] _dataStream;

    public PAPFormattedDiskPage(byte[] dataStream) {
        this._dataStream = dataStream;
    }

    public PAPFormattedDiskPage(byte[] documentStream, byte[] dataStream, int offset, int fcMin) {
        super(documentStream, offset);
        for (int x = 0; x < this._crun; ++x) {
            this._papxList.add(new PAPX(this.getStart(x) - fcMin, this.getEnd(x) - fcMin, this.getGrpprl(x), this.getParagraphHeight(x), dataStream));
        }
        this._fkp = null;
        this._dataStream = dataStream;
    }

    public void fill(List filler) {
        this._papxList.addAll(filler);
    }

    ArrayList getOverflow() {
        return this._overFlow;
    }

    public PAPX getPAPX(int index) {
        return (PAPX)this._papxList.get(index);
    }

    protected byte[] getGrpprl(int index) {
        int papxOffset = 2 * LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + ((this._crun + 1) * 4 + index * 13)));
        int size = 2 * LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + papxOffset));
        size = size == 0 ? 2 * LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + ++papxOffset)) : --size;
        byte[] papx = new byte[size];
        System.arraycopy(this._fkp, this._offset + ++papxOffset, papx, 0, size);
        return papx;
    }

    protected byte[] toByteArray(int fcMin) {
        int index;
        byte[] buf = new byte[512];
        int size = this._papxList.size();
        int grpprlOffset = 0;
        int bxOffset = 0;
        int fcOffset = 0;
        byte[] lastGrpprl = new byte[]{};
        int totalSize = 4;
        for (index = 0; index < size; ++index) {
            byte[] grpprl = ((PAPX)this._papxList.get(index)).getGrpprl();
            int grpprlLength = grpprl.length;
            if (grpprlLength > 488) {
                grpprlLength = 8;
            }
            int addition = 0;
            addition = !Arrays.equals(grpprl, lastGrpprl) ? 17 + grpprlLength + 1 : 17;
            if ((totalSize += addition) > 511 + index % 2) {
                totalSize -= addition;
                break;
            }
            totalSize = grpprlLength % 2 > 0 ? ++totalSize : (totalSize += 2);
            lastGrpprl = grpprl;
        }
        if (index != size) {
            this._overFlow = new ArrayList();
            this._overFlow.addAll(this._papxList.subList(index, size));
        }
        buf[511] = (byte)index;
        bxOffset = 4 * index + 4;
        grpprlOffset = 511;
        PropertyNode papx = null;
        lastGrpprl = new byte[]{};
        for (int x = 0; x < index; ++x) {
            boolean same;
            papx = (PAPX)this._papxList.get(x);
            byte[] phe = ((PAPX)papx).getParagraphHeight().toByteArray();
            byte[] grpprl = ((PAPX)papx).getGrpprl();
            if (grpprl.length > 488) {
                int hugeGrpprlOffset = ((PAPX)papx).getHugeGrpprlOffset();
                if (hugeGrpprlOffset == -1) {
                    throw new UnsupportedOperationException("This Paragraph has no dataStream storage.");
                }
                int maxHugeGrpprlSize = LittleEndian.getUShort((byte[])this._dataStream, (int)hugeGrpprlOffset);
                if (maxHugeGrpprlSize < grpprl.length - 2) {
                    throw new UnsupportedOperationException("This Paragraph's dataStream storage is too small.");
                }
                System.arraycopy(grpprl, 2, this._dataStream, hugeGrpprlOffset + 2, grpprl.length - 2);
                LittleEndian.putUShort((byte[])this._dataStream, (int)hugeGrpprlOffset, (int)(grpprl.length - 2));
                int istd = LittleEndian.getUShort((byte[])grpprl, (int)0);
                grpprl = new byte[8];
                LittleEndian.putUShort((byte[])grpprl, (int)0, (int)istd);
                LittleEndian.putUShort((byte[])grpprl, (int)2, (int)26182);
                LittleEndian.putInt((byte[])grpprl, (int)4, (int)hugeGrpprlOffset);
            }
            if (!(same = Arrays.equals(lastGrpprl, grpprl))) {
                grpprlOffset -= grpprl.length + (2 - grpprl.length % 2);
                grpprlOffset -= grpprlOffset % 2;
            }
            LittleEndian.putInt((byte[])buf, (int)fcOffset, (int)(papx.getStart() + fcMin));
            buf[bxOffset] = (byte)(grpprlOffset / 2);
            System.arraycopy(phe, 0, buf, bxOffset + 1, phe.length);
            if (!same) {
                int copyOffset = grpprlOffset;
                if (grpprl.length % 2 > 0) {
                    buf[copyOffset++] = (byte)((grpprl.length + 1) / 2);
                } else {
                    buf[++copyOffset] = (byte)(grpprl.length / 2);
                    ++copyOffset;
                }
                System.arraycopy(grpprl, 0, buf, copyOffset, grpprl.length);
                lastGrpprl = grpprl;
            }
            bxOffset += 13;
            fcOffset += 4;
        }
        LittleEndian.putInt((byte[])buf, (int)fcOffset, (int)(papx.getEnd() + fcMin));
        return buf;
    }

    private ParagraphHeight getParagraphHeight(int index) {
        int pheOffset = this._offset + 1 + ((this._crun + 1) * 4 + index * 13);
        ParagraphHeight phe = new ParagraphHeight(this._fkp, pheOffset);
        return phe;
    }
}

