/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

public class SetCurrentIdentityFilter
implements Filter {
    private static Log log = ExoLogger.getLogger((String)"core.security.SetCurrentIdentityFilter");
    private String portalContainerName;

    public void init(FilterConfig config) throws ServletException {
        this.portalContainerName = config.getInitParameter("portalContainerName");
        if (this.portalContainerName == null) {
            this.portalContainerName = config.getServletContext().getServletContextName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = ExoContainerContext.getContainerByName((String)this.portalContainerName);
        if (container == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Container not found for the servlet context " + this.portalContainerName));
            }
            container = ExoContainerContext.getTopContainer();
        }
        try {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            ConversationState state = this.getCurrentState(container, httpRequest);
            ConversationState.setCurrent(state);
            chain.doFilter(request, response);
        }
        finally {
            try {
                ConversationState.setCurrent(null);
            }
            catch (Exception e) {
                log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private ConversationState getCurrentState(ExoContainer container, HttpServletRequest httpRequest) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        String sessionId = null;
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null) {
            HttpSession httpSession = httpRequest.getSession();
            sessionId = httpSession.getId();
        }
        if (sessionId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for Conversation State " + sessionId));
            }
            if ((state = conversationRegistry.getState(sessionId)) == null) {
                Identity identity;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Conversation State not found, try create new one.");
                }
                if ((identity = identityRegistry.getIdentity(userId)) != null) {
                    state = new ConversationState(identity);
                    state.setAttribute("subject", identity.getSubject());
                } else {
                    log.error((Object)("Not found identity in IdentityRegistry for user " + userId + ", check Login Module."));
                }
                if (state != null) {
                    conversationRegistry.register(sessionId, state);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Register Conversation state " + sessionId));
                    }
                }
            }
        }
        return state;
    }

    public void destroy() {
    }
}

