/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchemaBasic;
import org.jempbox.xmp.XMPSchemaDublinCore;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.util.PDFTextStripper;

public class PDFDocumentReader
extends BaseDocumentReader {
    protected static Log log = ExoLogger.getLogger((String)"platform.PDFDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/pdf"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws Exception {
        if (!this.isInputStreamValid(is)) {
            return "";
        }
        PDDocument pdDocument = PDDocument.load((InputStream)is);
        StringWriter sw = new StringWriter();
        try {
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(1);
            stripper.setEndPage(Integer.MAX_VALUE);
            stripper.writeText(pdDocument, (Writer)sw);
        }
        finally {
            if (pdDocument != null) {
                pdDocument.close();
            }
        }
        return sw.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws Exception {
        return this.getContentAsText(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(InputStream is) throws Exception {
        Properties props;
        block50: {
            if (!this.isInputStreamValid(is)) {
                return new Properties();
            }
            PDDocument pdDocument = PDDocument.load((InputStream)is);
            props = new Properties();
            try {
                PDDocumentInformation docInfo;
                PDDocumentCatalog catalog;
                PDMetadata meta;
                if (pdDocument.isEncrypted()) {
                    try {
                        pdDocument.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        throw new Exception("The pdf document is encrypted.");
                    }
                    catch (CryptographyException e) {
                        throw e;
                    }
                }
                if ((meta = (catalog = pdDocument.getDocumentCatalog()).getMetadata()) != null) {
                    XMPSchemaBasic basic;
                    XMPMetadata metadata = XMPMetadata.load((InputStream)meta.createInputStream());
                    XMPSchemaDublinCore dc = metadata.getDublinCoreSchema();
                    if (dc != null) {
                        List list;
                        try {
                            if (dc.getTitle() != null) {
                                props.put(DCMetaData.TITLE, dc.getTitle());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getTitle failed: " + e));
                        }
                        try {
                            if (dc.getDescription() != null) {
                                props.put(DCMetaData.SUBJECT, dc.getDescription());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getSubject failed: " + e));
                        }
                        try {
                            if (dc.getCreators() != null) {
                                list = dc.getCreators();
                                for (String creator : list) {
                                    props.put(DCMetaData.CREATOR, creator);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getCreator failed: " + e));
                        }
                        try {
                            if (dc.getDates() != null) {
                                list = dc.getDates();
                                for (Calendar date : list) {
                                    props.put(DCMetaData.DATE, date);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getDate failed: " + e));
                        }
                    }
                    if ((basic = metadata.getBasicSchema()) != null) {
                        try {
                            if (basic.getCreateDate() != null) {
                                props.put(DCMetaData.DATE, basic.getCreateDate());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getCreationDate failed: " + e));
                        }
                        try {
                            if (basic.getModifyDate() != null) {
                                props.put(DCMetaData.DATE, basic.getModifyDate());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("getModificationDate failed: " + e));
                        }
                    }
                }
                if (!props.isEmpty() || (docInfo = pdDocument.getDocumentInformation()) == null) break block50;
                try {
                    if (docInfo.getCreationDate() != null) {
                        props.put(DCMetaData.DATE, docInfo.getCreationDate());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getCreationDate failed: " + e));
                }
                try {
                    if (docInfo.getCreator() != null) {
                        props.put(DCMetaData.CREATOR, docInfo.getCreator());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getCreator failed: " + e));
                }
                try {
                    if (docInfo.getKeywords() != null) {
                        props.put(DCMetaData.SUBJECT, docInfo.getKeywords());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getKeywords failed: " + e));
                }
                try {
                    if (docInfo.getModificationDate() != null) {
                        props.put(DCMetaData.DATE, docInfo.getModificationDate());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getModificationDate failed: " + e));
                }
                try {
                    if (docInfo.getSubject() != null) {
                        props.put(DCMetaData.DESCRIPTION, docInfo.getSubject());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getSubject failed: " + e));
                }
                try {
                    if (docInfo.getTitle() != null) {
                        props.put(DCMetaData.TITLE, docInfo.getTitle());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("getTitle failed: " + e));
                }
            }
            finally {
                if (pdDocument != null) {
                    pdDocument.close();
                }
            }
        }
        return props;
    }
}

