/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.objectweb.carol.util.configuration.Protocol;
import org.objectweb.carol.util.configuration.ProtocolConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class NameServiceManager {
    private static final int SLEEP_VALUE = 10000;
    private static Hashtable nsTable;
    private static NameServiceManager current;

    private NameServiceManager() {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.NameServiceManager()");
        }
        nsTable = new Hashtable();
        ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
        for (int c = 0; c < protocolConfigurations.length; ++c) {
            ProtocolConfiguration protocolConfiguration = protocolConfigurations[c];
            String configurationName = protocolConfiguration.getName();
            Protocol protocol = protocolConfiguration.getProtocol();
            NameService nsC = null;
            try {
                nsC = (NameService)Class.forName(protocol.getRegistryClassName()).newInstance();
            }
            catch (Exception e) {
                String msg = "Cannot instantiate registry class '" + protocol.getRegistryClassName() + "'";
                TraceCarol.error(msg, e);
            }
            nsC.setPort(protocolConfiguration.getPort());
            nsC.setHost(protocolConfiguration.getHost());
            nsC.setConfigProperties(protocolConfiguration.getProperties());
            nsTable.put(configurationName, nsC);
        }
    }

    public static NameServiceManager getNSManagerCurrent() {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.getNSManagerCurrent()");
        }
        return current;
    }

    public static void startNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.startNS()");
        }
        Enumeration e = nsTable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            NameService currentNS = (NameService)nsTable.get(k);
            if (!currentNS.isStarted()) continue;
            throw new NameServiceException("The " + k + " name service is already started");
        }
        NameServiceManager.startNonStartedNS();
    }

    public static void startNonStartedNS() {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.startNonStartedNS()");
        }
        Enumeration e = nsTable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            NameService currentNS = (NameService)nsTable.get(k);
            try {
                currentNS.start();
                if (!TraceCarol.isInfoCarol()) continue;
                TraceCarol.infoCarol("Name service for " + k + " is started on port " + currentNS.getPort());
            }
            catch (NameServiceException nse) {
                if (!TraceCarol.isDebugJndiCarol()) continue;
                TraceCarol.debugJndiCarol("NameServiceManager.startNonStartedNS() can not start name service: " + k);
            }
        }
    }

    public static void stopNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.stopNS()");
        }
        Enumeration e = nsTable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            NameService currentNS = (NameService)nsTable.get(k);
            currentNS.stop();
        }
    }

    public static void main(String[] args) {
        TraceCarol.configure();
        try {
            NameServiceManager.startNonStartedNS();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        NameServiceManager.stopNS();
                    }
                    catch (Exception e) {
                        TraceCarol.error("Carol Naming ShutdownHook problem", e);
                    }
                }
            });
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static {
        current = new NameServiceManager();
    }
}

