/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.QueryManager;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.ScratchWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.access.DefaultAccessManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerFactory;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LinkedWorkspaceStorageCacheImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.impl.storage.value.StandaloneStoragePluginProvider;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

@Managed
@NameTemplate(value={@Property(key="container", value="repository"), @Property(key="name", value="{Name}")})
@NamingContext(value={@Property(key="repository", value="{Name}")})
public class RepositoryContainer
extends ExoContainer {
    private final RepositoryEntry config;
    private LocalWorkspaceDataManagerStub systemDataManager = null;
    private final Log log = ExoLogger.getLogger((String)"jcr.RepositoryContainer");

    public RepositoryContainer(ExoContainer parent, RepositoryEntry config) throws RepositoryException, RepositoryConfigurationException {
        super((ComponentAdapterFactory)new MX4JComponentAdapterFactory(), (PicoContainer)parent);
        if (config.getAccessControl() == null) {
            config.setAccessControl("optional");
        }
        this.config = config;
        this.registerComponents();
    }

    public LocationFactory getLocationFactory() {
        return (LocationFactory)this.getComponentInstanceOfType(LocationFactory.class);
    }

    @Managed
    @ManagedDescription(value="The repository container name")
    public String getName() {
        return this.config.getName();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return (NamespaceRegistry)this.getComponentInstanceOfType(NamespaceRegistry.class);
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return (ExtendedNodeTypeManager)this.getComponentInstanceOfType(NodeTypeManager.class);
    }

    public WorkspaceContainer getWorkspaceContainer(String workspaceName) {
        Object comp = this.getComponentInstance(workspaceName);
        return comp != null && comp instanceof WorkspaceContainer ? (WorkspaceContainer)((Object)comp) : null;
    }

    public WorkspaceEntry getWorkspaceEntry(String wsName) {
        for (WorkspaceEntry entry : this.config.getWorkspaceEntries()) {
            if (!entry.getName().equals(wsName)) continue;
            return entry;
        }
        return null;
    }

    public void registerWorkspace(WorkspaceEntry wsConfig) throws RepositoryException, RepositoryConfigurationException {
        try {
            Class initilizerType;
            boolean isSystem = this.config.getSystemWorkspaceName().equals(wsConfig.getName());
            if (this.getWorkspaceContainer(wsConfig.getName()) != null) {
                throw new RepositoryException("Workspace " + wsConfig.getName() + " already registred");
            }
            WorkspaceContainer workspaceContainer = new WorkspaceContainer(this, wsConfig);
            this.registerComponentInstance(wsConfig.getName(), (Object)workspaceContainer);
            wsConfig.setUniqueName(this.getName() + "_" + wsConfig.getName());
            workspaceContainer.registerComponentInstance(wsConfig);
            workspaceContainer.registerComponentImplementation(StandaloneStoragePluginProvider.class);
            try {
                Class<?> containerType = Class.forName(wsConfig.getContainer().getType());
                workspaceContainer.registerComponentImplementation(containerType);
                if (isSystem) {
                    this.registerComponentInstance(new SystemDataContainerHolder((WorkspaceDataContainer)workspaceContainer.getComponentInstanceOfType(WorkspaceDataContainer.class)));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException("Class not found for workspace data container " + wsConfig.getUniqueName() + " : " + e);
            }
            try {
                String className = wsConfig.getCache().getType();
                if (className != null && className.length() > 0) {
                    workspaceContainer.registerComponentImplementation(Class.forName(className));
                } else {
                    workspaceContainer.registerComponentImplementation(LinkedWorkspaceStorageCacheImpl.class);
                }
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("Workspace cache class not found " + wsConfig.getCache().getType() + ", will use default. Error : " + e));
                workspaceContainer.registerComponentImplementation(LinkedWorkspaceStorageCacheImpl.class);
            }
            workspaceContainer.registerComponentImplementation(CacheableWorkspaceDataManager.class);
            workspaceContainer.registerComponentImplementation(LocalWorkspaceDataManagerStub.class);
            workspaceContainer.registerComponentImplementation(ObservationManagerRegistry.class);
            if (wsConfig.getLockManager() != null && wsConfig.getLockManager().getPersister() != null) {
                try {
                    Class<?> lockPersister = Class.forName(wsConfig.getLockManager().getPersister().getType());
                    workspaceContainer.registerComponentImplementation(lockPersister);
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryConfigurationException("Class not found for workspace lock persister " + wsConfig.getLockManager().getPersister().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                }
            }
            workspaceContainer.registerComponentImplementation(LockManagerImpl.class);
            if (wsConfig.getQueryHandler() != null) {
                workspaceContainer.registerComponentImplementation(SearchManager.class);
                workspaceContainer.registerComponentImplementation(QueryManager.class);
                workspaceContainer.registerComponentImplementation(QueryManagerFactory.class);
                workspaceContainer.registerComponentInstance(wsConfig.getQueryHandler());
                if (isSystem) {
                    workspaceContainer.registerComponentImplementation(SystemSearchManager.class);
                }
            }
            if (wsConfig.getAccessManager() != null && wsConfig.getAccessManager().getType() != null) {
                try {
                    Class<?> am = Class.forName(wsConfig.getAccessManager().getType());
                    workspaceContainer.registerComponentImplementation(am);
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryConfigurationException("Class not found for workspace access manager " + wsConfig.getAccessManager().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                }
            }
            if (wsConfig.getInitializer() != null && wsConfig.getInitializer().getType() != null) {
                try {
                    initilizerType = Class.forName(wsConfig.getInitializer().getType());
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryConfigurationException("Class not found for workspace initializer " + wsConfig.getInitializer().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                }
            } else {
                initilizerType = ScratchWorkspaceInitializer.class;
            }
            workspaceContainer.registerComponentImplementation(initilizerType);
            workspaceContainer.registerComponentImplementation(SessionFactory.class);
            workspaceContainer.registerComponentImplementation(WorkspaceFileCleanerHolder.class);
            LocalWorkspaceDataManagerStub wsDataManager = (LocalWorkspaceDataManagerStub)workspaceContainer.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
            if (isSystem) {
                this.systemDataManager = wsDataManager;
                this.registerComponentInstance(this.systemDataManager);
            }
            wsDataManager.setSystemDataManager(this.systemDataManager);
            if (!this.config.getWorkspaceEntries().contains(wsConfig)) {
                this.config.getWorkspaceEntries().add(wsConfig);
            }
        }
        catch (RuntimeException e) {
            Throwable retval = e;
            for (int depth = 0; retval.getCause() != null && depth < 100; ++depth) {
                if ((retval = retval.getCause()) instanceof RepositoryException) {
                    throw (RepositoryException)retval;
                }
                if (!(retval instanceof RepositoryConfigurationException)) continue;
                throw (RepositoryConfigurationException)retval;
            }
            throw e;
        }
    }

    public void start() {
        try {
            this.init();
            this.load();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        super.start();
    }

    public void stop() {
        try {
            this.stopContainer();
        }
        catch (Exception e) {
            this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        super.stop();
    }

    @Deprecated
    private void doStart() throws RepositoryException, RepositoryConfigurationException {
        List<WorkspaceEntry> wsEntries = this.config.getWorkspaceEntries();
        for (WorkspaceEntry ws : wsEntries) {
            this.startWorkspace(ws);
        }
    }

    private void init() throws RepositoryException, RepositoryConfigurationException {
        List<WorkspaceEntry> wsEntries = this.config.getWorkspaceEntries();
        for (WorkspaceEntry ws : wsEntries) {
            this.initWorkspace(ws);
        }
    }

    private void initWorkspace(WorkspaceEntry wsConfig) throws RepositoryException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(wsConfig.getName());
        workspaceContainer.getComponentInstanceOfType(IdGenerator.class);
        WorkspaceInitializer wsInitializer = (WorkspaceInitializer)workspaceContainer.getComponentInstanceOfType(WorkspaceInitializer.class);
        wsInitializer.initWorkspace();
    }

    private void registerComponents() throws RepositoryConfigurationException, RepositoryException {
        this.registerComponentInstance(this.config);
        this.registerWorkspacesComponents();
        this.registerRepositoryComponents();
    }

    private void registerRepositoryComponents() throws RepositoryConfigurationException, RepositoryException {
        this.registerComponentImplementation(IdGenerator.class);
        this.registerComponentImplementation(NamespaceDataPersister.class);
        this.registerComponentImplementation(NamespaceRegistryImpl.class);
        this.registerComponentImplementation(WorkspaceFileCleanerHolder.class);
        this.registerComponentImplementation(LocationFactory.class);
        this.registerComponentImplementation(ValueFactoryImpl.class);
        this.registerComponentImplementation(NodeTypeDataPersister.class);
        this.registerComponentImplementation(NodeTypeManagerImpl.class);
        this.registerComponentImplementation(DefaultAccessManagerImpl.class);
        this.registerComponentImplementation(SessionRegistry.class);
        String systemWsname = this.config.getSystemWorkspaceName();
        WorkspaceEntry systemWsEntry = this.getWorkspaceEntry(systemWsname);
        if (systemWsEntry != null && systemWsEntry.getQueryHandler() != null) {
            SystemSearchManager systemSearchManager = (SystemSearchManager)this.getWorkspaceContainer(systemWsname).getComponentInstanceOfType(SystemSearchManager.class);
            this.registerComponentInstance(new SystemSearchManagerHolder(systemSearchManager));
        }
        try {
            this.registerComponentImplementation(Class.forName(this.config.getAuthenticationPolicy()));
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryConfigurationException("Class not found for repository authentication policy: " + e);
        }
        RepositoryImpl repository = new RepositoryImpl(this);
        this.registerComponentInstance(repository);
    }

    private void registerWorkspacesComponents() throws RepositoryException, RepositoryConfigurationException {
        List<WorkspaceEntry> wsEntries = this.config.getWorkspaceEntries();
        Collections.sort(wsEntries, new WorkspaceOrderComparator(this.config.getSystemWorkspaceName()));
        for (int i = 0; i < wsEntries.size(); ++i) {
            this.registerWorkspace(wsEntries.get(i));
        }
    }

    @Deprecated
    private void startWorkspace(WorkspaceEntry wsConfig) throws RepositoryException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(wsConfig.getName());
        WorkspaceInitializer wsInitializer = (WorkspaceInitializer)workspaceContainer.getComponentInstanceOfType(WorkspaceInitializer.class);
    }

    private void load() throws RepositoryException {
        NamespaceRegistryImpl nsRegistry = (NamespaceRegistryImpl)this.getNamespaceRegistry();
        NodeTypeManagerImpl ntManager = (NodeTypeManagerImpl)this.getNodeTypeManager();
        nsRegistry.loadFromStorage();
        ntManager.loadFromStorage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkspaceOrderComparator
    implements Comparator<WorkspaceEntry> {
        private final String sysWs;

        private WorkspaceOrderComparator(String sysWs) {
            this.sysWs = sysWs;
        }

        @Override
        public int compare(WorkspaceEntry o1, WorkspaceEntry o2) {
            String n1 = o1.getName();
            return n1.equals(this.sysWs) ? -1 : 0;
        }
    }
}

