/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import org.objectweb.carol.jndi.ns.AbsRegistry;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.rmi.util.PortNumber;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;

public class JacORBCosNaming
extends AbsRegistry
implements NameService {
    private static final String JACORB_NAMESERVER_CLASS = "org.jacorb.naming.NameServer";
    private static final int SLEEP_TIME = 2000;
    private static final int DEFAULT_PORT_NUMBER = 38693;
    private Process jacORBNameServerProcess = null;
    private static ORB orb = null;

    public JacORBCosNaming() {
        super(38693);
    }

    public void start() throws NameServiceException {
        String propertyName;
        String hostCorbaLoc;
        String ipAddr;
        block20: {
            if (this.isStarted()) {
                throw new IllegalStateException("Cannot start the server as the service is already running.");
            }
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("start() on port : '" + this.getPort() + "'");
            }
            ipAddr = null;
            hostCorbaLoc = "localhost";
            if (!this.getHost().equalsIgnoreCase("localhost")) {
                try {
                    ipAddr = InetAddress.getByName(this.getHost()).getHostAddress();
                    System.setProperty("OAIAddr", ipAddr);
                }
                catch (UnknownHostException uhe) {
                    if (!TraceCarol.isDebugJndiCarol()) break block20;
                    TraceCarol.debugJndiCarol("Could net get ip address from host '" + this.getHost() + "' : " + uhe.getMessage());
                    uhe.printStackTrace();
                }
            }
        }
        if (System.getProperty("carol.server.mode", "false").equalsIgnoreCase("true")) {
            if (this.getConfigProperties() != null) {
                propertyName = "carol.iiop.server.port";
                int iiopPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, "0"), propertyName);
                if (iiopPort > 0) {
                    TraceCarol.infoCarol("Using IIOP fixed server port number '" + iiopPort + "'.");
                    System.setProperty("OAPort", String.valueOf(iiopPort));
                }
            } else {
                TraceCarol.debugCarol("No properties 'carol.iiop.server.port' defined in carol.properties file.");
            }
        }
        if (System.getProperty("carol.server.mode", "false").equalsIgnoreCase("true")) {
            if (this.getConfigProperties() != null) {
                propertyName = "carol.iiop.server.sslport";
                int iiopSslPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, String.valueOf(2003)), propertyName);
                if (iiopSslPort > 0) {
                    TraceCarol.debugCarol("Using SSL IIOP port number '" + iiopSslPort + "'.");
                    System.setProperty("OASSLPort", String.valueOf(iiopSslPort));
                }
            } else {
                TraceCarol.debugCarol("No properties 'carol.iiop.server.sslport' defined in carol.properties file.");
            }
        }
        try {
            if (!this.isRemoteNameServiceStarted()) {
                String jvmProperties = "-Djava.endorsed.dirs=" + System.getProperty("java.endorsed.dirs") + " " + "-Djacorb.orb.print_version=off " + "-Djacorb.log.default.verbosity=0 " + "-Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB " + "-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton " + "-DOAPort=";
                jvmProperties = jvmProperties + Integer.toString(this.getPort());
                jvmProperties = jvmProperties + " -DORBInitRef.NameService=corbaloc:iiop:" + hostCorbaLoc + ":" + Integer.toString(this.getPort()) + "/NameService";
                if (ipAddr != null) {
                    jvmProperties = jvmProperties + " -DOAIAddr=" + ipAddr;
                }
                if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Launching NS with JVM properties: '" + jvmProperties + "'");
                }
                this.jacORBNameServerProcess = Runtime.getRuntime().exec(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java " + jvmProperties + " " + JACORB_NAMESERVER_CLASS);
                Thread.sleep(2000L);
                InputStream cosError = this.jacORBNameServerProcess.getErrorStream();
                InputStream cosOut = this.jacORBNameServerProcess.getInputStream();
                Thread err = new Thread(new CosReader(cosError, true));
                Thread out = new Thread(new CosReader(cosOut, false));
                out.start();
                err.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            if (JacORBCosNaming.this.isStarted()) {
                                JacORBCosNaming.this.stop();
                            }
                        }
                        catch (Exception e) {
                            TraceCarol.error("JacORBCosNaming ShutdownHook problem", e);
                        }
                    }
                });
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JacORBCosNaming is already start on port : '" + this.getPort() + "'.");
            }
        }
        catch (Exception e) {
            TraceCarol.error("Cannot start JacORBCosNaming for an unknown reason", e);
            throw new NameServiceException("cannot start cosnaming daemon: " + e);
        }
        this.setStarted();
    }

    public void stop() throws NameServiceException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot stop the server as the service is not running.");
        }
        try {
            if (this.jacORBNameServerProcess != null) {
                this.jacORBNameServerProcess.destroy();
            }
            this.jacORBNameServerProcess = null;
        }
        catch (Exception e) {
            TraceCarol.error("Cannot stop JacORBCosNaming for an unknown reason", e);
            throw new NameServiceException("cannot start cosnaming daemon: " + e);
        }
        this.resetStarted();
    }

    private boolean isRemoteNameServiceStarted() {
        Properties prop = new Properties();
        prop.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        prop.put("java.naming.provider.url", "corbaloc:iiop:localhost:" + Integer.toString(this.getPort()) + "/StandardNS/NameServer-POA/_root");
        if (orb == null) {
            JacORBCosNaming.initORB();
        }
        prop.put("java.naming.corba.orb", orb);
        try {
            new InitialContext(prop);
        }
        catch (CommunicationException jcm) {
            return false;
        }
        catch (TRANSIENT ct) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static ORB getOrb() {
        if (orb == null) {
            JacORBCosNaming.initORB();
        }
        return orb;
    }

    private static void initORB() {
        orb = ORB.init((String[])new String[0], null);
    }

    class CosReader
    implements Runnable {
        private InputStream is;
        private boolean isErrorMessage = false;

        public CosReader(InputStream is, boolean isErrorMessage) {
            this.is = is;
            this.isErrorMessage = isErrorMessage;
        }

        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                String str = null;
                while ((str = br.readLine()) != null) {
                    if (this.isErrorMessage) {
                        if (!TraceCarol.isDebugJndiCarol()) continue;
                        TraceCarol.debugJndiCarol("JacORBCosNaming error :");
                        TraceCarol.debugJndiCarol(str);
                        continue;
                    }
                    if (!TraceCarol.isDebugJndiCarol()) continue;
                    TraceCarol.debugJndiCarol("JacORBCosNaming:");
                    TraceCarol.debugJndiCarol(str);
                }
                this.is.close();
            }
            catch (Exception e) {
                TraceCarol.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

