/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.io.Serializable;
import java.rmi.Remote;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.jndi.spi.AbsContext;
import org.objectweb.carol.jndi.wrapping.JNDIResourceWrapper;
import org.objectweb.carol.rmi.exception.NamingExceptionHelper;
import org.objectweb.carol.util.configuration.ConfigurationRepository;

public class JEREMIEContext
extends AbsContext
implements Context {
    public JEREMIEContext(Context jeremieCtx) {
        super(jeremieCtx);
    }

    protected Object unwrapObject(Object o, Name name) throws NamingException {
        return super.defaultUnwrapObject(o, name);
    }

    protected Object wrapObject(Object o, Name name, boolean replace) throws NamingException {
        try {
            if (!(o instanceof Remote) && !(o instanceof Referenceable) && !(o instanceof Reference) && o instanceof Serializable) {
                JNDIResourceWrapper irw = new JNDIResourceWrapper((Serializable)o);
                PortableRemoteObjectDelegate proDelegate = ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject();
                proDelegate.exportObject((Remote)irw);
                Remote oldObj = (Remote)this.addToExported(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        proDelegate.unexportObject(oldObj);
                    } else {
                        proDelegate.unexportObject((Remote)irw);
                        this.addToExported(name, oldObj);
                        throw new NamingException("Object '" + o + "' with name '" + name + "' is already bind");
                    }
                }
                return irw;
            }
            return o;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot wrap object '" + o + "' with name '" + name + "' : " + e.getMessage(), e);
        }
    }
}

