/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.web.ConversationStateListener;

public class JAASConversationStateListener
extends ConversationStateListener {
    public void sessionDestroyed(HttpSessionEvent event) {
        String sesionId = event.getSession().getId();
        try {
            ConversationRegistry conversationRegistry = (ConversationRegistry)this.getContainer().getComponentInstanceOfType(ConversationRegistry.class);
            ConversationState conversationState = conversationRegistry.unregister(sesionId);
            if (conversationState != null) {
                this.log.info((Object)("Remove conversation state " + sesionId));
                if (conversationState.getAttribute("subject") != null) {
                    Subject subject = (Subject)conversationState.getAttribute("subject");
                    LoginContext ctx = new LoginContext("exo-domain", subject);
                    ctx.logout();
                } else {
                    this.log.warn((Object)"Subject was not found in ConversationState attributes.");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Can't remove conversation state " + sesionId));
        }
    }
}

