/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.SetterIntrospector;

public class BeanPropertyComponentAdapter
extends DecoratingComponentAdapter {
    private Map properties;
    private transient Map setters = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public BeanPropertyComponentAdapter(ComponentAdapter delegate) throws PicoInitializationException {
        super(delegate);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentInstance = super.getComponentInstance(container);
        if (this.setters == null) {
            this.setters = new SetterIntrospector().getSetters(this.getComponentImplementation());
        }
        if (this.properties != null) {
            Set propertyNames = this.properties.keySet();
            Iterator iterator = propertyNames.iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                String propertyValue = (String)this.properties.get(propertyName);
                Method setter = (Method)this.setters.get(propertyName);
                Object value = null;
                try {
                    value = this.convertType(container, setter, propertyValue);
                }
                catch (ClassNotFoundException e) {
                    throw new PicoInvocationTargetInitializationException(e);
                }
                try {
                    setter.invoke(componentInstance, value);
                }
                catch (Exception e) {
                    throw new PicoInitializationException("Failed to set property " + propertyName + " to " + propertyValue + ": " + e.getMessage(), e);
                }
            }
        }
        return componentInstance;
    }

    private Object convertType(PicoContainer container, Method setter, String propertyValue) throws ClassNotFoundException {
        Object component;
        if (propertyValue == null) {
            return null;
        }
        Class<?> type = setter.getParameterTypes()[0];
        String typeName = type.getName();
        Object result = BeanPropertyComponentAdapter.convert(typeName, propertyValue, Thread.currentThread().getContextClassLoader());
        if (result == null && container != null && (component = container.getComponentInstance(propertyValue)) != null && type.isAssignableFrom(component.getClass())) {
            return component;
        }
        return result;
    }

    public static Object convert(String typeName, String value, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz.getName()) || typeName.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(value);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz2.getName()) || typeName.equals(Byte.TYPE.getName())) {
            return Byte.valueOf(value);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz3.getName()) || typeName.equals(Short.TYPE.getName())) {
            return Short.valueOf(value);
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz4.getName()) || typeName.equals(Integer.TYPE.getName())) {
            return Integer.valueOf(value);
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz5.getName()) || typeName.equals(Long.TYPE.getName())) {
            return Long.valueOf(value);
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz6.getName()) || typeName.equals(Float.TYPE.getName())) {
            return Float.valueOf(value);
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz7.getName()) || typeName.equals(Double.TYPE.getName())) {
            return Double.valueOf(value);
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz8.getName()) || typeName.equals(Character.TYPE.getName())) {
            return new Character(value.toCharArray()[0]);
        }
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz9.getName()) || typeName.equals("string")) {
            return value;
        }
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz10.getName()) || typeName.equals("file")) {
            return new File(value);
        }
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz11.getName()) || typeName.equals("url")) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new PicoInitializationException(e);
            }
        }
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz12.getName()) || typeName.equals("class")) {
            return classLoader.loadClass(value);
        }
        return null;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }
}

