/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoInstantiationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class CollectionComponentParameter
implements Parameter,
Serializable {
    public static final CollectionComponentParameter ARRAY = new CollectionComponentParameter();
    public static final CollectionComponentParameter ARRAY_ALLOW_EMPTY = new CollectionComponentParameter(true);
    private final boolean emptyCollection;
    private final Class componentKeyType;
    private final Class componentValueType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public CollectionComponentParameter() {
        this(false);
    }

    public CollectionComponentParameter(boolean emptyCollection) {
        this(Void.TYPE, emptyCollection);
    }

    public CollectionComponentParameter(Class componentValueType, boolean emptyCollection) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz, componentValueType, emptyCollection);
    }

    public CollectionComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this.emptyCollection = emptyCollection;
        this.componentKeyType = componentKeyType;
        this.componentValueType = componentValueType;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoInstantiationException {
        Object result = null;
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Map adapterMap = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, this.getValueType(expectedType));
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.reflect.Array");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(collectionType)) {
                result = this.getArrayInstance(container, expectedType, adapterMap);
            } else {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.util.Map");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(collectionType)) {
                    result = this.getMapInstance(container, expectedType, adapterMap);
                } else {
                    Class<?> clazz3 = class$3;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$3 = Class.forName("java.util.Collection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz3.isAssignableFrom(collectionType)) {
                        result = this.getCollectionInstance(container, expectedType, adapterMap);
                    } else {
                        throw new PicoIntrospectionException(String.valueOf(expectedType.getName()) + " is not a collective type");
                    }
                }
            }
        }
        return result;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Class collectionType = this.getCollectionType(expectedType);
        Class valueType = this.getValueType(expectedType);
        return collectionType != null && (this.emptyCollection || this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).size() > 0);
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoIntrospectionException {
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Class valueType = this.getValueType(expectedType);
            Collection componentAdapters = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).values();
            if (componentAdapters.isEmpty()) {
                if (!this.emptyCollection) {
                    throw new PicoIntrospectionException(String.valueOf(expectedType.getName()) + " not resolvable, no components of type " + this.getValueType(expectedType).getName() + " available");
                }
            } else {
                Iterator iter = componentAdapters.iterator();
                while (iter.hasNext()) {
                    ComponentAdapter componentAdapter = (ComponentAdapter)iter.next();
                    componentAdapter.verify(container);
                }
            }
        } else {
            throw new PicoIntrospectionException(String.valueOf(expectedType.getName()) + " is not a collective type");
        }
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    protected boolean evaluate(ComponentAdapter adapter) {
        return adapter != null;
    }

    protected Map getMatchingComponentAdapters(PicoContainer container, ComponentAdapter adapter, Class keyType, Class valueType) {
        HashMap<Object, ComponentAdapter> adapterMap = new HashMap<Object, ComponentAdapter>();
        PicoContainer parent = container.getParent();
        if (parent != null) {
            adapterMap.putAll(this.getMatchingComponentAdapters(parent, adapter, keyType, valueType));
        }
        Collection allAdapters = container.getComponentAdapters();
        Iterator iter = allAdapters.iterator();
        while (iter.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iter.next();
            adapterMap.remove(componentAdapter.getComponentKey());
        }
        List adapterList = container.getComponentAdaptersOfType(valueType);
        Iterator iter2 = adapterList.iterator();
        while (iter2.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iter2.next();
            Object key = componentAdapter.getComponentKey();
            if (adapter != null && key.equals(adapter.getComponentKey()) || !keyType.isAssignableFrom(key.getClass()) || !this.evaluate(componentAdapter)) continue;
            adapterMap.put(key, componentAdapter);
        }
        return adapterMap;
    }

    private Class getCollectionType(Class collectionType) {
        Class<?> collectionClass = null;
        if (collectionType.isArray()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.reflect.Array");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            collectionClass = clazz;
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(collectionType)) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.util.Map");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                collectionClass = clazz2;
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("java.util.Collection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.isAssignableFrom(collectionType)) {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.util.Collection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    collectionClass = clazz4;
                }
            }
        }
        return collectionClass;
    }

    private Class getValueType(Class collectionType) {
        Class<?> valueType = this.componentValueType;
        if (collectionType.isArray()) {
            valueType = collectionType.getComponentType();
        }
        return valueType;
    }

    private Object[] getArrayInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Object[] result = (Object[])Array.newInstance(expectedType.getComponentType(), adapterList.size());
        int i = 0;
        Iterator iterator = adapterList.values().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            result[i] = container.getComponentInstance(componentAdapter.getComponentKey());
            ++i;
        }
        return result;
    }

    private Collection getCollectionInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Class collectionType = expectedType;
        if (collectionType.isInterface()) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(collectionType)) {
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("java.util.ArrayList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                collectionType = clazz2;
            } else {
                Class<?> clazz3 = class$6;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$6 = Class.forName("java.util.SortedSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.isAssignableFrom(collectionType)) {
                    Class<?> clazz4 = class$7;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$7 = Class.forName("java.util.TreeSet");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    collectionType = clazz4;
                } else {
                    Class<?> clazz5 = class$8;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$8 = Class.forName("java.util.Set");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5.isAssignableFrom(collectionType)) {
                        Class<?> clazz6 = class$9;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$9 = Class.forName("java.util.HashSet");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        collectionType = clazz6;
                    } else {
                        Class<?> clazz7 = class$3;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$3 = Class.forName("java.util.Collection");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7.isAssignableFrom(collectionType)) {
                            Class<?> clazz8 = class$5;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$5 = Class.forName("java.util.ArrayList");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            collectionType = clazz8;
                        }
                    }
                }
            }
        }
        try {
            Collection result = (Collection)collectionType.newInstance();
            Iterator iterator = adapterList.values().iterator();
            while (iterator.hasNext()) {
                ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
                result.add(container.getComponentInstance(componentAdapter.getComponentKey()));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }

    private Map getMapInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Class collectionType = expectedType;
        if (collectionType.isInterface()) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("java.util.SortedMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(collectionType)) {
                Class<?> clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("java.util.TreeMap");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                collectionType = clazz2;
            } else {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.util.Map");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.isAssignableFrom(collectionType)) {
                    Class<?> clazz4 = class$12;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$12 = Class.forName("java.util.HashMap");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    collectionType = clazz4;
                }
            }
        }
        try {
            Map result = (Map)collectionType.newInstance();
            Iterator iterator = adapterList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                ComponentAdapter componentAdapter = (ComponentAdapter)entry.getValue();
                result.put(key, container.getComponentInstance(key));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }
}

