/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractPicoVisitor;

public class LifecycleVisitor
extends AbstractPicoVisitor {
    private static final Method START;
    private static final Method STOP;
    private static final Method DISPOSE;
    private final Method method;
    private final Class type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.picocontainer.Startable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            START = clazz.getMethod("start", null);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.picocontainer.Startable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            STOP = clazz2.getMethod("stop", null);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.picocontainer.Disposable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DISPOSE = clazz3.getMethod("dispose", null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public LifecycleVisitor(Method method, Class ofType, boolean visitInInstantiationOrder) {
        this.method = method;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList();
    }

    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            Iterator iterator = this.componentInstances.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                long startTime = System.currentTimeMillis();
                try {
                    this.method.invoke(o, null);
                }
                catch (IllegalArgumentException e) {
                    throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
                }
                catch (IllegalAccessException e) {
                    throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
                }
                catch (InvocationTargetException e) {
                    throw new PicoIntrospectionException("Failed when calling " + this.method.getName() + " on " + o, e.getTargetException());
                }
            }
        }
        finally {
            this.componentInstances.clear();
        }
        return Void.TYPE;
    }

    public void visitContainer(PicoContainer pico) {
        this.checkTraversal();
        this.componentInstances.addAll(pico.getComponentInstancesOfType(this.type));
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
    }

    public void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }

    public static void start(Object node) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.picocontainer.Startable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        new LifecycleVisitor(START, clazz, true).traverse(node);
    }

    public static void stop(Object node) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.picocontainer.Startable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        new LifecycleVisitor(STOP, clazz, false).traverse(node);
    }

    public static void dispose(Object node) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.picocontainer.Disposable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        new LifecycleVisitor(DISPOSE, clazz, false).traverse(node);
    }
}

