/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;

public class MultiplexerStressTest {
    Channel c11;
    Channel c12;
    Channel c21;
    Channel c22;
    Channel c31;
    Channel c32;
    ChannelFactory f1;
    ChannelFactory f2;
    ChannelFactory f3;
    private MyReceiver r11;
    private MyReceiver r12;
    private MyReceiver r21;
    private MyReceiver r22;
    private MyReceiver r31;
    private MyReceiver r32;
    static final int NUM_MSGS = 100000;
    static final int SIZE = 1000;

    private void start() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(7);
        this.f1 = new JChannelFactory();
        this.f2 = new JChannelFactory();
        this.f3 = new JChannelFactory();
        this.f1.setMultiplexerConfig("stacks.xml");
        this.f2.setMultiplexerConfig("stacks.xml");
        this.f3.setMultiplexerConfig("stacks.xml");
        this.c11 = this.f1.createMultiplexerChannel("udp", "A");
        this.c11.connect("X");
        this.r11 = new MyReceiver(barrier);
        this.c11.setReceiver(this.r11);
        this.c12 = this.f1.createMultiplexerChannel("udp", "B");
        this.c12.connect("X");
        this.r12 = new MyReceiver(barrier);
        this.c12.setReceiver(this.r12);
        this.c21 = this.f2.createMultiplexerChannel("udp", "A");
        this.c21.connect("X");
        this.r21 = new MyReceiver(barrier);
        this.c21.setReceiver(this.r21);
        this.c22 = this.f2.createMultiplexerChannel("udp", "B");
        this.c22.connect("X");
        this.r22 = new MyReceiver(barrier);
        this.c22.setReceiver(this.r22);
        this.c31 = this.f3.createMultiplexerChannel("udp", "A");
        this.c31.connect("X");
        this.r31 = new MyReceiver(barrier);
        this.c31.setReceiver(this.r31);
        this.c32 = this.f3.createMultiplexerChannel("udp", "B");
        this.c32.connect("X");
        this.r32 = new MyReceiver(barrier);
        this.c32.setReceiver(this.r32);
        new MySender(barrier, this.c11).start();
        new MySender(barrier, this.c12).start();
        new MySender(barrier, this.c21).start();
        new MySender(barrier, this.c22).start();
        new MySender(barrier, this.c31).start();
        new MySender(barrier, this.c32).start();
        barrier.await();
        long start = System.currentTimeMillis();
        barrier.await();
        long stop = System.currentTimeMillis();
        System.out.println("Cluster A:\n" + this.printStats(stop - start, new MyReceiver[]{this.r11, this.r21, this.r31}));
        System.out.println("Cluster B:\n" + this.printStats(stop - start, new MyReceiver[]{this.r12, this.r22, this.r32}));
        this.c32.close();
        this.c31.close();
        this.c21.close();
        this.c22.close();
        this.c12.close();
        this.c11.close();
    }

    private String printStats(long total_time, MyReceiver[] cluster) {
        int num_msgs = 0;
        long num_bytes = 0L;
        int cluster_size = cluster.length;
        for (int i = 0; i < cluster_size; ++i) {
            num_msgs = (int)((long)num_msgs + cluster[i].getNumMessages());
            num_bytes += cluster[i].getNumBytes();
        }
        double msgs_per_sec = (double)num_msgs / ((double)total_time / 1000.0);
        double bytes_per_sec = (double)(num_bytes * 1000L) / ((double)total_time / 1000.0);
        StringBuilder sb = new StringBuilder();
        sb.append("total msgs=").append(num_msgs).append(", msg rate=").append(msgs_per_sec);
        sb.append(", total time=").append((double)total_time / 1000.0);
        sb.append(", throughput=").append(Util.printBytes(bytes_per_sec));
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        new MultiplexerStressTest().start();
    }

    private static class MySender
    extends Thread {
        CyclicBarrier barrier;
        Channel ch;

        public MySender(CyclicBarrier barrier, Channel ch) {
            this.barrier = barrier;
            this.ch = ch;
        }

        public void run() {
            byte[] buf = new byte[1000];
            int print = 10000;
            try {
                this.barrier.await();
                for (int i = 1; i <= 100000; ++i) {
                    Message msg = new Message(null, null, buf, 0, buf.length);
                    this.ch.send(msg);
                    if (i % print != 0) continue;
                    System.out.println(this.getName() + ": sent " + i + " msgs");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        AtomicLong received_msgs = new AtomicLong(0L);
        AtomicLong received_bytes = new AtomicLong(0L);
        CyclicBarrier barrier;
        int print = 10000;

        public MyReceiver(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        public long getNumMessages() {
            return this.received_msgs.get();
        }

        public long getNumBytes() {
            return this.received_bytes.get();
        }

        public void receive(Message msg) {
            int length = msg.getLength();
            if (length > 0) {
                this.received_msgs.incrementAndGet();
                this.received_bytes.addAndGet(length);
                if (this.received_msgs.get() % (long)this.print == 0L) {
                    System.out.println("received " + this.received_msgs.get() + " msgs");
                }
                if (this.received_msgs.get() >= 100000L) {
                    try {
                        this.barrier.await();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

