/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.basic;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ThreadSafeSimpleDateFormat {
    private String formatString;
    private final int initialPoolSize;
    private final int maxPoolSize;
    private transient DateFormat[] pool;
    private int nextAvailable = 0;
    private Object mutex = new Object();

    public ThreadSafeSimpleDateFormat(String string, int n, int n2) {
        this.formatString = string;
        this.initialPoolSize = n;
        this.maxPoolSize = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormat dateFormat = this.fetchFromPool();
        try {
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            this.putInPool(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String string) throws ParseException {
        DateFormat dateFormat = this.fetchFromPool();
        try {
            Date date = dateFormat.parse(string);
            return date;
        }
        finally {
            this.putInPool(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateFormat fetchFromPool() {
        DateFormat dateFormat;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.nextAvailable = -1;
                this.pool = new DateFormat[this.maxPoolSize];
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.putInPool(this.createNew());
                }
            }
            while (this.nextAvailable < 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Interrupted whilst waiting for a free item in the pool : " + interruptedException.getMessage());
                }
            }
            dateFormat = this.pool[this.nextAvailable];
            --this.nextAvailable;
        }
        if (dateFormat == null) {
            dateFormat = this.createNew();
            this.putInPool(dateFormat);
        }
        return dateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(DateFormat dateFormat) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = dateFormat;
            this.mutex.notify();
        }
    }

    private DateFormat createNew() {
        return new SimpleDateFormat(this.formatString, Locale.ENGLISH);
    }
}

