/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JavaMethodConverter
implements Converter {
    private final ClassLoader classLoader;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$extended$JavaMethodConverter;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$reflect$Constructor;

    public JavaMethodConverter() {
        this((class$com$thoughtworks$xstream$converters$extended$JavaMethodConverter == null ? (class$com$thoughtworks$xstream$converters$extended$JavaMethodConverter = JavaMethodConverter.class$("com.thoughtworks.xstream.converters.extended.JavaMethodConverter")) : class$com$thoughtworks$xstream$converters$extended$JavaMethodConverter).getClassLoader());
    }

    public JavaMethodConverter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = JavaMethodConverter.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method) || clazz.equals(class$java$lang$reflect$Constructor == null ? (class$java$lang$reflect$Constructor = JavaMethodConverter.class$("java.lang.reflect.Constructor")) : class$java$lang$reflect$Constructor);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        if (object instanceof Method) {
            Method method = (Method)object;
            String string = method.getDeclaringClass().getName();
            this.marshalMethod(hierarchicalStreamWriter, string, method.getName(), method.getParameterTypes());
        } else {
            Constructor constructor = (Constructor)object;
            String string = constructor.getDeclaringClass().getName();
            this.marshalMethod(hierarchicalStreamWriter, string, null, constructor.getParameterTypes());
        }
    }

    private void marshalMethod(HierarchicalStreamWriter hierarchicalStreamWriter, String string, String string2, Class[] classArray) {
        hierarchicalStreamWriter.startNode("class");
        hierarchicalStreamWriter.setValue(string);
        hierarchicalStreamWriter.endNode();
        if (string2 != null) {
            hierarchicalStreamWriter.startNode("name");
            hierarchicalStreamWriter.setValue(string2);
            hierarchicalStreamWriter.endNode();
        }
        hierarchicalStreamWriter.startNode("parameter-types");
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            hierarchicalStreamWriter.startNode("class");
            hierarchicalStreamWriter.setValue(clazz.getName());
            hierarchicalStreamWriter.endNode();
        }
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        try {
            Class[] classArray;
            boolean bl = unmarshallingContext.getRequiredType().equals(class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = JavaMethodConverter.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
            hierarchicalStreamReader.moveDown();
            String string = hierarchicalStreamReader.getValue();
            Class clazz = this.loadClass(string);
            hierarchicalStreamReader.moveUp();
            String string2 = null;
            if (bl) {
                hierarchicalStreamReader.moveDown();
                string2 = hierarchicalStreamReader.getValue();
                hierarchicalStreamReader.moveUp();
            }
            hierarchicalStreamReader.moveDown();
            ArrayList<Class> arrayList = new ArrayList<Class>();
            while (hierarchicalStreamReader.hasMoreChildren()) {
                hierarchicalStreamReader.moveDown();
                classArray = hierarchicalStreamReader.getValue();
                arrayList.add(this.loadClass((String)classArray));
                hierarchicalStreamReader.moveUp();
            }
            classArray = arrayList.toArray(new Class[arrayList.size()]);
            hierarchicalStreamReader.moveUp();
            if (bl) {
                return clazz.getMethod(string2, classArray);
            }
            return clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConversionException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConversionException(noSuchMethodException);
        }
    }

    private Class loadClass(String string) throws ClassNotFoundException {
        return this.classLoader.loadClass(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

