/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CQJDBCStorageConnection
extends JDBCStorageConnection {
    protected String FIND_NODES_BY_PARENTID_CQ;
    protected String FIND_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_REFERENCE_PROPERTIES_CQ;
    protected String FIND_ITEM_QPATH_BY_ID_CQ;

    protected CQJDBCStorageConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<NodeData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                PersistedNodeData nodeData;
                resultSet = this.findChildNodesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
                TempNodeData data = null;
                ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
                while (resultSet.next()) {
                    if (data == null) {
                        data = new TempNodeData(resultSet);
                    } else if (!resultSet.getString("ID").equals(data.cid)) {
                        nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                        childNodes.add(nodeData);
                        data = new TempNodeData(resultSet);
                    }
                    Map<String, List<byte[]>> properties = data.properties;
                    String key = resultSet.getString("PROP_NAME");
                    List<byte[]> values = properties.get(key);
                    if (values == null) {
                        values = new ArrayList<byte[]>();
                        properties.put(key, values);
                    }
                    values.add(resultSet.getBytes("DATA"));
                }
                if (data != null) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                }
                arrayList = childNodes;
                Object var9_10 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                resultSet = this.findChildPropertiesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
                ArrayList<PropertyData> children = new ArrayList<PropertyData>();
                QPath parentPath = parent.getQPath();
                if (resultSet.next()) {
                    boolean isNotLast = true;
                    do {
                        QPath qpath;
                        String cid = resultSet.getString("ID");
                        String identifier = this.getIdentifier(cid);
                        String cname = resultSet.getString("NAME");
                        int cversion = resultSet.getInt("VERSION");
                        String cpid = resultSet.getString("PARENT_ID");
                        int cptype = resultSet.getInt("P_TYPE");
                        boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                        try {
                            qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
                        }
                        catch (IllegalNameException e) {
                            throw new RepositoryException(e.getMessage(), (Throwable)e);
                        }
                        PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued);
                        ArrayList<ValueData> data = new ArrayList<ValueData>();
                        do {
                            int orderNum = resultSet.getInt("ORDER_NUM");
                            if (resultSet.wasNull()) continue;
                            String storageId = resultSet.getString("STORAGE_DESC");
                            ValueData vdata = resultSet.wasNull() ? this.readValueData(cid, orderNum, cversion, resultSet.getBinaryStream("DATA")) : this.readValueData(identifier, orderNum, storageId);
                            data.add(vdata);
                        } while ((isNotLast = resultSet.next()) && resultSet.getString("ID").equals(cid));
                        pdata.setValues(data);
                        children.add(pdata);
                    } while (isNotLast);
                }
                arrayList = children;
                Object var20_23 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    @Override
    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet refProps = this.findReferencePropertiesCQ(this.getInternalId(nodeIdentifier));
            return this.loadReferences(refProps);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private List<PropertyData> loadReferences(ResultSet resultSet) throws RepositoryException, SQLException, IOException {
        ArrayList<PropertyData> resultProps = new ArrayList<PropertyData>();
        HashMap<String, Integer> dublicatedProps = new HashMap<String, Integer>();
        HashMap<String, PersistedPropertyData> propertyBuffer = new HashMap<String, PersistedPropertyData>();
        HashMap<String, List> valuesBuffer = new HashMap<String, List>();
        try {
            try {
                while (resultSet.next()) {
                    String cid = resultSet.getString("ID");
                    String identifier = this.getIdentifier(cid);
                    int cversion = resultSet.getInt("VERSION");
                    int valueOrderNum = resultSet.getInt("ORDER_NUM");
                    PersistedPropertyData prop = (PersistedPropertyData)propertyBuffer.get(identifier);
                    if (prop == null) {
                        String cname = resultSet.getString("NAME");
                        String cpid = resultSet.getString("PARENT_ID");
                        int cptype = resultSet.getInt("P_TYPE");
                        boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                        QPath qpath = QPath.makeChildPath(this.traverseQPath(cpid), InternalQName.parse(cname));
                        prop = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued);
                        propertyBuffer.put(identifier, prop);
                        valuesBuffer.put(identifier, new ArrayList());
                        dublicatedProps.put(identifier, new Integer(1));
                    }
                    List values = (List)valuesBuffer.get(identifier);
                    if (valueOrderNum == 0 && values.size() > 0) {
                        Integer copies;
                        Integer cptype = copies = (Integer)dublicatedProps.get(identifier);
                        Integer cpmultivalued = copies = Integer.valueOf(copies + 1);
                        dublicatedProps.put(identifier, copies);
                        continue;
                    }
                    if (values.size() > valueOrderNum) continue;
                    String storageId = resultSet.getString("STORAGE_DESC");
                    ValueData vdata = resultSet.wasNull() ? this.readValueData(cid, valueOrderNum, cversion, resultSet.getBinaryStream("DATA")) : this.readValueData(identifier, valueOrderNum, storageId);
                    values.add(vdata);
                    valuesBuffer.put(identifier, values);
                }
                for (String id : propertyBuffer.keySet()) {
                    PersistedPropertyData prop = (PersistedPropertyData)propertyBuffer.get(id);
                    List values = (List)valuesBuffer.get(id);
                    int count = (Integer)dublicatedProps.get(id);
                    for (int i = 0; i < count; ++i) {
                        ArrayList<ByteArrayPersistedValueData> newValues = new ArrayList<ByteArrayPersistedValueData>();
                        for (ValueData vd : values) {
                            newValues.add(new ByteArrayPersistedValueData(vd.getAsByteArray(), vd.getOrderNumber()));
                        }
                        PersistedPropertyData pdata = new PersistedPropertyData(prop.getIdentifier(), prop.getQPath(), prop.getParentIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.isMultiValued());
                        pdata.setValues(newValues);
                        resultProps.add(pdata);
                    }
                    values.clear();
                }
                Object var17_28 = null;
                propertyBuffer.clear();
                valuesBuffer.clear();
                dublicatedProps.clear();
            }
            catch (IllegalNameException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var17_29 = null;
            propertyBuffer.clear();
            valuesBuffer.clear();
            dublicatedProps.clear();
            throw throwable;
        }
        return resultProps;
    }

    protected List<AccessControlEntry> readACLPermisions(String cid, Map<String, List<byte[]>> properties) throws SQLException, IllegalACLException {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        List<byte[]> permValues = properties.get(Constants.EXO_PERMISSIONS.getAsString());
        if (permValues != null) {
            for (byte[] value : permValues) {
                StringTokenizer parser = new StringTokenizer(new String(value), " ");
                naPermissions.add(new AccessControlEntry(parser.nextToken(), parser.nextToken()));
            }
            return naPermissions;
        }
        throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
    }

    protected String readACLOwner(String cid, Map<String, List<byte[]>> properties) throws IllegalACLException {
        List<byte[]> ownerValues = properties.get(Constants.EXO_OWNER.getAsString());
        if (ownerValues != null) {
            return new String(ownerValues.get(0));
        }
        throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
    }

    @Override
    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        ResultSet ptProp = this.findNodeMainPropertiesByParentIdentifierCQ(cid);
        HashMap<String, List<byte[]>> properties = new HashMap<String, List<byte[]>>();
        while (ptProp.next()) {
            String key = ptProp.getString("NAME");
            ArrayList<byte[]> values = (ArrayList<byte[]>)properties.get(key);
            if (values == null) {
                values = new ArrayList<byte[]>();
                properties.put(key, values);
            }
            values.add(ptProp.getBytes("DATA"));
        }
        return this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, properties, parentACL);
    }

    protected PersistedNodeData loadNodeFromTemporaryNodeData(TempNodeData tempData, QPath parentPath, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        return this.loadNodeRecord(parentPath, tempData.cname, tempData.cid, tempData.cpid, tempData.cindex, tempData.cversion, tempData.cnordernumb, tempData.properties, parentACL);
    }

    private PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, Map<String, List<byte[]>> properties, AccessControlList parentACL) throws RepositoryException, SQLException {
        try {
            InternalQName[] mts;
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex);
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex);
                parentCid = cpid;
            }
            List<byte[]> primaryType = properties.get(Constants.JCR_PRIMARYTYPE.getAsString());
            if (primaryType == null || primaryType.isEmpty()) {
                throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + cid + ", container " + this.containerName, null);
            }
            byte[] data = primaryType.get(0);
            InternalQName ptName = InternalQName.parse(new String(data != null ? data : new byte[]{}));
            boolean owneable = false;
            boolean privilegeable = false;
            List<byte[]> mixTypes = properties.get(Constants.JCR_MIXINTYPES.getAsString());
            if (mixTypes != null) {
                ArrayList<InternalQName> mNames = new ArrayList<InternalQName>();
                for (byte[] mxnb : mixTypes) {
                    InternalQName mxn = InternalQName.parse(new String(mxnb));
                    mNames.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                }
                mts = new InternalQName[mNames.size()];
                mNames.toArray(mts);
            } else {
                mts = new InternalQName[]{};
            }
            try {
                AccessControlList acl = owneable ? (privilegeable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid, properties), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid, properties), null))) : (privilegeable ? (owneable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid, properties)) : new AccessControlList(null, this.readACLPermisions(cid, properties)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                return new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mts, acl);
            }
            catch (IllegalACLException e) {
                throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
            }
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        String id = this.getIdentifier(cpid);
        if (id.equals("00exo0jcr0root0uuid0000000000000")) {
            return Constants.ROOT_PATH;
        }
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        String caid = cpid;
        boolean isRoot = false;
        do {
            Object var11_11;
            ResultSet result = null;
            try {
                result = this.findItemQPathByIdentifierCQ(caid);
                if (!result.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                QPathEntry qpe1 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"));
                boolean isChild = caid.equals(result.getString("ID"));
                caid = result.getString("PARENT_ID");
                if (result.next()) {
                    QPathEntry qpe2 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"));
                    if (isChild) {
                        qrpath.add(qpe1);
                        qrpath.add(qpe2);
                        caid = result.getString("PARENT_ID");
                    } else {
                        qrpath.add(qpe2);
                        qrpath.add(qpe1);
                    }
                } else {
                    qrpath.add(qpe1);
                }
                var11_11 = null;
            }
            catch (Throwable throwable) {
                var11_11 = null;
                result.close();
                throw throwable;
            }
            result.close();
            if (!caid.equals(Constants.ROOT_PARENT_UUID) && !(id = this.getIdentifier(caid)).equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (id.equals("00exo0jcr0root0uuid0000000000000")) {
                qrpath.add(Constants.ROOT_PATH.getEntries()[0]);
            }
            isRoot = true;
        } while (!isRoot);
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    protected abstract ResultSet findItemQPathByIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findNodeMainPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findReferencePropertiesCQ(String var1) throws SQLException;

    private static class TempNodeData {
        String cid;
        String cname;
        int cversion;
        String cpid;
        int cindex;
        int cnordernumb;
        Map<String, List<byte[]>> properties = new HashMap<String, List<byte[]>>();

        public TempNodeData(ResultSet item) throws SQLException {
            this.cid = item.getString("ID");
            this.cname = item.getString("NAME");
            this.cversion = item.getInt("VERSION");
            this.cpid = item.getString("PARENT_ID");
            this.cindex = item.getInt("I_INDEX");
            this.cnordernumb = item.getInt("N_ORDER_NUM");
        }
    }
}

