/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;

public final class JTAHelper {
    private JTAHelper() {
    }

    public static boolean isRollback(int status) {
        return status == 1 || status == 9 || status == 4;
    }

    public static boolean isInProgress(int status) {
        return status == 0 || status == 1;
    }

    public static boolean isTransactionInProgress(SessionFactoryImplementor factory) {
        TransactionManager tm = factory.getTransactionManager();
        try {
            return tm != null && JTAHelper.isTransactionInProgress(tm.getTransaction());
        }
        catch (SystemException se) {
            throw new TransactionException("could not obtain JTA Transaction", (Exception)((Object)se));
        }
    }

    public static boolean isTransactionInProgress(Transaction tx) throws SystemException {
        return tx != null && JTAHelper.isInProgress(tx.getStatus());
    }
}

