/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.ViewId;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements Externalizable,
Cloneable,
Streamable {
    protected ViewId vid = null;
    protected Vector<Address> members = null;

    public View() {
    }

    public View(ViewId vid, Vector<Address> members) {
        this.vid = vid;
        this.members = members;
    }

    public View(Address creator, long id, Vector<Address> members) {
        this(new ViewId(creator, id), members);
    }

    public ViewId getVid() {
        return this.vid;
    }

    public Address getCreator() {
        return this.vid != null ? this.vid.getCoordAddress() : null;
    }

    public Vector<Address> getMembers() {
        return Util.unmodifiableVector(this.members);
    }

    public boolean containsMember(Address mbr) {
        return mbr != null && this.members != null && this.members.contains(mbr);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof View)) {
            return false;
        }
        if (this.vid != null) {
            int rc = this.vid.compareTo(((View)obj).vid);
            if (rc != 0) {
                return false;
            }
            if (this.members != null && ((View)obj).members != null) {
                return this.members.equals(((View)obj).members);
            }
        } else if (((View)obj).vid == null) {
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.vid != null ? this.vid.hashCode() : 0;
    }

    public int size() {
        return this.members == null ? 0 : this.members.size();
    }

    public Object clone() {
        ViewId vid2 = this.vid != null ? (ViewId)this.vid.clone() : null;
        Vector<Address> members2 = this.members != null ? new Vector<Address>(this.members) : null;
        return new View(vid2, members2);
    }

    public String printDetails() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.vid).append("\n\t");
        if (this.members != null) {
            for (int i = 0; i < this.members.size(); ++i) {
                ret.append(this.members.elementAt(i)).append("\n\t");
            }
            ret.append('\n');
        }
        return ret.toString();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append(this.vid).append(" ").append(this.members);
        return ret.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.vid);
        out.writeObject(this.members);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.vid = (ViewId)in.readObject();
        this.members = (Vector)in.readObject();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        if (this.vid != null) {
            out.writeBoolean(true);
            this.vid.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        Util.writeAddresses(this.members, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        boolean b = in.readBoolean();
        if (b) {
            this.vid = new ViewId();
            this.vid.readFrom(in);
        }
        this.members = (Vector)Util.readAddresses(in, Vector.class);
    }

    public int serializedSize() {
        int retval = 1;
        if (this.vid != null) {
            retval += this.vid.serializedSize();
        }
        retval = (int)((long)retval + Util.size(this.members));
        return retval;
    }
}

