/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class List
implements Externalizable,
Cloneable {
    protected Element head = null;
    protected Element tail = null;
    protected int size = 0;
    protected final transient Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        Element el = new Element(obj);
        Object object = this.mutex;
        synchronized (object) {
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                el.prev = this.tail;
                this.tail.next = el;
                this.tail = el;
                ++this.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtHead(Object obj) {
        Element el = new Element(obj);
        Object object = this.mutex;
        synchronized (object) {
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                el.next = this.head;
                this.head.prev = el;
                this.head = el;
                ++this.size;
            }
        }
    }

    public void addAll(Collection c) {
        if (c == null) {
            return;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Element retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.tail == null) {
                return null;
            }
            retval = this.tail;
            if (this.head == this.tail) {
                this.head = null;
                this.tail = null;
            } else {
                this.tail.prev.next = null;
                this.tail = this.tail.prev;
                retval.prev = null;
            }
            --this.size;
        }
        return retval.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromHead() {
        Element retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.head == null) {
                return null;
            }
            retval = this.head;
            if (this.head == this.tail) {
                this.head = null;
                this.tail = null;
            } else {
                this.head = this.head.next;
                this.head.prev = null;
                retval.next = null;
            }
            --this.size;
        }
        return retval.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.tail != null ? this.tail.obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekAtHead() {
        Object object = this.mutex;
        synchronized (object) {
            return this.head != null ? this.head.obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeElement(Object obj) {
        Element el = null;
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            el = this.head;
            while (el != null) {
                if (el.obj.equals(obj)) {
                    retval = el.obj;
                    if (this.head == this.tail) {
                        this.head = null;
                        this.tail = null;
                    } else if (el.prev == null) {
                        this.head = el.next;
                        this.head.prev = null;
                        el.next = null;
                    } else if (el.next == null) {
                        this.tail = el.prev;
                        this.tail.next = null;
                        el.prev = null;
                    } else {
                        el.prev.next = el.next;
                        el.next.prev = el.prev;
                        el.next = null;
                        el.prev = null;
                    }
                    --this.size;
                    break;
                }
                el = el.next;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.mutex;
        synchronized (object) {
            this.size = 0;
            this.head = null;
            this.tail = null;
        }
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("[");
        Element el = this.head;
        while (el != null) {
            if (el.obj != null) {
                ret.append(el.obj).append(" ");
            }
            el = el.next;
        }
        ret.append(']');
        return ret.toString();
    }

    public String toStringWithDelimiter(String delimiter) {
        Element el = this.head;
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        while (el != null) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(el.obj);
            el = el.next;
        }
        return sb.toString();
    }

    public String dump() {
        StringBuilder ret = new StringBuilder("[");
        Element el = this.head;
        while (el != null) {
            ret.append(el.obj).append(" ");
            el = el.next;
        }
        return ret.toString() + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getContents() {
        Vector<Object> retval = new Vector<Object>(this.size);
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            while (el != null) {
                retval.addElement(el.obj);
                el = el.next;
            }
        }
        return retval;
    }

    public Enumeration elements() {
        return new ListEnumerator(this.head);
    }

    public boolean contains(Object obj) {
        Element el = this.head;
        while (el != null) {
            if (el.obj != null && el.obj.equals(obj)) {
                return true;
            }
            el = el.next;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List copy() {
        List retval = new List();
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            while (el != null) {
                retval.add(el.obj);
                el = el.next;
            }
        }
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            out.writeInt(this.size);
            for (int i = 0; i < this.size; ++i) {
                out.writeObject(el.obj);
                el = el.next;
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int new_size = in.readInt();
        if (new_size == 0) {
            return;
        }
        for (int i = 0; i < new_size; ++i) {
            Object obj = in.readObject();
            this.add(obj);
        }
    }

    public static void main(String[] args) {
        List l = new List();
        l.addAtHead(new Integer(1));
        l.addAtHead(new Integer(2));
        l.addAtHead(new Integer(3));
        l.addAtHead(new Integer(4));
        l.addAtHead(new Integer(5));
        System.out.println("list: " + l.toStringWithDelimiter(", "));
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.println("Removed from head: " + l.removeFromHead());
        System.out.print("Adding 50000 numbers:");
        for (long i = 0L; i < 50000L; ++i) {
            Long n = new Long(i);
            if (i % 2L == 0L) {
                l.addAtHead(n);
                continue;
            }
            l.add(n);
        }
        System.out.println(" OK");
        long num = 0L;
        System.out.print("Removing all elements: ");
        while (l.remove() != null) {
            ++num;
        }
        System.out.println("OK, removed " + num + " objects");
    }

    class ListEnumerator
    implements Enumeration {
        Element curr = null;

        ListEnumerator(Element start) {
            this.curr = start;
        }

        public boolean hasMoreElements() {
            return this.curr != null;
        }

        public Object nextElement() {
            if (this.curr == null) {
                throw new NoSuchElementException();
            }
            Object retval = this.curr.obj;
            this.curr = this.curr.next;
            return retval;
        }
    }

    class Element {
        Object obj = null;
        Element next = null;
        Element prev = null;

        Element(Object o) {
            this.obj = o;
        }
    }
}

