/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.connectors.jcr;

import java.net.MalformedURLException;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.rmi.impl.server.JCRServerImpl;

public class RMIStarter {
    public static final int DO_BIND = 1;
    public static final int DO_UNBIND = 2;

    public static void main(String[] argv) {
        int bindOper = 0;
        if (argv.length > 0) {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("bind")) {
                    bindOper = 1;
                    continue;
                }
                if (argv[i].equals("unbind")) {
                    bindOper = 2;
                    continue;
                }
                if (i != 1) continue;
                try {
                    StandaloneContainer.addConfigurationPath((String)argv[i]);
                    continue;
                }
                catch (MalformedURLException e) {
                    System.out.println("Error: malformed url in repository configuration, didn't set");
                }
            }
        }
        try {
            StandaloneContainer sc = StandaloneContainer.getInstance();
            JCRServerImpl binder = (JCRServerImpl)sc.getComponentInstanceOfType(JCRServerImpl.class);
            if (bindOper == 1) {
                binder.bind();
                System.out.println("JCR RMI service registered (bind) and started successfully");
            } else if (bindOper == 2) {
                binder.unbind();
                System.out.println("JCR RMI service unregistered (unbind) successfully");
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }
}

