/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.versioning;

import com.sun.japex.TestCase;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.version.Version;
import org.apache.commons.logging.Log;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.log.ExoLogger;

public class RestoreOwnNodeTest
extends JCRTestBase {
    public static Log log = ExoLogger.getLogger((String)"jcr.benchmark");
    private Node rootNode = null;
    private Random rand = new Random();
    private String name = "";
    private Version version0 = null;
    private Version version1 = null;
    private Version version2 = null;
    private Version version3 = null;
    private Version version4 = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.name = context.generateUniqueName("rootNode");
        this.rootNode = context.getSession().getRootNode().addNode(this.name);
        this.rootNode.addMixin("mix:versionable");
        context.getSession().save();
        this.version0 = this.rootNode.checkin();
        this.rootNode.checkout();
        this.rootNode.addNode("someChildNode");
        context.getSession().save();
        this.version1 = this.rootNode.checkin();
        this.rootNode.checkout();
        this.rootNode.getNode("someChildNode").remove();
        context.getSession().save();
        this.version2 = this.rootNode.checkin();
        this.rootNode.checkout();
        this.rootNode.addNode("otherChildNode1").addNode("otherChildNode2");
        context.getSession().save();
        this.version3 = this.rootNode.checkin();
        this.rootNode.checkout();
        this.rootNode.getNode("otherChildNode1/otherChildNode2").remove();
        context.getSession().save();
        this.version4 = this.rootNode.checkin();
        this.rootNode.checkout();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        int index = this.rand.nextInt(5);
        switch (index) {
            case 0: {
                this.rootNode.restore(this.version0, true);
                break;
            }
            case 1: {
                this.rootNode.restore(this.version1, true);
                break;
            }
            case 2: {
                this.rootNode.restore(this.version2, true);
                break;
            }
            case 3: {
                this.rootNode.restore(this.version3, true);
                break;
            }
            case 4: {
                this.rootNode.restore(this.version3, true);
            }
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.rootNode.remove();
        context.getSession().save();
    }
}

