/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemNameTest;

public class NodeMoveNodeWithPropertiesTest
extends AbstractGetItemNameTest {
    private int binaryPropertySize;
    private byte[] binaryValue;
    private Node destination;
    private String stringValue = "Content Repository API for Java (JCR) is a specification for a Java platform API for accessing content repositories in a uniform manner.[1] [2] The content repositories are used in content management systems to keep the content data and also the meta-data used in CMS such as versioning meta-data. The specification was developed under the Java Community Process as JSR-170 (Version 1)[3][4] and as JSR-283 (Version 2)[5]. The main Java package is javax.jcr. \r\n Overview \r\n A JCR is a type of Object Database tailored to the storage, searching, and retrieval of hierarchical data. The JCR API grew out of the needs of content management systems, which require storage of documents and other binary objects with associated metadata. However the API is applicable to many types of applications. In addition to object storage the JCR provides APIs for versioning of data, transactions, observation of changes in data, and import or export of data to XML in a standard way. \r\n source: http://en.wikipedia.org/wiki/Content_repository_API_for_Java";

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.binaryPropertySize = tc.getIntParam("ext.fileSizeInKb") * 1024;
        this.binaryValue = new byte[this.binaryPropertySize];
        Random generator = new Random();
        generator.nextBytes(this.binaryValue);
        this.destination = context.getSession().getRootNode().addNode(context.generateUniqueName("destination"));
        super.doPrepare(tc, context);
    }

    protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
        Node nodeToMove = parent.addNode(context.generateUniqueName("nodeToMove"));
        nodeToMove.setProperty("stringProperty", this.stringValue, 1);
        nodeToMove.setProperty("binaryProperty", context.getSession().getValueFactory().createValue((InputStream)new ByteArrayInputStream(this.binaryValue)), 2);
        if (!this.destination.hasNode(parent.getName())) {
            this.destination.addNode(parent.getName());
        }
        this.addName(parent.getName() + "/" + nodeToMove.getName());
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        String nodeName = this.nextName();
        String src = this.rootNode.getPath() + "/" + nodeName;
        String dest = this.destination.getPath() + "/" + nodeName;
        this.rootNode.getSession().getWorkspace().move(src, dest);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.destination.remove();
        super.doFinish(tc, context);
    }
}

