/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.version;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemTest;

public class WorkspaceRestoreTest
extends AbstractGetItemTest {
    private List<Version[]> versions = new ArrayList<Version[]>();

    protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
        Node nodeA = parent.addNode(context.generateUniqueName("versionableNodeA"));
        nodeA.addMixin("mix:versionable");
        parent.save();
        nodeA.checkin();
        nodeA.checkout();
        Node nodeB = nodeA.addNode("Subnode B");
        nodeA.save();
        nodeB.addMixin("mix:versionable");
        nodeA.save();
        nodeB.checkin();
        Node nodeC = nodeA.addNode("Subnode C");
        nodeA.save();
        nodeC.addMixin("mix:versionable");
        nodeA.save();
        nodeC.checkin();
        nodeC.checkout();
        nodeC.setProperty("Property Y", nodeB);
        nodeC.save();
        Version vC = nodeC.checkin();
        nodeC.checkout();
        nodeB.checkout();
        nodeB.setProperty("Property X", nodeC);
        nodeB.save();
        Version vB = nodeB.checkin();
        nodeB.checkout();
        nodeA.setProperty("Property", "property of subnode");
        nodeB.remove();
        nodeC.remove();
        nodeA.save();
        Version vA = nodeA.checkin();
        nodeA.checkout();
        this.versions.add(new Version[]{vA, vB, vC});
        this.addNode(nodeA);
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Version[] vs = this.versions.get(this.getCurrentIteration());
        this.nextNode().getSession().getWorkspace().restore(vs, true);
    }
}

