/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.workspace.write;

import com.sun.japex.TestCase;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public abstract class AbstractItemsInDifferentWorkspacesTest
extends JCRTestBase {
    protected Node ws1RootNode = null;
    protected Node ws2RootNode = null;
    protected final String WS1 = "collaboration";
    protected final String WS2 = "system";
    private String testRootNodeName = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int runIterations = tc.getIntParam("japex.runIterations");
        if (runIterations <= 0) {
            throw new Exception("japex.runIterations should be a positive number, but " + runIterations);
        }
        this.testRootNodeName = context.generateUniqueName("testRoot");
        Session ws1Session = context.getSession().getRepository().login("collaboration");
        Session ws2Session = context.getSession().getRepository().login("system");
        this.ws1RootNode = ws1Session.getRootNode().addNode(this.testRootNodeName);
        this.ws2RootNode = ws2Session.getRootNode().addNode(this.testRootNodeName);
        ws1Session.save();
        ws2Session.save();
        Node ws1Parent = null;
        Node ws2Parent = null;
        for (int i = 0; i < runIterations; ++i) {
            if (i % 100 == 0) {
                String testParentNodeName = context.generateUniqueName("testParent");
                ws1Parent = this.ws1RootNode.addNode(testParentNodeName);
                ws2Parent = this.ws2RootNode.addNode(testParentNodeName);
                this.ws1RootNode.save();
                this.ws2RootNode.save();
            }
            this.ws1CreateContent(ws1Parent, tc, context);
            this.ws2CreateContent(ws2Parent, tc, context);
        }
        ws1Session.save();
        ws2Session.save();
    }

    protected abstract void ws1CreateContent(Node var1, TestCase var2, JCRTestContext var3) throws Exception;

    protected abstract void ws2CreateContent(Node var1, TestCase var2, JCRTestContext var3) throws Exception;

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.ws1RootNode.remove();
        this.ws1RootNode.getSession().save();
        this.ws2RootNode.remove();
        this.ws2RootNode.getSession().save();
    }
}

