/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import org.apache.commons.logging.Log;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.usecases.AbstractMoveUsecaseTest;
import org.exoplatform.services.log.ExoLogger;

public class MoveToDiffLocationsTest
extends AbstractMoveUsecaseTest {
    protected static Log LOG = ExoLogger.getLogger((String)"MoveToDiffDirectionsTest");

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        NodeIterator testNodes = this.nextNode().getNodes();
        while (testNodes.hasNext()) {
            Node d;
            Node m;
            Node y;
            Node nodeToMove = testNodes.nextNode();
            Calendar fileDate = nodeToMove.getProperty("jcr:content/jcr:lastModified").getDate();
            String year = String.valueOf(fileDate.get(1));
            String month = String.valueOf(fileDate.get(2));
            String day = String.valueOf(fileDate.get(5));
            Node catalog = this.rootNode.getNode("catalog");
            try {
                y = catalog.getNode(year);
            }
            catch (PathNotFoundException e) {
                y = catalog.addNode(year);
            }
            try {
                m = y.getNode(month);
            }
            catch (PathNotFoundException e) {
                m = y.addNode(month);
            }
            try {
                d = m.getNode(day);
            }
            catch (PathNotFoundException e) {
                d = m.addNode(day);
            }
            long start = System.currentTimeMillis();
            String src = nodeToMove.getPath();
            String dest = d.getPath() + "/" + nodeToMove.getName();
            this.rootNode.getSession().getWorkspace().move(src, dest);
            LOG.info((Object)(src + " --> " + dest + " -- " + (System.currentTimeMillis() - start) + "ms"));
        }
    }
}

