/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.sdb;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBWorkspaceStorageConnection;
import org.exoplatform.services.jcr.aws.storage.sdb.StorageCleaner;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SDBWorkspaceDataContainer
extends WorkspaceDataContainerBase {
    public static final String CURRENT_STORAGE_VERSION = "1.0-b2";
    public static final String SDB_ACCESSKEY = "aws-access-key";
    public static final String SDB_SECRETKEY = "aws-secret-access-key";
    public static final String SDB_DOMAINNAME = "domain-name";
    protected static final int CLEANER_TIMEOUT = 1200000;
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.SDBWorkspaceDataContainer");
    protected final String containerName;
    protected final String storageVersion;
    protected final String accessKey;
    protected final String secretKey;
    protected final String domainName;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected final int maxBufferSize;
    protected final StorageCleaner storageCleaner;

    public SDBWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, ValueStoragePluginProvider valueStorageProvider) throws RepositoryConfigurationException, RepositoryException {
        int maxbs;
        String myAccessKey = wsConfig.getContainer().getParameterValue(SDB_ACCESSKEY);
        if (myAccessKey == null || myAccessKey.length() <= 0) {
            throw new RepositoryConfigurationException("AWS (SimpleDB) Access key required");
        }
        String mySecretKey = wsConfig.getContainer().getParameterValue(SDB_SECRETKEY);
        if (mySecretKey == null || mySecretKey.length() <= 0) {
            throw new RepositoryConfigurationException("AWS (SimpleDB) Secret key required");
        }
        String myDomainName = wsConfig.getContainer().getParameterValue(SDB_DOMAINNAME);
        if (myDomainName == null || myDomainName.length() <= 0) {
            throw new RepositoryConfigurationException("AWS (SimpleDB) domain name required");
        }
        this.accessKey = myAccessKey;
        this.secretKey = mySecretKey;
        this.domainName = myDomainName;
        this.valueStorageProvider = valueStorageProvider;
        try {
            maxbs = wsConfig.getContainer().getParameterInteger("max-buffer-size");
        }
        catch (RepositoryConfigurationException e) {
            maxbs = 204800;
        }
        this.maxBufferSize = maxbs;
        this.containerName = wsConfig.getName();
        SDBWorkspaceStorageConnection conn = new SDBWorkspaceStorageConnection(this.accessKey, this.secretKey, this.domainName, this.maxBufferSize, valueStorageProvider);
        this.storageVersion = conn.initStorage(this.containerName, CURRENT_STORAGE_VERSION);
        this.storageCleaner = new StorageCleaner(this.containerName, conn, 1200000);
        this.storageCleaner.start();
        LOG.info((Object)this.getInfo());
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        return new SDBWorkspaceStorageConnection(this.accessKey, this.secretKey, this.domainName, this.maxBufferSize, this.valueStorageProvider);
    }

    public WorkspaceStorageConnection reuseConnection(WorkspaceStorageConnection original) throws RepositoryException {
        return this.openConnection();
    }

    public String getInfo() {
        String str = "SimpleDB based JCR Workspace Data container \ncontainer name: " + this.containerName + " \n" + "domain name: " + this.domainName + "\n" + "storage version: " + this.storageVersion + "\n" + "value storage provider: " + this.valueStorageProvider + "\n" + "max buffer size (bytes): " + this.maxBufferSize;
        return str;
    }

    public String getName() {
        return this.containerName;
    }

    public String getStorageVersion() {
        return this.storageVersion;
    }

    public boolean isSame(WorkspaceDataContainer another) {
        return ((Object)((Object)this)).equals(another);
    }
}

