/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.value.s3;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.aws.storage.value.s3.S3File;
import org.exoplatform.services.jcr.aws.storage.value.s3.S3ValueIOUtil;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class S3IOChannel
implements ValueIOChannel {
    protected static Log log = ExoLogger.getLogger((String)"S3IOChannel");
    protected final String bucket;
    protected final String awsAccessKey;
    protected final String awsSecretAccessKey;
    protected final File s3SwapDirectory;
    protected final FileCleaner cleaner;
    protected final String storageId;
    protected final List<ValueOperation> changes = new ArrayList<ValueOperation>();

    public S3IOChannel(String bucket, String awsAccessKey, String awsSecretAccessKey, File s3SwapDirectory, FileCleaner cleaner, String storageId) {
        this.bucket = bucket;
        this.awsAccessKey = awsAccessKey;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.s3SwapDirectory = s3SwapDirectory;
        this.cleaner = cleaner;
        this.storageId = storageId;
    }

    public void close() {
    }

    public ValueData read(String propertyId, int orderNumber, int maxBufferSize) throws IOException {
        String s3fileName = this.getFile(propertyId, orderNumber);
        return S3ValueIOUtil.readValue(this.bucket, this.awsAccessKey, this.awsSecretAccessKey, s3fileName, orderNumber, maxBufferSize, this.s3SwapDirectory, this.cleaner);
    }

    public void delete(String propertyId) throws IOException {
        DeleteOperation o = new DeleteOperation(propertyId);
        o.execute();
        this.changes.add(o);
    }

    public void write(String propertyId, ValueData value) throws IOException {
        WriteOperation o = new WriteOperation(propertyId, value);
        o.execute();
        this.changes.add(o);
    }

    public void commit() throws IOException {
        for (ValueOperation vo : this.changes) {
            vo.commit();
        }
    }

    public void rollback() throws IOException {
        for (int p = this.changes.size() - 1; p >= 0; --p) {
            this.changes.get(p).rollback();
        }
    }

    protected abstract String getFile(String var1, int var2);

    protected abstract String[] getFiles(String var1);

    public String getStorageId() {
        return this.storageId;
    }

    class WriteOperation
    implements ValueOperation {
        private final String propertyId;
        private final ValueData value;

        WriteOperation(String propertyId, ValueData value) {
            this.propertyId = propertyId;
            this.value = value;
        }

        public void commit() throws IOException {
            String s3fileName = S3IOChannel.this.getFile(this.propertyId, this.value.getOrderNumber());
            S3ValueIOUtil.writeValue(S3IOChannel.this.bucket, S3IOChannel.this.awsAccessKey, S3IOChannel.this.awsSecretAccessKey, s3fileName, this.value);
        }

        public void rollback() throws IOException {
        }

        public void execute() throws IOException {
        }
    }

    class DeleteOperation
    implements ValueOperation {
        private final String propertyId;

        DeleteOperation(String propertyId) {
            this.propertyId = propertyId;
        }

        public void commit() throws IOException {
            String[] s3fileList;
            for (String s3fileName : s3fileList = S3IOChannel.this.getFiles(this.propertyId)) {
                if (S3ValueIOUtil.deleteValue(S3IOChannel.this.bucket, S3IOChannel.this.awsAccessKey, S3IOChannel.this.awsSecretAccessKey, s3fileName)) continue;
                log.warn((Object)("!!! Can't delete file " + s3fileName + "on Amazon S3 storage (Bucket: " + S3IOChannel.this.bucket + "). File added in FileCleaner list"));
                S3IOChannel.this.cleaner.addFile((File)new S3File(S3IOChannel.this.bucket, S3IOChannel.this.awsAccessKey, S3IOChannel.this.awsSecretAccessKey, s3fileName));
            }
        }

        public void rollback() throws IOException {
        }

        public void execute() throws IOException {
        }
    }
}

