/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.server.auth.Client;
import org.exoplatform.services.cifs.server.auth.NTLMv1;
import org.exoplatform.services.cifs.server.auth.NTLanManAuthContext;
import org.exoplatform.services.cifs.server.core.ShareType;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.filesys.DiskInfo;
import org.exoplatform.services.cifs.server.filesys.FileAccess;
import org.exoplatform.services.cifs.server.filesys.FileAction;
import org.exoplatform.services.cifs.server.filesys.FileExistsException;
import org.exoplatform.services.cifs.server.filesys.FileInfo;
import org.exoplatform.services.cifs.server.filesys.FileOpenParams;
import org.exoplatform.services.cifs.server.filesys.JCRDriver;
import org.exoplatform.services.cifs.server.filesys.JCRNetworkFile;
import org.exoplatform.services.cifs.server.filesys.NameCoder;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.SearchContext;
import org.exoplatform.services.cifs.server.filesys.TooManyConnectionsException;
import org.exoplatform.services.cifs.server.filesys.TooManyFilesException;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.server.filesys.UnsupportedInfoLevelException;
import org.exoplatform.services.cifs.server.filesys.VolumeInfo;
import org.exoplatform.services.cifs.smb.InvalidUNCPathException;
import org.exoplatform.services.cifs.smb.NTIOCtl;
import org.exoplatform.services.cifs.smb.NTTime;
import org.exoplatform.services.cifs.smb.PCShare;
import org.exoplatform.services.cifs.smb.SMBDate;
import org.exoplatform.services.cifs.smb.SMBException;
import org.exoplatform.services.cifs.smb.server.CoreProtocolHandler;
import org.exoplatform.services.cifs.smb.server.DiskInfoPacker;
import org.exoplatform.services.cifs.smb.server.FindInfoPacker;
import org.exoplatform.services.cifs.smb.server.IOControlHandler;
import org.exoplatform.services.cifs.smb.server.IOControlNotImplementedException;
import org.exoplatform.services.cifs.smb.server.IPCHandler;
import org.exoplatform.services.cifs.smb.server.NTParameterPacker;
import org.exoplatform.services.cifs.smb.server.NTTransPacket;
import org.exoplatform.services.cifs.smb.server.QueryInfoPacker;
import org.exoplatform.services.cifs.smb.server.SMBServer;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.SMBSrvTransPacket;
import org.exoplatform.services.cifs.smb.server.SrvTransactBuffer;
import org.exoplatform.services.cifs.smb.server.VirtualCircuit;
import org.exoplatform.services.cifs.util.DataBuffer;
import org.exoplatform.services.cifs.util.DataPacker;
import org.exoplatform.services.cifs.util.HexDump;
import org.exoplatform.services.cifs.util.WildCard;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.User;

public class NTProtocolHandler
extends CoreProtocolHandler {
    private static Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.server.NTProtocolHandler");
    public static final boolean ReturnDotFiles = true;
    public static final boolean FakeOpLocks = false;
    public static final int FileSizeChangeRate = 10;
    private static byte[] _sdEveryOne = new byte[]{1, 0, 4, -128, 20, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 28, 0, 1, 0, 0, 0, 0, 0, 20, 0, -1, 1, 31, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    protected NTProtocolHandler() {
    }

    protected NTProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "NT";
    }

    public boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_smbPkt == null) {
            this.m_smbPkt = this.m_sess.getReceivePacket();
        }
        if (!this.m_smbPkt.checkPacketSignature()) {
            throw new IOException("Invalid SMB signature");
        }
        SMBSrvPacket outPkt = this.m_smbPkt;
        boolean chainedCmd = this.hasChainedCommand(this.m_smbPkt);
        if (chainedCmd) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(2)) {
                logger.debug((Object)("AndX Command = 0x" + Integer.toHexString(this.m_smbPkt.getAndXCommand())));
            }
            outPkt = new SMBSrvPacket(this.m_smbPkt, this.m_smbPkt.getPacketLength());
        }
        this.m_smbPkt.resetBytePointer();
        this.m_sess.setProcessId(this.m_smbPkt.getProcessId());
        boolean handledOK = true;
        switch (this.m_smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(outPkt);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(outPkt);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(outPkt);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(outPkt);
                break;
            }
            case 52: {
                this.procFindClose(outPkt);
                break;
            }
            case 45: {
                this.procOpenAndX(outPkt);
                break;
            }
            case 4: {
                this.procCloseFile(outPkt);
                break;
            }
            case 46: {
                this.procReadAndX(outPkt);
                break;
            }
            case 47: {
                this.procWriteAndX(outPkt);
                break;
            }
            case 7: {
                this.procRenameFile(outPkt);
                break;
            }
            case 6: {
                this.procDeleteFile(outPkt);
                break;
            }
            case 1: {
                this.procDeleteDirectory(outPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(outPkt);
                break;
            }
            case 36: {
                this.procLockingAndX(outPkt);
                break;
            }
            case 116: {
                this.procLogoffAndX(outPkt);
                break;
            }
            case 162: {
                this.procNTCreateAndX(outPkt);
                break;
            }
            case 112: {
                super.runProtocol();
                break;
            }
            case 164: {
                this.procNTCancel(outPkt);
                break;
            }
            case 160: {
                this.procNTTransaction(outPkt);
                break;
            }
            case 161: {
                this.procNTTransactionSecondary(outPkt);
                break;
            }
            case 43: {
                super.procEcho(outPkt);
                break;
            }
            default: {
                TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
                if (conn == null) break;
                if (conn.getSharedDevice().getType() == 0 || conn.getSharedDevice().getType() == 1) {
                    handledOK = super.runProtocol();
                    break;
                }
                if (conn.getSharedDevice().getType() != 3) break;
                IPCHandler.processIPCRequest(this.m_sess, outPkt);
                handledOK = true;
            }
        }
        return handledOK;
    }

    protected void procSessionSetup(SMBSrvPacket outPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        logger.debug((Object)":procSessionSetup");
        if (!this.m_smbPkt.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        int maxBufSize = this.m_smbPkt.getParameter(2);
        int maxMpx = this.m_smbPkt.getParameter(3);
        int vcNum = this.m_smbPkt.getParameter(4);
        int ascPwdLen = this.m_smbPkt.getParameter(7);
        int uniPwdLen = this.m_smbPkt.getParameter(8);
        int capabs = this.m_smbPkt.getParameterLong(11);
        byte[] buf = this.m_smbPkt.getBuffer();
        boolean isUni = this.m_smbPkt.isUnicode();
        byte[] ascPwd = this.m_smbPkt.unpackBytes(ascPwdLen);
        byte[] uniPwd = this.m_smbPkt.unpackBytes(uniPwdLen);
        String user = this.m_smbPkt.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String domain = "";
        if (this.m_smbPkt.hasMoreData() && (domain = this.m_smbPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (this.m_smbPkt.hasMoreData() && (clientOS = this.m_smbPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
            logger.debug((Object)("NT Session setup from user=" + user + ", UNIpassword=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + this.m_sess.getAuthenticationContext()));
            logger.debug((Object)("  MID=" + this.m_smbPkt.getMultiplexId() + ", UID=" + this.m_smbPkt.getUserId() + ", PID=" + this.m_smbPkt.getProcessId()));
        }
        boolean authenticated = false;
        Client client = null;
        try {
            if (user.length() == 0 && uniPwdLen == 0 && ascPwdLen <= 1) {
                client = new Client("", "");
                client.setLogonType(2);
                authenticated = true;
            } else if (user.equals("__anonim")) {
                authenticated = ((SMBServer)this.getSession().getServer()).getOrgainzationService().getUserHandler().authenticate(user, null);
                client = new Client(user, "");
                client.setGuest(false);
            } else if (ascPwd == null) {
                String plainpassword = uniPwd != null ? this.unpackUnicode(uniPwd, 0, uniPwdLen + 1) : "";
                authenticated = ((SMBServer)this.getSession().getServer()).getOrgainzationService().getUserHandler().authenticate(user, plainpassword);
                client = new Client(user, plainpassword);
                client.setGuest(false);
            } else {
                User ushnd = ((SMBServer)this.getSession().getServer()).getOrgainzationService().getUserHandler().findUserByName(user);
                logger.debug((Object)("user " + (ushnd != null ? ushnd.getUserName() : "null")));
                if (ushnd != null) {
                    String pass = ushnd.getPassword();
                    if (pass != null) {
                        NTLMv1 enc = new NTLMv1();
                        NTLanManAuthContext cont = (NTLanManAuthContext)this.m_sess.getAuthenticationContext();
                        byte[] encPwd = enc.computeMD4Hash(pass, cont.getChallenge());
                        authenticated = Arrays.equals(encPwd, uniPwd);
                    }
                    client = new Client(user, pass);
                    client.setGuest(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(-1073741715, 5, 1);
            return;
        }
        if (!authenticated) {
            this.m_sess.sendErrorResponseSMB(-1073741715, 5, 1);
            return;
        }
        logger.debug((Object)("User [" + client.getUsername() + "] pass[" + client.getPassword() + "] authenticated"));
        this.m_sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        this.m_sess.setClientMaximumMultiplex(maxMpx);
        this.m_sess.setClientCapabilities(capabs);
        VirtualCircuit vc = new VirtualCircuit(vcNum, client);
        int uid = this.m_sess.addVirtualCircuit(vc);
        if (uid == -1) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
                logger.debug((Object)("Failed to allocate UID for virtual circuit, " + vc));
            }
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
            logger.debug((Object)("Allocated UID=" + uid + " for VC=" + vc));
        }
        this.m_sess.setLoggedOn(true);
        outPkt.setParameterCount(3);
        outPkt.setParameter(0, 0);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, client.isGuest() ? 1 : 0);
        outPkt.setByteCount(0);
        outPkt.setTreeId(0);
        outPkt.setUserId(uid);
        int flags = outPkt.getFlags();
        outPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        outPkt.setFlags2(flags2);
        int pos = outPkt.getByteOffset();
        buf = outPkt.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("CIFS Server " + this.m_sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(this.m_sess.getServer().getConfiguration().getDomainName(), buf, pos, true, isUni);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        pos = outPkt.getLength();
        if (this.m_smbPkt.hasAndXCommand() && this.m_smbPkt.getPosition() < this.m_smbPkt.getReceivedLength()) {
            pos = this.procAndXCommands(outPkt);
            pos -= 4;
        } else {
            outPkt.setAndXCommand(255);
        }
        this.m_sess.sendResponseSMB(outPkt, pos);
        if (outPkt.getLongErrorCode() == 0) {
            this.m_sess.setState(3);
            this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
        }
    }

    protected final int procAndXCommands(SMBSrvPacket outPkt) {
        return this.procAndXCommands(outPkt, outPkt.getByteOffset() + outPkt.getByteCount(), null);
    }

    protected final int procAndXCommands(SMBSrvPacket outPkt, int endPos, NetworkFile file) {
        int andxCmd = this.m_smbPkt.getAndXCommand();
        int andxOff = this.m_smbPkt.getParameter(1) + 4;
        outPkt.setAndXCommand(andxCmd);
        outPkt.setParameter(1, andxOff - 4);
        int paramBlk = 36;
        int endOfPkt = endPos;
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            boolean endOfChain = false;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, outPkt, endOfPkt);
                    break;
                }
                case 4: {
                    endOfPkt = this.procChainedClose(andxOff, outPkt, endOfPkt);
                    endOfChain = true;
                    break;
                }
                case 46: {
                    endOfPkt = this.procChainedReadAndX(andxOff, outPkt, endOfPkt, file);
                    break;
                }
            }
            outPkt.setAndXCommand(paramBlk, andxCmd);
            outPkt.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            if (!endOfChain) {
                andxCmd = this.m_smbPkt.getAndXParameter(andxOff, 0) & 0xFF;
                andxOff = this.m_smbPkt.getAndXParameter(andxOff, 1);
                paramBlk = prevEndOfPkt;
            } else {
                andxCmd = 255;
            }
            if (outPkt.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket outPkt, int endOff) {
        boolean unicode;
        String uncPath;
        logger.debug((Object)":procChainedTreeConnectAndX");
        int pwdLen = this.m_smbPkt.getAndXParameter(cmdOff, 3);
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(outPkt.getUserId());
        if (vc == null) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        this.m_smbPkt.setBytePointer(this.m_smbPkt.getAndXByteOffset(cmdOff), this.m_smbPkt.getAndXByteCount(cmdOff));
        String pwd = null;
        if (pwdLen > 0) {
            byte[] pwdByt = this.m_smbPkt.unpackBytes(pwdLen);
            pwd = new String(pwdByt);
        }
        if ((uncPath = this.m_smbPkt.unpackString(unicode = this.m_smbPkt.isUnicode())) == null) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        String service = this.m_smbPkt.unpackString(false);
        if (service == null) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("NT ANDX Tree Connect AndX - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        if (vc.getClientInfo() != null && vc.getClientInfo().isNullSession() && servType != 3) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741790, 5, 1);
            return endOff;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getShareName(), servType, this.m_sess);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in TreeConnectAndX", (Throwable)ex);
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741620, 6, 2);
            return endOff;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741620, 6, 2);
            return endOff;
        }
        int sharePerm = 2;
        try {
            int treeId = vc.addTreeConnection(shareDev);
            outPkt.setTreeId(treeId);
            TreeConnection tree = vc.findTreeConnection(treeId);
            SessionImpl s = null;
            if (shareDev.getType() == 0) {
                CredentialsImpl credentials = new CredentialsImpl(vc.getClientInfo().getUsername(), vc.getClientInfo().getPassword().toCharArray());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Create JCR-session: login admin");
                    }
                    s = (SessionImpl)this.m_sess.getSMBServer().getRepository().login((Credentials)credentials, shareDev.getName());
                    sharePerm = 0;
                    try {
                        s.checkPermission("/", "read");
                        sharePerm = 1;
                        logger.debug((Object)"share permission - read");
                    }
                    catch (AccessControlException e) {
                        // empty catch block
                    }
                    try {
                        s.checkPermission("/", "add_node");
                        s.checkPermission("/", "set_property");
                        sharePerm = 2;
                        logger.debug((Object)"share permission - writable");
                    }
                    catch (AccessControlException e) {}
                }
                catch (LoginException e) {
                    outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741715, 5, 1);
                    return endOff;
                }
                catch (NoSuchWorkspaceException e) {
                    outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741620, 6, 2);
                    return endOff;
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                    outPkt.setError(65, 2);
                    return endOff;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    outPkt.setError(65, 2);
                    return endOff;
                }
            }
            tree.setPermission(sharePerm);
            tree.setSession((Session)s);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + FileAccess.asString(sharePerm)));
            }
        }
        catch (TooManyConnectionsException ex) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741537, 89, 2);
            return endOff;
        }
        outPkt.setAndXParameterCount(endOff, 2);
        outPkt.setAndXParameter(endOff, 0, 255);
        outPkt.setAndXParameter(endOff, 1, 0);
        int pos = outPkt.getAndXByteOffset(endOff);
        byte[] outBuf = outPkt.getBuffer();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), outBuf, pos, true);
        String devType = "FAT";
        pos = DataPacker.putString(devType, outBuf, pos, true, outPkt.isUnicode());
        int bytLen = pos - outPkt.getAndXByteOffset(endOff);
        outPkt.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    protected final int procChainedReadAndX(int cmdOff, SMBSrvPacket outPkt, int endOff, NetworkFile netFile) {
        logger.debug((Object)":procChainedReadAndX");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            outPkt.setError(15, 1);
            return endOff;
        }
        long offset = this.m_smbPkt.getAndXParameterLong(cmdOff, 3);
        offset &= 0xFFFFFFFFL;
        int maxCount = this.m_smbPkt.getAndXParameter(cmdOff, 5);
        if (this.m_smbPkt.getAndXParameterCount(cmdOff) == 12) {
            long topOff = this.m_smbPkt.getAndXParameterLong(cmdOff, 10);
            offset += topOff << 32;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Chained File Read AndX : Size=" + maxCount + " ,Pos=" + offset));
        }
        byte[] buf = outPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            outPkt.setAndXParameterCount(endOff, 12);
            dataPos = outPkt.getAndXByteOffset(endOff);
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = ((JCRNetworkFile)netFile).read(buf, dataPos, maxCount, offset);
            outPkt.setAndXParameter(endOff, 0, 255);
            outPkt.setAndXParameter(endOff, 1, 0);
            outPkt.setAndXParameter(endOff, 2, 0);
            outPkt.setAndXParameter(endOff, 3, 0);
            outPkt.setAndXParameter(endOff, 4, 0);
            outPkt.setAndXParameter(endOff, 5, rdlen);
            outPkt.setAndXParameter(endOff, 6, dataPos - 4);
            for (int i = 7; i < 12; ++i) {
                outPkt.setAndXParameter(endOff, i, 0);
            }
            outPkt.setAndXByteCount(endOff, dataPos + rdlen - outPkt.getAndXByteOffset(endOff));
            endOff = dataPos + rdlen;
        }
        catch (RepositoryException ex) {
            outPkt.setError(13, 1);
            return endOff;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return endOff;
    }

    protected final int procChainedClose(int cmdOff, SMBSrvPacket outPkt, int endOff) {
        logger.debug((Object)":procChainedClose");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            outPkt.setError(15, 1);
            return endOff;
        }
        int fid = this.m_smbPkt.getAndXParameter(cmdOff, 0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            outPkt.setError(15, 1);
            return endOff;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Chained File Close [" + this.m_smbPkt.getTreeId() + "] fid=" + fid));
        }
        try {
            if (netFile.hasDeleteOnClose()) {
                if (netFile instanceof JCRNetworkFile) {
                    Node parent = ((JCRNetworkFile)netFile).getNodeRef().getParent();
                    ((JCRNetworkFile)netFile).getNodeRef().remove();
                    parent.save();
                    ((JCRNetworkFile)netFile).releaseResources();
                    logger.debug((Object)("file [" + netFile.getName() + "] deleted"));
                }
            } else if (netFile instanceof JCRNetworkFile) {
                ((JCRNetworkFile)netFile).saveChanges();
                logger.debug((Object)("file [" + netFile.getName() + "] save changes"));
            }
        }
        catch (LockException e) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741790, 5, 1);
            return endOff;
        }
        catch (AccessDeniedException e) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741790, 5, 1);
            return endOff;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            outPkt.setError(13, 1);
            return endOff;
        }
        netFile.setClosed(true);
        outPkt.setAndXParameterCount(endOff, 0);
        outPkt.setAndXByteCount(endOff, 0);
        endOff = outPkt.getAndXByteOffset(endOff) - 4;
        conn.removeFile(fid, this.getSession());
        return endOff;
    }

    protected void procTreeConnectAndX(SMBSrvPacket outPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        String uncPath;
        logger.debug((Object)"procTreeConnectAndX");
        if (!this.m_smbPkt.checkPacketIsValid(4, 3)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int pwdLen = this.m_smbPkt.getParameter(3);
        this.m_smbPkt.resetBytePointer();
        boolean unicode = this.m_smbPkt.isUnicode();
        String pwd = null;
        if (pwdLen > 0) {
            byte[] pwdByts = this.m_smbPkt.unpackBytes(pwdLen);
            pwd = new String(pwdByts);
        }
        if ((uncPath = this.m_smbPkt.unpackString(unicode)) == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        String service = this.m_smbPkt.unpackString(false);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("NT Tree Connect AndX - " + uncPath + ", " + service));
        }
        String shareName = null;
        if (uncPath.startsWith("\\")) {
            try {
                PCShare share = new PCShare(uncPath);
                shareName = share.getShareName();
            }
            catch (InvalidUNCPathException ex) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
        } else {
            shareName = uncPath;
        }
        if (shareName.compareTo("IPC$") == 0) {
            servType = 3;
        }
        if (vc.getClientInfo() != null && vc.getClientInfo().isNullSession() && servType != 3) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(shareName, servType, this.m_sess);
        }
        catch (Exception ex) {
            logger.error((Object)("TreeConnectAndX error [" + ex.getMessage() + "] share [" + shareName + "] not finded"));
            this.m_sess.sendErrorResponseSMB(-1073741620, 6, 2);
            return;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(-1073741620, 6, 2);
            return;
        }
        int sharePerm = 2;
        try {
            int treeId = vc.addTreeConnection(shareDev);
            outPkt.setTreeId(treeId);
            TreeConnection tree = vc.findTreeConnection(treeId);
            SessionImpl s = null;
            if (shareDev.getType() == 0) {
                CredentialsImpl credentials = new CredentialsImpl(vc.getClientInfo().getUsername(), vc.getClientInfo().getPassword().toCharArray());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Create JCR-session: login admin");
                    }
                    s = (SessionImpl)this.m_sess.getSMBServer().getRepository().login((Credentials)credentials, shareDev.getName());
                    sharePerm = 0;
                    try {
                        s.checkPermission("/", "read");
                        sharePerm = 1;
                        logger.debug((Object)"share permission - read");
                    }
                    catch (AccessControlException e) {
                        // empty catch block
                    }
                    try {
                        s.checkPermission("/", "add_node");
                        s.checkPermission("/", "set_property");
                        sharePerm = 2;
                        logger.debug((Object)"share permission - writable");
                    }
                    catch (AccessControlException e) {}
                }
                catch (LoginException e) {
                    this.m_sess.sendErrorResponseSMB(-1073741715, 5, 1);
                    return;
                }
                catch (NoSuchWorkspaceException e) {
                    this.m_sess.sendErrorResponseSMB(-1073741620, 6, 2);
                    return;
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                    this.m_sess.sendErrorResponseSMB(65, 2);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_sess.sendErrorResponseSMB(65, 2);
                    return;
                }
            }
            tree.setSession((Session)s);
            tree.setPermission(sharePerm);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + FileAccess.asString(sharePerm)));
            }
        }
        catch (TooManyConnectionsException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741537, 89, 2);
            return;
        }
        outPkt.setParameterCount(3);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        int pos = outPkt.getByteOffset();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), this.m_smbPkt.getBuffer(), pos, true);
        String devType = "FAT";
        pos = DataPacker.putString(devType, this.m_smbPkt.getBuffer(), pos, true, outPkt.isUnicode());
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCloseFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procCloseFile");
        if (!this.m_smbPkt.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File close [" + this.m_smbPkt.getTreeId() + "] fid=" + fid));
        }
        try {
            if (netFile.hasDeleteOnClose()) {
                if (netFile instanceof JCRNetworkFile) {
                    Node parent = ((JCRNetworkFile)netFile).getNodeRef().getParent();
                    ((JCRNetworkFile)netFile).getNodeRef().remove();
                    parent.save();
                    ((JCRNetworkFile)netFile).releaseResources();
                    logger.debug((Object)("file [" + netFile.getName() + "] deleted"));
                }
            } else if (netFile instanceof JCRNetworkFile) {
                ((JCRNetworkFile)netFile).saveChanges();
                logger.debug((Object)("file [" + netFile.getName() + "] save changes"));
            }
        }
        catch (LockException e) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        netFile.setClosed(true);
        conn.removeFile(fid, this.getSession());
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procTransact2(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"procTransact2");
        if (!this.m_smbPkt.checkPacketIsValid(14, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getRxParameterBlockLength() && tranPkt.getTotalDataCount() == tranPkt.getRxDataBlockLength()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(tranPkt.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getRxParameterBlock(), tranPkt.getRxParameterBlockLength());
            transBuf.appendData(buf, tranPkt.getRxDataBlock(), tranPkt.getRxDataBlockLength());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        if (transBuf.isMultiPacket()) {
            this.m_sess.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.procTransaction(vc, transBuf, this.m_sess, outPkt);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction [" + this.m_smbPkt.getTreeId() + "] tbuf=" + transBuf));
        }
        this.processTransactionBuffer(transBuf, outPkt);
    }

    protected void procTransact2Secondary(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int dlen;
        logger.debug((Object)"procTransact2Secondary");
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        if (!this.m_sess.hasTransaction() || this.m_sess.getTransaction().isType() == 37 && this.m_smbPkt.getCommand() != 38 || this.m_sess.getTransaction().isType() == 50 && this.m_smbPkt.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = this.m_sess.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction Secondary [" + this.m_smbPkt.getTreeId() + "] paramLen=" + plen + ", dataLen=" + dlen));
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)"Transaction complete, processing ...");
            }
            this.m_sess.setTransaction(null);
            if (conn.getSharedDevice().getType() == 3) {
                IPCHandler.procTransaction(vc, transBuf, this.m_sess, outPkt);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("Transaction second [" + this.m_smbPkt.getTreeId() + "] tbuf=" + transBuf));
            }
            this.processTransactionBuffer(transBuf, outPkt);
        } else {
            this.m_sess.sendSuccessResponseSMB();
        }
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"processTransactionBuffer");
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, outPkt);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, outPkt);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, outPkt);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, outPkt);
                break;
            }
            case 7: {
                this.procTrans2QueryFile(tbuf, outPkt);
                break;
            }
            case 8: {
                this.procTrans2SetFile(tbuf, outPkt);
                break;
            }
            case 6: {
                this.procTrans2SetPath(tbuf, outPkt);
                break;
            }
            default: {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            }
        }
    }

    protected final void procFindClose(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"procFindClose");
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int searchId = this.m_smbPkt.getParameter(0);
        SearchContext ctx = vc.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
            logger.debug((Object)("Close trans search [" + searchId + "]"));
        }
        vc.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB();
    }

    protected final void procLockingAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"procLockingAndX");
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int lockType = this.m_smbPkt.getParameter(3);
        long lockTmo = this.m_smbPkt.getParameterLong(4);
        int unlockCnt = this.m_smbPkt.getParameter(6);
        int lockCnt = this.m_smbPkt.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
            logger.debug((Object)("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt));
        }
        this.m_smbPkt.resetBytePointer();
        if (unlockCnt > 0) {
            logger.debug((Object)" HERE MUST BE UNLOCK ");
        } else {
            logger.debug((Object)" HERE MUST BE LOCK ");
        }
        outPkt.setParameterCount(2);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procLogoffAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procLogoffAndX");
        if (!this.m_smbPkt.checkPacketIsValid(2, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int uid = this.m_smbPkt.getUserId();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(uid);
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
            logger.debug((Object)("Logoff vc=" + vc));
        }
        this.m_sess.removeVirtualCircuit(uid);
        this.m_sess.sendSuccessResponseSMB();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procOpenAndX");
        if (!this.m_smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int access = this.m_smbPkt.getParameter(3);
        int srchAttr = this.m_smbPkt.getParameter(4);
        int fileAttr = this.m_smbPkt.getParameter(5);
        int crTime = this.m_smbPkt.getParameter(6);
        int crDate = this.m_smbPkt.getParameter(7);
        int openFunc = this.m_smbPkt.getParameter(8);
        int allocSiz = this.m_smbPkt.getParameterLong(9);
        String fileName = this.m_smbPkt.unpackString(this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (fileName.equals("")) {
            fileName = "/";
        } else {
            StringBuffer path = new StringBuffer(fileName);
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '\\') continue;
                path.setCharAt(i, '/');
            }
            fileName = path.toString();
        }
        String temp = fileName;
        String stream = null;
        int pos = temp.indexOf(":");
        if (pos == -1) {
            fileName = NameCoder.DecodeName(temp);
        } else {
            fileName = NameCoder.DecodeName(temp.substring(0, pos));
            stream = temp.substring(pos);
        }
        long crDateTime = 0L;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime).getTime();
        }
        FileOpenParams params = new FileOpenParams(fileName, stream, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Open AndX [" + this.m_smbPkt.getTreeId() + "] params=" + params));
        }
        int responseAction = 0;
        int fid = -1;
        NetworkFile file = null;
        try {
            boolean isExist = conn.getSession().itemExists(fileName);
            logger.debug((Object)("isExist " + isExist + "TEMPORARY"));
            if (!isExist) {
                if (!FileAction.createNotExists(openFunc)) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                    return;
                }
                if (!conn.hasWriteAccess()) {
                    this.m_sess.sendErrorResponseSMB(5, 1);
                    return;
                }
                logger.debug((Object)"trying to create file TEMPLATE");
                file = JCRDriver.createFile(conn, params);
                responseAction = 2;
            } else {
                if (!FileAction.openIfExists(openFunc) && !FileAction.truncateExistingFile(openFunc)) {
                    this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                    return;
                }
                file = JCRDriver.openFile(conn, params);
                responseAction = FileAction.truncateExistingFile(openFunc) ? 3 : 1;
            }
            if (file != null) {
                fid = conn.addFile(file, this.getSession());
            }
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (LockException e) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741537, 4, 1);
            return;
        }
        catch (Exception e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        logger.debug((Object)("resp Action " + FileAction.asString(responseAction) + ", fid = " + fid + " TEMPORARY"));
        outPkt.setParameterCount(15);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, fid);
        int attr = file != null ? file.getFileAttributes() : 0;
        outPkt.setParameter(3, attr);
        SMBDate modDate = null;
        modDate = file != null ? new SMBDate(file.getModifyDate()) : null;
        outPkt.setParameter(4, modDate != null ? modDate.asSMBTime() : 0);
        outPkt.setParameter(5, modDate != null ? modDate.asSMBDate() : 0);
        int size = file != null ? file.getFileSizeInt() : 0;
        outPkt.setParameterLong(6, size);
        int acc = file != null ? file.getGrantedAccess() : 0;
        outPkt.setParameter(8, acc);
        outPkt.setParameter(9, 0);
        outPkt.setParameter(10, 0);
        outPkt.setParameter(11, responseAction);
        outPkt.setParameter(12, 0);
        outPkt.setParameter(13, 0);
        outPkt.setParameter(14, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procReadAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        logger.debug((Object)":procReadAndX");
        if (!this.m_smbPkt.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        long offset = this.m_smbPkt.getParameterLong(3);
        offset &= 0xFFFFFFFFL;
        int maxCount = this.m_smbPkt.getParameter(5);
        if (this.m_smbPkt.getParameterCount() == 12) {
            long topOff = this.m_smbPkt.getParameterLong(10);
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset));
        }
        byte[] buf = outPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            outPkt.setParameterCount(12);
            dataPos = outPkt.getByteOffset();
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = ((JCRNetworkFile)netFile).read(buf, dataPos, maxCount, offset);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, rdlen);
        outPkt.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            outPkt.setParameter(i, 0);
        }
        outPkt.setByteCount(dataPos + rdlen - outPkt.getByteOffset());
        if (this.m_smbPkt.hasAndXCommand()) {
            int pos = this.procAndXCommands(outPkt, outPkt.getPacketLength(), netFile);
            this.m_sess.sendResponseSMB(outPkt, pos);
        } else {
            this.m_sess.sendResponseSMB(outPkt);
        }
    }

    protected void procRenameFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procRenameFile");
        if (!this.m_smbPkt.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String oldName = this.m_smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String newName = this.m_smbPkt.unpackString(isUni);
        if (newName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Rename [" + this.m_smbPkt.getTreeId() + "] old name=" + oldName + ", new name=" + newName));
        }
        if (!this.isValidPath(oldName)) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 13, 1);
            return;
        }
        if (oldName.equals("")) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(oldName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        oldName = path.toString();
        String temp = oldName;
        if (temp.indexOf(":") != -1) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 13, 1);
            return;
        }
        oldName = NameCoder.DecodeName(temp);
        if (!this.isValidPath(newName)) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 13, 1);
            return;
        }
        if (newName.equals("")) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        StringBuffer path2 = new StringBuffer(newName);
        for (int i = 0; i < path2.length(); ++i) {
            if (path2.charAt(i) != '\\') continue;
            path2.setCharAt(i, '/');
        }
        newName = path2.toString();
        temp = newName;
        if (temp.indexOf(":") != -1) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 13, 1);
            return;
        }
        newName = NameCoder.DecodeName(temp);
        try {
            if (!conn.getSession().itemExists(oldName)) {
                this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                return;
            }
            conn.getSession().move(oldName, newName);
            conn.getSession().save();
        }
        catch (ItemExistsException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procDeleteFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        block15: {
            int i;
            logger.debug((Object)":procDeleteFile");
            if (!this.m_smbPkt.checkPacketIsValid(1, 2)) {
                this.m_sess.sendErrorResponseSMB(64, 2);
                return;
            }
            TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
            if (conn == null) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
                return;
            }
            if (!conn.hasWriteAccess()) {
                this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                return;
            }
            boolean isUni = this.m_smbPkt.isUnicode();
            this.m_smbPkt.resetBytePointer();
            if (this.m_smbPkt.unpackByte() != 4) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
            String fileName = this.m_smbPkt.unpackString(isUni);
            if (fileName == null) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
            if (fileName.equals("")) {
                this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                return;
            }
            StringBuffer path = new StringBuffer(fileName);
            for (i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '\\') continue;
                path.setCharAt(i, '/');
            }
            fileName = path.toString();
            String temp = fileName;
            if (temp.indexOf(":") != -1) {
                this.m_sess.sendErrorResponseSMB(-1073741773, 2, 1);
                return;
            }
            fileName = NameCoder.DecodeName(temp);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                logger.debug((Object)("File Delete [" + this.m_smbPkt.getTreeId() + "] name=" + fileName));
            }
            try {
                if (WildCard.containsWildcards(fileName)) {
                    i = fileName.lastIndexOf("/") + 1;
                    String wildcardname = fileName.substring(i);
                    String path2 = fileName.substring(0, i);
                    Node root = (Node)conn.getSession().getItem(path2);
                    NodeIterator it = root.getNodes(wildcardname);
                    int d = 0;
                    while (it.hasNext()) {
                        Node tempref = it.nextNode();
                        tempref.remove();
                        ++d;
                    }
                    conn.getSession().save();
                    logger.debug((Object)(d + " files deleted by [" + wildcardname + "] mask"));
                    break block15;
                }
                if (conn.getSession().itemExists(fileName)) {
                    ((Node)conn.getSession().getItem(fileName)).remove();
                    conn.getSession().save();
                    break block15;
                }
                this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                return;
            }
            catch (AccessDeniedException ex) {
                this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                return;
            }
            catch (RepositoryException ex) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procDeleteDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procDeleteDirectory");
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String dirName = this.m_smbPkt.unpackString(isUni);
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (dirName.equals("")) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(dirName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        dirName = path.toString();
        String temp = dirName;
        if (temp.indexOf(":") != -1) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 2, 1);
            return;
        }
        dirName = NameCoder.DecodeName(temp);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Delete [" + this.m_smbPkt.getTreeId() + "] name=" + dirName));
        }
        try {
            if (conn.getSession().itemExists(dirName)) {
                Node dirNode = (Node)conn.getSession().getItem(dirName);
                if (dirNode.isNodeType("nt:file")) {
                    this.m_sess.sendErrorResponseSMB(-1073741773, 2, 1);
                    return;
                }
                if (dirNode.getNodes().hasNext()) {
                    this.m_sess.sendErrorResponseSMB(145, 1);
                    return;
                }
                dirNode.remove();
                conn.getSession().save();
            } else {
                this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            }
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (LockException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741740, 33, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(3, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2FindFirst");
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        TreeConnection conn = vc.findTreeConnection(tbuf.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(4, 2);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        StringBuilder path = new StringBuilder(srchPath);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        srchPath = NameCoder.DecodeName(path.toString());
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (srchPath.endsWith("/")) {
            srchPath = srchPath + "*";
        }
        if (infoLevl == 770 && !this.getSession().hasMacintoshExtensions()) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 65535, 2);
            return;
        }
        SearchContext ctx = null;
        int searchId = -1;
        boolean wildcardSearch = false;
        try {
            searchId = vc.allocateSearchSlot();
            if (searchId == -1) {
                this.m_sess.sendErrorResponseSMB(89, 2);
                return;
            }
            if (WildCard.containsWildcards(srchPath) || WildCard.containsUnicodeWildcard(srchPath)) {
                wildcardSearch = true;
            }
            if (tbuf.isUnicode() && WildCard.containsUnicodeWildcard(srchPath)) {
                srchPath = WildCard.convertUnicodeWildcardToDOS(srchPath);
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Converted Unicode wildcards to:" + srchPath));
                }
            }
            if ((ctx = JCRDriver.startSearch(conn, srchPath, srchAttr)) == null) {
                this.m_sess.sendErrorResponseSMB(-1073741809, 2, 1);
                return;
            }
            ctx.setTreeId(this.m_smbPkt.getTreeId());
            ctx.setMaximumFiles(maxFiles);
            vc.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            if (wildcardSearch) {
                if (resumeIds) {
                    dataBuf.putInt(-1);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                FileInfo dotInfo = new FileInfo(".", 0L, 16);
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
                if (resumeIds) {
                    dataBuf.putInt(-2);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                dotInfo.setFileName("..");
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.rollbackAtOnePosition();
                pktDone = true;
            }
            if (!wildcardSearch && fileCnt == 0) {
                throw new FileNotFoundException(srchPath);
            }
            if (maxFiles == 1 && fileCnt == 1) {
                searchDone = true;
            }
            FindInfoPacker.clearNextOffset(dataBuf, infoLevl, lastNameOff);
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                vc.deallocateSearchSlot(searchId);
            } else if ((srchFlag & 1) != 0) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Close)"));
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741809, 18, 1);
        }
        catch (PathNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (RepositoryException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2FindNext");
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        TreeConnection conn = vc.findTreeConnection(tbuf.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        try {
            ctx = vc.getSearchContext(searchId);
            if (ctx == null) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Search context null - [" + searchId + "]"));
                }
                this.m_sess.sendErrorResponseSMB(18, 1);
                return;
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.rollbackAtOnePosition();
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                vc.deallocateSearchSlot(searchId);
            } else if ((srchFlag & 1) != 0) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Close)"));
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(18, 1);
        }
        catch (PathNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (RepositoryException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2QueryFileSys");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query File System Info - level = 0x" + Integer.toHexString(infoLevl)));
        }
        try {
            int prmPos;
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            DiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    replyBuf.putZeros(4);
                    replyBuf.putInt(32);
                    replyBuf.putInt(2560000);
                    replyBuf.putInt(2304000);
                    replyBuf.putShort(512);
                    break;
                }
                case 2: {
                    replyBuf.putZeros(4);
                    String label = conn.getSharedDevice().getName();
                    replyBuf.putByte(label.length());
                    replyBuf.putString(label, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    replyBuf.putZeros(8);
                    replyBuf.putZeros(4);
                    int len = conn.getSharedDevice().getName().length();
                    if (tbuf.isUnicode()) {
                        len *= 2;
                    }
                    replyBuf.putInt(len);
                    replyBuf.putZeros(2);
                    replyBuf.putString(conn.getSharedDevice().getName(), tbuf.isUnicode(), false);
                    break;
                }
                case 259: {
                    replyBuf.putLong(2560000L);
                    replyBuf.putLong(2304000L);
                    replyBuf.putInt(32);
                    replyBuf.putInt(512);
                    break;
                }
                case 260: {
                    replyBuf.putInt(7);
                    replyBuf.putInt(7);
                    break;
                }
                case 261: {
                    String fsType = "NTFS";
                    replyBuf.putInt(4);
                    replyBuf.putInt(255);
                    if (tbuf.isUnicode()) {
                        replyBuf.putInt(fsType.length() * 2);
                    } else {
                        replyBuf.putInt(fsType.length());
                    }
                    replyBuf.putString(fsType, tbuf.isUnicode(), false);
                    break;
                }
                case 769: {
                    boolean ntfs = false;
                    if (ntfs) break;
                    DiskInfoPacker.packMacFsInformation(diskInfo, volInfo, ntfs, replyBuf);
                    replyBuf.putZeros(24);
                    replyBuf.putInt(2560000);
                    replyBuf.putInt(16384);
                    replyBuf.putInt(2304000);
                    replyBuf.putZeros(32);
                    replyBuf.putInt(0);
                    replyBuf.putInt(0);
                    replyBuf.putInt(0);
                    replyBuf.putInt(0);
                    DataPacker.putIntelInt(ntfs ? 0 : 256, replyBuf.getBuffer(), replyBuf.getPosition());
                    replyBuf.setPosition(replyBuf.getPosition() + 4);
                    break;
                }
                case 1007: {
                    long userLimit = diskInfo.getTotalUnits();
                    replyBuf.putLong(2560000L);
                    replyBuf.putLong(2560000L);
                    replyBuf.putLong(2304000L);
                    replyBuf.putInt(32);
                    replyBuf.putInt(512);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(65535, 2);
                return;
            }
            int bytCnt = replyBuf.getPosition() - outPkt.getByteOffset();
            replyBuf.setEndOfBuffer();
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(outPkt, 0, prmPos, dataLen, dataPos);
            outPkt.setByteCount(bytCnt);
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2QueryPath");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path));
        }
        if (!this.isValidPath(path)) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 13, 1);
            return;
        }
        if (path.indexOf(":") != -1) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        if (path.equals("")) {
            path = "/";
        } else {
            StringBuffer pathBuf = new StringBuffer(path);
            for (int i = 0; i < path.length(); ++i) {
                if (pathBuf.charAt(i) != '\\') continue;
                pathBuf.setCharAt(i, '/');
            }
            path = NameCoder.DecodeName(pathBuf.toString());
        }
        logger.debug((Object)("after encoding : [" + path + "]"));
        try {
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            int dataPos = prmPos + 4;
            outPkt.setPosition(prmPos);
            outPkt.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            int dataLen = 0;
            FileInfo fileInfo = null;
            Session sess = conn.getSession();
            if (!sess.itemExists(path)) {
                this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                return;
            }
            fileInfo = JCRDriver.getFileInformation((Node)conn.getSession().getItem(path));
            dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2QueryFile(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2QueryFile");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", stream=" + netFile.getStreamId() + ", name=" + netFile.getFullName()));
        }
        try {
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            int dataPos = prmPos + 4;
            outPkt.setPosition(prmPos);
            outPkt.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            int dataLen = 0;
            FileInfo fileInfo = null;
            if (!(netFile instanceof JCRNetworkFile)) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
            fileInfo = JCRDriver.getFileInformation(((JCRNetworkFile)netFile).getNodeRef());
            if (fileInfo == null) {
                this.m_sess.sendErrorResponseSMB(-1073741772, 1, 2);
                return;
            }
            dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(-1073741766, 2, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2SetFile(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2SetFile");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Set File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", name=" + netFile.getFullName()));
        }
        try {
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            switch (infoLevl) {
                case 257: {
                    int setFlags = 0;
                    finfo = new FileInfo(netFile.getFullName(), 0L, -1);
                    long timeNow = System.currentTimeMillis();
                    long nttim = dataBuf.getLong();
                    boolean hasSetTime = false;
                    if (nttim != 0L) {
                        if (nttim != -1L) {
                            finfo.setCreationDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 16;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) != 0L) {
                        if (nttim != -1L) {
                            finfo.setAccessDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 32;
                        } else {
                            finfo.setAccessDateTime(timeNow);
                            setFlags += 32;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setModifyDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 8;
                        } else {
                            finfo.setModifyDateTime(timeNow);
                            setFlags += 8;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setChangeDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 64;
                        }
                        hasSetTime = true;
                    }
                    int attr = dataBuf.getInt();
                    int unknown = dataBuf.getInt();
                    if (!hasSetTime && unknown == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    JCRDriver.setFileInformation(this.m_sess, conn, netFile.getFullName(), finfo);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set Basic Info [" + this.m_smbPkt.getTreeId() + "] name=" + netFile.getFullName() + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", unknown=" + unknown));
                    break;
                }
                case 260: {
                    long eofPos = dataBuf.getLong();
                    if (netFile.isDirectory()) {
                        throw new AccessDeniedException();
                    }
                    try {
                        ((JCRNetworkFile)netFile).truncateFile(eofPos);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set end of file position fid=" + fid + ", eof=" + eofPos));
                    break;
                }
                case 259: {
                    long allocSize = dataBuf.getLong();
                    if (netFile.isDirectory()) {
                        throw new AccessDeniedException();
                    }
                    ((JCRNetworkFile)netFile).truncateFile(allocSize);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set allocation size fid=" + fid + ", allocSize=" + allocSize));
                    break;
                }
                case 1010: {
                    boolean streams = false;
                    if (streams) break;
                    this.m_sess.sendErrorResponseSMB(-1073741637, 65535, 2);
                    return;
                }
                case 258: 
                case 1013: {
                    int flag = dataBuf.getByte();
                    boolean delFlag = flag == 1;
                    FileInfo delInfo = new FileInfo();
                    delInfo.setDeleteOnClose(delFlag);
                    delInfo.setFileInformationFlags(1024);
                    JCRDriver.setFileInformation(this.m_sess, conn, netFile.getFullName(), delInfo);
                    netFile.setDeleteOnClose(delFlag);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set file disposition fid=" + fid + ", name=" + netFile.getName() + ", delete=" + delFlag));
                }
            }
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = outPkt.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, 0, prmPos + 4);
            outPkt.setByteCount(prmPos - outPkt.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2SetPath(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2SetPath");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Set Path - path=" + path + ", level=0x" + Integer.toHexString(infoLevl)));
        }
        if (!this.isValidPath(path)) {
            this.m_sess.sendErrorResponseSMB(-1073741773, 13, 1);
            return;
        }
        try {
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            switch (infoLevl) {
                case 1: {
                    int fileSize;
                    int setFlags = 0;
                    finfo = new FileInfo(path, 0L, -1);
                    int smbDate = dataBuf.getShort();
                    int smbTime = dataBuf.getShort();
                    boolean hasSetTime = false;
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setCreationDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 16;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setAccessDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 32;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setModifyDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 8;
                        hasSetTime = true;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setFileSize(fileSize);
                        ++setFlags;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setAllocationSize(fileSize);
                        setFlags += 2;
                    }
                    int attr = dataBuf.getInt();
                    int eaListLen = dataBuf.getInt();
                    if (!hasSetTime && eaListLen == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    JCRDriver.setFileInformation(this.m_sess, conn, path, finfo);
                    if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(32)) break;
                    logger.debug((Object)("  Set Standard Info [" + this.m_smbPkt.getTreeId() + "] name=" + path + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", eaListLen=" + eaListLen));
                }
            }
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int prmPos = outPkt.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(outPkt, 2, prmPos, 0, prmPos + 4);
            outPkt.setByteCount(prmPos - outPkt.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
    }

    protected final void procWriteAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        logger.debug((Object)":procWriteAndX");
        if (!this.m_smbPkt.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        long offset = (long)this.m_smbPkt.getParameterLong(3) & 0xFFFFFFFFL;
        int dataPos = this.m_smbPkt.getParameter(11) + 4;
        int dataLen = this.m_smbPkt.getParameter(10);
        int dataLenHigh = 0;
        if (this.m_smbPkt.getReceivedLength() > 65535) {
            dataLenHigh = this.m_smbPkt.getParameter(9) & 1;
        }
        if (dataLenHigh > 0) {
            dataLen += dataLenHigh << 16;
        }
        if (this.m_smbPkt.getParameterCount() == 14) {
            long topOff = (long)this.m_smbPkt.getParameterLong(12) & 0xFFFFFFFFL;
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int wrtlen = dataLen;
        try {
            ((JCRNetworkFile)netFile).updateFile(new ByteArrayInputStream(buf, dataPos, dataLen), dataLen, offset);
            logger.debug((Object)(dataLen + " writed to binvalue"));
        }
        catch (AccessDeniedException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(6);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, wrtlen);
        outPkt.setParameter(3, 65535);
        if (dataLenHigh > 0) {
            outPkt.setParameter(4, dataLen >> 16);
            outPkt.setParameter(5, 0);
        } else {
            outPkt.setParameterLong(4, 0);
        }
        outPkt.setByteCount(0);
        outPkt.setParameter(1, outPkt.getLength());
        this.m_sess.sendResponseSMB(outPkt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTCreateAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        int respAction;
        NetworkFile netFile;
        int flags;
        NTParameterPacker prms;
        block43: {
            block44: {
                logger.debug((Object)":procNTCreateAndX");
                if (!this.m_smbPkt.checkPacketIsValid(24, 1)) {
                    this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                    return;
                }
                TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
                if (conn == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
                    return;
                }
                if (!conn.hasReadAccess()) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                if (conn.getSharedDevice().getType() == 3) {
                    IPCHandler.processIPCRequest(this.m_sess, outPkt);
                    return;
                }
                if (conn.getSharedDevice().getType() != 0) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                prms = new NTParameterPacker(this.m_smbPkt.getBuffer(), 42);
                int nameLen = prms.unpackWord();
                flags = prms.unpackInt();
                int rootFID = prms.unpackInt();
                int accessMask = prms.unpackInt();
                long allocSize = prms.unpackLong();
                int attrib = prms.unpackInt();
                int shrAccess = prms.unpackInt();
                int createDisp = prms.unpackInt();
                int createOptn = prms.unpackInt();
                int impersonLev = prms.unpackInt();
                int secFlags = prms.unpackByte();
                String fileName = DataPacker.getUnicodeString(this.m_smbPkt.getBuffer(), DataPacker.wordAlign(this.m_smbPkt.getByteOffset()), nameLen / 2);
                if (fileName == null) {
                    this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
                    return;
                }
                logger.debug((Object)(" filename before encoding = " + fileName));
                if (fileName.equals("")) {
                    fileName = "/";
                } else {
                    StringBuffer path = new StringBuffer(fileName);
                    for (int i = 0; i < path.length(); ++i) {
                        if (path.charAt(i) != '\\') continue;
                        path.setCharAt(i, '/');
                    }
                    fileName = path.toString();
                }
                String temp = fileName;
                String stream = null;
                int pos = temp.indexOf(":");
                if (pos == -1) {
                    fileName = NameCoder.DecodeName(temp);
                } else {
                    fileName = NameCoder.DecodeName(temp.substring(0, pos));
                    stream = temp.substring(pos);
                }
                logger.debug((Object)(" filename after encoding = " + fileName));
                logger.debug((Object)(" create dispositioon = " + FileAction.asString(createDisp)));
                if (stream != null) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                    return;
                }
                FileOpenParams params = new FileOpenParams(fileName, stream, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags);
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                    logger.debug((Object)("NT Create AndX [" + this.m_smbPkt.getTreeId() + "] params=" + params));
                }
                netFile = null;
                respAction = 0;
                try {
                    if (!conn.getSession().itemExists(fileName)) {
                        if (createDisp != 2 && createDisp != 3 && createDisp != 5 && createDisp != 0) {
                            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                            return;
                        }
                        if (!conn.hasWriteAccess()) {
                            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                            return;
                        }
                        netFile = JCRDriver.createFile(conn, params);
                        if (netFile != null && (createOptn & 0x1000) != 0) {
                            netFile.setDeleteOnClose(true);
                        }
                        respAction = 2;
                    } else {
                        if (createDisp == 2) {
                            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                            return;
                        }
                        netFile = JCRDriver.openFile(conn, params);
                        if (createDisp == 0 || createDisp == 5) {
                            if (netFile.isDirectory()) {
                                throw new AccessDeniedException();
                            }
                            ((JCRNetworkFile)netFile).truncateFile(0L);
                            if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                                logger.debug((Object)("  [" + this.m_smbPkt.getTreeId() + "] name=" + fileName + " truncated"));
                            }
                        }
                        respAction = 1;
                    }
                    fid = conn.addFile(netFile, this.getSession());
                }
                catch (TooManyFilesException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741537, 4, 1);
                    return;
                }
                catch (AccessDeniedException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                catch (FileExistsException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                    return;
                }
                catch (IOException ex) {
                    this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                    return;
                }
                catch (LockException e) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                catch (ConstraintViolationException e) {
                    this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
                    return;
                }
                catch (RepositoryException e) {
                    this.m_sess.sendErrorResponseSMB(13, 1);
                    return;
                }
                outPkt.setParameterCount(34);
                outPkt.setAndXCommand(255);
                outPkt.setParameter(1, 0);
                prms.reset(outPkt.getBuffer(), 41);
                boolean fakeOpLocks = false;
                String fname = params.getPath().toUpperCase();
                if (fname.endsWith(".URL")) {
                    fakeOpLocks = true;
                }
                if (!fakeOpLocks) break block44;
                if ((flags & 4) != 0) {
                    prms.packByte(2);
                    break block43;
                } else if ((flags & 2) != 0) {
                    prms.packByte(1);
                    break block43;
                } else {
                    prms.packByte(0);
                }
                break block43;
            }
            prms.packByte(0);
        }
        prms.packWord(fid);
        prms.packInt(respAction);
        if (netFile.hasCreationDate()) {
            prms.packLong(netFile.getCreationDate());
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasAccessDate()) {
            prms.packLong(netFile.getAccessDate());
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = netFile.getModifyDate();
            prms.packLong(modDate);
            prms.packLong(modDate);
        } else {
            prms.packLong(0L);
            prms.packLong(0L);
        }
        prms.packInt(netFile.getFileAttributes());
        long fileSize = netFile.getFileSize();
        if (fileSize > 0L) {
            fileSize = fileSize + 512L & 0xFFFFFFFFFFFFFE00L;
        }
        prms.packLong(fileSize);
        prms.packLong(netFile.getFileSize());
        prms.packWord(0);
        prms.packWord((flags & 0x10) != 0 ? 7 : 0);
        prms.packByte(netFile.isDirectory() ? 1 : 0);
        prms.packWord(0);
        int endPos = prms.getPosition();
        outPkt.setParameter(1, endPos - 4);
        if (this.m_smbPkt.hasAndXCommand()) {
            endPos = this.procAndXCommands(outPkt, endPos, netFile);
        }
        this.m_sess.sendResponseSMB(outPkt, endPos - 4);
    }

    protected final void procNTCancel(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procNTCancel");
        if (!this.m_smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        this.m_smbPkt.setParameterCount(0);
        this.m_smbPkt.setByteCount(0);
        if (!this.m_smbPkt.isLongErrorCode()) {
            this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() + 16384);
        }
        this.m_smbPkt.setLongErrorCode(-1073741536);
        if (!this.m_smbPkt.isUnicode()) {
            this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() + 32768);
        }
        this.m_sess.sendResponseSMB(this.m_smbPkt);
    }

    protected final void procNTTransaction(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procNTtransaction");
        if (!this.m_smbPkt.checkPacketIsValid(19, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        NTTransPacket ntTrans = new NTTransPacket(this.m_smbPkt.getBuffer());
        int subCmd = ntTrans.getNTFunction();
        if (subCmd == 4) {
            this.procNTTransactNotifyChange(ntTrans, outPkt);
            return;
        }
        SrvTransactBuffer transBuf = null;
        if (ntTrans.getTotalParameterCount() == ntTrans.getParameterBlockCount() && ntTrans.getTotalDataCount() == ntTrans.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(ntTrans);
        } else {
            transBuf = new SrvTransactBuffer(ntTrans.getSetupCount(), ntTrans.getTotalParameterCount(), ntTrans.getTotalDataCount());
            transBuf.setType(ntTrans.getCommand());
            transBuf.setFunction(subCmd);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("NT Transaction [" + this.m_smbPkt.getTreeId() + "] transbuf=" + transBuf));
            }
            byte[] buf = ntTrans.getBuffer();
            int cnt = ntTrans.getSetupCount();
            if (cnt > 0) {
                transBuf.appendSetup(buf, ntTrans.getSetupOffset(), cnt * 2);
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("NT Transaction [" + this.m_smbPkt.getTreeId() + "] pcnt=" + ntTrans.getNTParameter(4) + ", offset=" + ntTrans.getNTParameter(5)));
            }
            if ((cnt = ntTrans.getParameterBlockCount()) > 0) {
                transBuf.appendParameter(buf, ntTrans.getParameterBlockOffset(), cnt);
            }
            if ((cnt = ntTrans.getDataBlockCount()) > 0) {
                transBuf.appendData(buf, ntTrans.getDataBlockOffset(), cnt);
            }
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT Transaction [" + this.m_smbPkt.getTreeId() + "] cmd=0x" + Integer.toHexString(subCmd) + ", multiPkt=" + transBuf.isMultiPacket()));
        }
        if (transBuf.isMultiPacket()) {
            this.m_sess.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        this.processNTTransactionBuffer(transBuf, ntTrans);
    }

    protected final void procNTTransactionSecondary(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int dlen;
        logger.debug((Object)":procNTTransactionSecondary");
        if (!this.m_smbPkt.checkPacketIsValid(18, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        if (!this.m_sess.hasTransaction() || this.m_sess.getTransaction().isType() != 160) {
            this.m_sess.sendErrorResponseSMB(1, 2);
            return;
        }
        NTTransPacket ntTrans = new NTTransPacket(this.m_smbPkt.getBuffer());
        byte[] buf = ntTrans.getBuffer();
        SrvTransactBuffer transBuf = this.m_sess.getTransaction();
        int plen = ntTrans.getParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, ntTrans.getParameterBlockOffset(), plen);
        }
        if ((dlen = ntTrans.getDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, ntTrans.getDataBlockOffset(), dlen);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT Transaction Secondary [" + this.m_smbPkt.getTreeId() + "] paramLen=" + plen + ", dataLen=" + dlen));
        }
        int totParam = ntTrans.getTotalParameterCount();
        int totData = ntTrans.getTotalDataCount();
        int paramDisp = ntTrans.getParameterBlockDisplacement();
        int dataDisp = ntTrans.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)"NT Transaction complete, processing ...");
            }
            this.m_sess.setTransaction(null);
            this.processNTTransactionBuffer(transBuf, ntTrans);
        }
    }

    private final void processNTTransactionBuffer(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":processNTTransactionBuffer");
        switch (tbuf.getFunction()) {
            case 1: {
                this.procNTTransactCreate(tbuf, outPkt);
                break;
            }
            case 2: {
                this.procNTTransactIOCtl(tbuf, outPkt);
                break;
            }
            case 6: {
                this.procNTTransactQuerySecurityDesc(tbuf, outPkt);
                break;
            }
            case 3: {
                this.procNTTransactSetSecurityDesc(tbuf, outPkt);
                break;
            }
            case 5: {
                this.procNTTransactRename(tbuf, outPkt);
                break;
            }
            case 7: {
                this.m_sess.sendErrorResponseSMB(-1073741822, 65535, 2);
                break;
            }
            case 8: {
                this.m_sess.sendErrorResponseSMB(-1073741822, 65535, 2);
                break;
            }
            default: {
                this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTTransactCreate(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        logger.debug((Object)":procNTTransactCreate");
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)"NT TransactCreate");
        }
        if (tbuf.hasParameterBuffer() && tbuf.getParameterBuffer().getLength() < 52) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer tparams = tbuf.getParameterBuffer();
        int flags = tparams.getInt();
        int rootFID = tparams.getInt();
        int accessMask = tparams.getInt();
        long allocSize = tparams.getLong();
        int attrib = tparams.getInt();
        int shrAccess = tparams.getInt();
        int createDisp = tparams.getInt();
        int createOptn = tparams.getInt();
        int sdLen = tparams.getInt();
        int eaLen = tparams.getInt();
        int nameLen = tparams.getInt();
        int impersonLev = tparams.getInt();
        int secFlags = tparams.getByte();
        tparams.wordAlign();
        String fileName = tparams.getString(nameLen, true);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        if (fileName.equals("")) {
            fileName = "/";
        } else {
            StringBuffer path = new StringBuffer(fileName);
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '\\') continue;
                path.setCharAt(i, '/');
            }
            fileName = path.toString();
        }
        String temp = fileName;
        String stream = null;
        int pos = temp.indexOf(":");
        if (pos == -1) {
            fileName = NameCoder.DecodeName(temp);
        } else {
            fileName = NameCoder.DecodeName(temp.substring(0, pos));
            stream = temp.substring(pos);
        }
        if (stream != null) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        FileOpenParams params = new FileOpenParams(fileName, stream, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("NT TransactCreate [" + this.m_smbPkt.getTreeId() + "] params=" + params + "  secDescLen=" + sdLen + ", extAttribLen=" + eaLen));
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block35: {
                if (!conn.getSession().itemExists(fileName)) {
                    if (createDisp == 2 || createDisp == 3 || createDisp == 5 || createDisp == 0) {
                        netFile = JCRDriver.createFile(conn, params);
                        respAction = 2;
                        break block35;
                    } else {
                        if (!((Node)conn.getSession().getItem(fileName)).isNodeType("nt:file")) {
                            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
                        return;
                    }
                }
                if (createDisp == 2) {
                    this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                    return;
                }
                netFile = JCRDriver.openFile(conn, params);
                if (createDisp == 0 || createDisp == 5) {
                    if (netFile.isDirectory()) {
                        throw new AccessDeniedException();
                    }
                    ((JCRNetworkFile)netFile).truncateFile(0L);
                    if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                        logger.debug((Object)("  [" + this.m_smbPkt.getTreeId() + "] name=" + fileName + " truncated"));
                    }
                }
                respAction = 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741537, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 2, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        DataBuffer prms = new DataBuffer(128);
        if ((flags & 4) != 0) {
            prms.putByte(2);
        } else if ((flags & 2) != 0) {
            prms.putByte(1);
        } else {
            prms.putByte(0);
        }
        prms.putByte(0);
        prms.putShort(fid);
        prms.putInt(respAction);
        prms.putInt(0);
        if (netFile.hasCreationDate()) {
            prms.putLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.putLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.putLong(modDate);
            prms.putLong(modDate);
            prms.putLong(modDate);
        } else {
            prms.putLong(0L);
            prms.putLong(0L);
            prms.putLong(0L);
        }
        prms.putInt(netFile.getFileAttributes());
        prms.putLong(netFile.getFileSize());
        prms.putLong(netFile.getFileSize());
        prms.putShort(0);
        prms.putShort(0);
        prms.putByte(netFile.isDirectory() ? 1 : 0);
        outPkt.initTransactReply(prms.getBuffer(), prms.getLength(), null, 0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procNTTransactIOCtl(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procNTTransactIOCtl");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        int ctrlCode = setupBuf.getInt();
        int fid = setupBuf.getShort();
        boolean fsctrl = setupBuf.getByte() == 1;
        int filter = setupBuf.getByte();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NT IOCtl code=" + NTIOCtl.asString(ctrlCode) + ", fid=" + fid + ", fsctrl=" + fsctrl + ", filter=" + filter));
        }
        try {
            DataBuffer response = IOControlHandler.processIOControl(this.m_sess, conn, ctrlCode, fid, tbuf.getDataBuffer(), fsctrl, filter);
            if (response != null) {
                outPkt.initTransactReply(null, 0, response.getBuffer(), response.getLength(), 1);
                outPkt.setSetupParameter(0, response.getLength());
            } else {
                outPkt.initTransactReply(null, 0, null, 0, 1);
                outPkt.setSetupParameter(0, 0);
            }
        }
        catch (IOControlNotImplementedException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741822, 65, 2);
            return;
        }
        catch (SMBException ex) {
            this.m_sess.sendErrorResponseSMB(ex.getErrorCode(), 65, 2);
            return;
        }
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procNTTransactQuerySecurityDesc(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        NetworkFile netFile;
        logger.debug((Object)":procNTTransactQuerySecurityDesc");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int flags = paramBuf.getShort();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT QuerySecurityDesc fid=" + fid + ", flags=" + flags));
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        byte[] paramblk = new byte[4];
        DataPacker.putIntelInt(0, paramblk, 0);
        outPkt.initTransactReply(paramblk, paramblk.length, null, 0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procNTTransactSetSecurityDesc(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procNTTransactSetSecurityDesc");
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        TreeConnection conn = vc.findTreeConnection(tbuf.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int fid = paramBuf.getShort();
        paramBuf.skipBytes(2);
        int flags = paramBuf.getInt();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("NT SetSecurityDesc fid=" + fid + ", flags=" + flags));
        }
        this.m_sess.sendErrorResponseSMB(1, 2);
    }

    protected final void procNTTransactNotifyChange(NTTransPacket ntpkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procNTTransactNotifyChange");
        this.m_sess.sendErrorResponseSMB(-1073741637, 65535, 2);
    }

    protected final void procNTTransactRename(SrvTransactBuffer tbuf, NTTransPacket outPkt) throws IOException, SMBSrvException {
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)"NT TransactRename");
        }
        this.m_sess.sendErrorResponseSMB(1, 2);
    }
}

