/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.netbios.win32;

import org.exoplatform.services.cifs.netbios.NetBIOSName;
import org.exoplatform.services.cifs.netbios.win32.NetBIOSSocketException;
import org.exoplatform.services.cifs.netbios.win32.Win32NetBIOS;
import org.exoplatform.services.cifs.netbios.win32.WinsockNetBIOSException;

public class NetBIOSSocket {
    private static final int TypeNormal = 0;
    private static final int TypeListener = 1;
    private static final int TypeDatagram = 2;
    private static boolean _nbSocketInit;
    private int m_lana;
    private int m_socket;
    private NetBIOSName m_nbName;
    private int m_socketType;

    public static final void initializeSockets() throws WinsockNetBIOSException {
        if (!_nbSocketInit) {
            Win32NetBIOS.InitializeSockets();
            _nbSocketInit = true;
        }
    }

    public static final void shutdownSockets() {
        if (_nbSocketInit) {
            _nbSocketInit = false;
            Win32NetBIOS.ShutdownSockets();
        }
    }

    public static final boolean isInitialized() {
        return _nbSocketInit;
    }

    public static final NetBIOSSocket createListenerSocket(int lana, NetBIOSName nbName) throws WinsockNetBIOSException, NetBIOSSocketException {
        NetBIOSSocket.initializeSockets();
        int sockPtr = Win32NetBIOS.CreateSocket(lana);
        if (sockPtr == 0) {
            throw new NetBIOSSocketException("Failed to create NetBIOS socket");
        }
        if (Win32NetBIOS.BindSocket(sockPtr, nbName.getNetBIOSName()) != 0) {
            throw new NetBIOSSocketException("Failed to bind NetBIOS socket");
        }
        return new NetBIOSSocket(lana, sockPtr, nbName, 1);
    }

    public static final NetBIOSSocket createDatagramSocket(int lana) throws WinsockNetBIOSException, NetBIOSSocketException {
        NetBIOSSocket.initializeSockets();
        int sockPtr = Win32NetBIOS.CreateDatagramSocket(lana);
        if (sockPtr == 0) {
            throw new NetBIOSSocketException("Failed to create NetBIOS datagram socket");
        }
        return new NetBIOSSocket(lana, sockPtr, null, 2);
    }

    private NetBIOSSocket(int lana, int sockPtr, NetBIOSName nbName, int socketType) {
        this.m_lana = lana;
        this.m_nbName = nbName;
        this.m_socket = sockPtr;
        this.m_socketType = socketType;
    }

    public final int getLana() {
        return this.m_lana;
    }

    public final boolean isDatagramSocket() {
        return this.m_socketType == 2;
    }

    public final boolean isListener() {
        return this.m_socketType == 1;
    }

    public final boolean hasSocket() {
        return this.m_socket != 0;
    }

    public final int getSocket() {
        return this.m_socket;
    }

    public final NetBIOSName getName() {
        return this.m_nbName;
    }

    public final int write(byte[] buf, int off, int len) throws WinsockNetBIOSException {
        if (this.isDatagramSocket()) {
            throw new WinsockNetBIOSException("Write not allowed for datagram socket");
        }
        return Win32NetBIOS.SendSocket(this.getSocket(), buf, off, len);
    }

    public final int read(byte[] buf, int off, int maxLen) throws WinsockNetBIOSException {
        if (this.isDatagramSocket()) {
            throw new WinsockNetBIOSException("Read not allowed for datagram socket");
        }
        return Win32NetBIOS.ReceiveSocket(this.getSocket(), buf, off, maxLen);
    }

    public final int sendDatagram(NetBIOSName toName, byte[] buf, int off, int len) throws WinsockNetBIOSException {
        if (!this.isDatagramSocket()) {
            throw new WinsockNetBIOSException("Not a datagram type socket");
        }
        return Win32NetBIOS.SendSocketDatagram(this.getSocket(), toName.getNetBIOSName(), buf, off, len);
    }

    public final NetBIOSSocket listen() throws WinsockNetBIOSException, NetBIOSSocketException {
        if (!this.isListener()) {
            throw new NetBIOSSocketException("Not a listener type socket");
        }
        if (!this.hasSocket()) {
            throw new NetBIOSSocketException("NetBIOS socket not valid");
        }
        byte[] callerName = new byte[16];
        int sessSockPtr = Win32NetBIOS.ListenSocket(this.getSocket(), callerName);
        if (sessSockPtr == 0) {
            throw new NetBIOSSocketException("NetBIOS socket listen failed");
        }
        return new NetBIOSSocket(this.getLana(), sessSockPtr, new NetBIOSName(callerName, 0), 0);
    }

    public final void closeSocket() {
        if (this.hasSocket()) {
            Win32NetBIOS.CloseSocket(this.getSocket());
            this.setSocket(0);
        }
    }

    protected final void setSocket(int sockPtr) {
        this.m_socket = sockPtr;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[LANA:");
        str.append(this.getLana());
        str.append(",Name:");
        if (this.getName() != null) {
            str.append(this.getName());
        } else {
            str.append("<None>");
        }
        str.append(",Socket:");
        if (this.hasSocket()) {
            str.append("0x");
            str.append(Integer.toHexString(this.getSocket()));
        } else {
            str.append("<None>");
        }
        switch (this.m_socketType) {
            case 0: {
                str.append("Session");
                break;
            }
            case 1: {
                str.append("Listener");
                break;
            }
            case 2: {
                str.append("Datagram");
            }
        }
        str.append("]");
        return str.toString();
    }
}

