/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.filesys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.server.filesys.ExtByteArrayOutputStream;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.jcr.core.value.EditableBinaryValue;
import org.exoplatform.services.log.ExoLogger;

public class JCRNetworkFile
extends NetworkFile {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.server.JCRNetworkFile");
    private Node node;
    private EditableBinaryValue exv;
    private boolean isAnyChanges = false;

    public JCRNetworkFile(Node n) {
        this.node = n;
    }

    public JCRNetworkFile() {
    }

    public void setNodeRef(Node n) {
        this.node = n;
    }

    public Node getNodeRef() {
        return this.node;
    }

    protected void assignExtendedBinaryValue() throws IOException, RepositoryException {
        if (!this.node.isNodeType("nt:file")) {
            throw new AccessDeniedException();
        }
        this.exv = (EditableBinaryValue)this.getNodeRef().getNode("jcr:content").getProperty("jcr:data").getValue();
    }

    public boolean isExtendedBinaryValueAssigned() {
        return this.exv != null;
    }

    public void updateFile(InputStream is, int datalength, long position) throws IOException, RepositoryException {
        if (!this.isExtendedBinaryValueAssigned()) {
            this.assignExtendedBinaryValue();
        }
        this.exv.update(is, (long)datalength, position);
        this.isAnyChanges = true;
    }

    public int read(byte[] buffer, int offset, int length, long position) throws IOException, RepositoryException {
        int readed = 0;
        if (!this.isExtendedBinaryValueAssigned()) {
            if (!this.node.isNodeType("nt:file")) {
                throw new AccessDeniedException();
            }
            InputStream is = this.node.getNode("jcr:content").getProperty("jcr:data").getStream();
            long skip_count = is.skip(position);
            if (skip_count < position || skip_count == -1L) {
                readed = 0;
            } else {
                byte[] tmpbuf = new byte[length];
                readed = is.read(tmpbuf);
                if (readed != -1) {
                    System.arraycopy(tmpbuf, 0, buffer, offset, readed);
                } else {
                    readed = 0;
                }
            }
            is.close();
        } else {
            ExtByteArrayOutputStream bout = new ExtByteArrayOutputStream(length);
            readed = (int)this.exv.read((OutputStream)bout, (long)length, position);
            if (readed != -1) {
                System.arraycopy(bout.getBuf(), 0, buffer, offset, readed);
            } else {
                readed = 0;
            }
        }
        return readed;
    }

    public void truncateFile(long size) throws IOException, RepositoryException {
        if (!this.isExtendedBinaryValueAssigned()) {
            this.assignExtendedBinaryValue();
        }
        this.exv.setLength(size);
        this.isAnyChanges = true;
    }

    public void flush() throws RepositoryException {
        if (this.isExtendedBinaryValueAssigned()) {
            this.getNodeRef().getNode("jcr:content").getProperty("jcr:data").setValue((Value)this.exv);
            this.exv = null;
        }
    }

    public void saveChanges() throws RepositoryException {
        if (this.isChanged()) {
            this.flush();
            this.getNodeRef().save();
            this.isAnyChanges = false;
            this.releaseResources();
        }
    }

    public long getLength() throws RepositoryException {
        if (this.isExtendedBinaryValueAssigned() && this.isChanged()) {
            return this.exv.getLength();
        }
        return this.getNodeRef().getNode("jcr:content").getProperty("jcr:data").getLength();
    }

    public boolean isChanged() {
        return this.isAnyChanges;
    }

    public void releaseResources() {
        this.exv = null;
        this.isAnyChanges = false;
    }
}

