/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server.win32;

import java.io.IOException;
import org.exoplatform.services.cifs.netbios.win32.NetBIOSSocket;
import org.exoplatform.services.cifs.netbios.win32.WinsockNetBIOSException;
import org.exoplatform.services.cifs.smb.server.PacketHandler;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;

public class WinsockNetBIOSPacketHandler
extends PacketHandler {
    private static final int ReceiveBufferSizeError = Integer.MIN_VALUE;
    private int m_lana;
    private NetBIOSSocket m_sessSock;

    public WinsockNetBIOSPacketHandler(int lana, NetBIOSSocket sock) {
        super(2, "WinsockNB", "WSNB", sock.getName().getName());
        this.m_lana = lana;
        this.m_sessSock = sock;
    }

    public final int getLANA() {
        return this.m_lana;
    }

    public final NetBIOSSocket getSocket() {
        return this.m_sessSock;
    }

    public int readPacket(SMBSrvPacket pkt) throws IOException {
        int rxlen;
        block5: {
            rxlen = 0;
            try {
                rxlen = this.m_sessSock.read(pkt.getBuffer(), 4, pkt.getBufferLength() - 4);
                if (rxlen != Integer.MIN_VALUE) break block5;
                if (pkt.getBuffer().length < 131075) {
                    rxlen = pkt.getBufferLength() - 4;
                    byte[] newbuf = new byte[131075];
                    System.arraycopy(pkt.getBuffer(), 4, newbuf, 4, rxlen);
                    pkt.setBuffer(newbuf);
                    int rxlen2 = this.m_sessSock.read(pkt.getBuffer(), rxlen + 4, pkt.getBufferLength() - (rxlen + 4));
                    System.out.println("Winsock rx2 len=" + rxlen2);
                    if (rxlen2 == Integer.MIN_VALUE) {
                        throw new WinsockNetBIOSException(10040);
                    }
                    rxlen += rxlen2;
                    break block5;
                }
                throw new WinsockNetBIOSException(10040);
            }
            catch (WinsockNetBIOSException ex) {
                if (ex.getErrorCode() == 10054 || ex.getErrorCode() == 10101) {
                    rxlen = -1;
                }
                throw ex;
            }
        }
        return rxlen;
    }

    public void writePacket(SMBSrvPacket pkt, int len) throws IOException {
        int txlen = this.m_sessSock.write(pkt.getBuffer(), 4, len);
    }

    public void closeHandler() {
        super.closeHandler();
        if (this.m_sessSock != null) {
            this.m_sessSock.closeSocket();
        }
    }
}

