/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs;

import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cifs.CIFSService;
import org.exoplatform.services.cifs.ServerConfiguration;
import org.exoplatform.services.cifs.server.NetworkServer;
import org.exoplatform.services.cifs.smb.server.SMBServer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.picocontainer.Startable;

public class CIFSServiceImpl
implements CIFSService,
Startable {
    private Log log = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.CIFSServiceImpl");
    private ServerConfiguration config = null;
    private RepositoryService repositoryService;
    private OrganizationService organizationService;
    private NetworkServer server;

    public CIFSServiceImpl(InitParams params, RepositoryService repositoryService, OrganizationService organizationService) throws RepositoryException, RepositoryConfigurationException, NamingException {
        this.repositoryService = repositoryService;
        this.organizationService = organizationService;
        this.config = new ServerConfiguration(params);
    }

    public boolean isServerActive() {
        if (this.server == null) {
            return false;
        }
        return this.server.isActive();
    }

    public void start() {
        try {
            if (!this.config.isSMBServerEnabled()) {
                this.log.error((Object)"Starting CIFS service error: server not initalized");
                return;
            }
            this.log.info((Object)"Starting CIFS service");
            this.server = new SMBServer(this.config, this.repositoryService, this.organizationService);
            this.server.startServer();
            this.log.info((Object)("CIFS service is started server name: " + this.config.getServerName() + " on repository: " + (this.config.getRepoName() == null ? "default" : this.config.getRepoName())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.log.info((Object)"Stoping...");
        try {
            if (this.server != null) {
                this.server.shutdownServer(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServerConfiguration getConfiguration() {
        return this.config;
    }
}

