/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.cifs.server.filesys.TooManyFilesException;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.smb.dcerpc.DCEPipeType;
import org.exoplatform.services.cifs.smb.dcerpc.server.DCEPipeFile;
import org.exoplatform.services.cifs.smb.dcerpc.server.DCEPipeHandler;
import org.exoplatform.services.cifs.smb.server.DCERPCHandler;
import org.exoplatform.services.cifs.smb.server.NTParameterPacker;
import org.exoplatform.services.cifs.smb.server.NamedPipeTransaction;
import org.exoplatform.services.cifs.smb.server.PipeLanmanHandler;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.SMBSrvTransPacket;
import org.exoplatform.services.cifs.smb.server.SrvTransactBuffer;
import org.exoplatform.services.cifs.smb.server.VirtualCircuit;
import org.exoplatform.services.cifs.util.DataBuffer;
import org.exoplatform.services.cifs.util.DataPacker;

class IPCHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");

    IPCHandler() {
    }

    public static void processIPCRequest(SMBSrvSession sess, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        SMBSrvPacket smbPkt = sess.getReceivePacket();
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("IPC$ Request [" + smbPkt.getTreeId() + "] - cmd = " + smbPkt.getPacketTypeString()));
        }
        switch (smbPkt.getCommand()) {
            case 2: 
            case 45: {
                IPCHandler.procIPCFileOpen(sess, smbPkt, outPkt);
                break;
            }
            case 10: {
                IPCHandler.procIPCFileRead(sess, smbPkt, outPkt);
                break;
            }
            case 46: {
                IPCHandler.procIPCFileReadAndX(sess, smbPkt, outPkt);
                break;
            }
            case 11: {
                IPCHandler.procIPCFileWrite(sess, smbPkt, outPkt);
                break;
            }
            case 47: {
                IPCHandler.procIPCFileWriteAndX(sess, smbPkt, outPkt);
                break;
            }
            case 4: {
                IPCHandler.procIPCFileClose(sess, smbPkt, outPkt);
                break;
            }
            case 162: {
                IPCHandler.procNTCreateAndX(sess, smbPkt, outPkt);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(64, 2);
            }
        }
    }

    protected static void procTransaction(VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvSession sess, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("IPC$ Transaction  pipe=" + tbuf.getName() + ", subCmd=" + NamedPipeTransaction.getSubCommand(tbuf.getFunction())));
        }
        if (tbuf.getName().compareTo("\\PIPE\\LANMAN") == 0 && PipeLanmanHandler.processRequest(tbuf, sess, outPkt)) {
            return;
        }
        switch (tbuf.getFunction()) {
            case 1: {
                IPCHandler.procSetNamedPipeHandleState(sess, vc, tbuf, outPkt);
                break;
            }
            case 38: {
                DCERPCHandler.processDCERPCRequest(sess, vc, tbuf, outPkt);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(64, 2);
            }
        }
    }

    protected static void procIPCFileOpen(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int pipeType;
        int dataPos = rxPkt.getByteOffset();
        int dataLen = rxPkt.getByteCount();
        byte[] buf = rxPkt.getBuffer();
        String fileName = DataPacker.getString(buf, dataPos, dataLen);
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("IPC$ Open file = " + fileName));
        }
        if ((pipeType = DCEPipeType.getNameAsType(fileName)) == -1) {
            sess.sendErrorResponseSMB(2, 1);
            return;
        }
        TreeConnection conn = sess.findTreeConnection(rxPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(5, 2);
            return;
        }
        DCEPipeFile pipeFile = new DCEPipeFile(pipeType);
        pipeFile.setGrantedAccess(2);
        int fid = -1;
        try {
            fid = conn.addFile(pipeFile, sess);
        }
        catch (TooManyFilesException ex) {
            sess.sendErrorResponseSMB(4, 1);
            return;
        }
        outPkt.setParameterCount(15);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, fid);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, 0);
        outPkt.setParameterLong(6, 0);
        outPkt.setParameter(8, 0);
        outPkt.setParameter(9, 0);
        outPkt.setParameter(10, 0);
        outPkt.setParameter(11, 0);
        outPkt.setParameter(12, 0);
        outPkt.setParameter(13, 0);
        outPkt.setParameter(14, 0);
        outPkt.setByteCount(0);
        sess.sendResponseSMB(outPkt);
    }

    protected static void procIPCFileRead(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!rxPkt.checkPacketIsValid(5, 0)) {
            sess.sendErrorResponseSMB(64, 2);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)"IPC$ File Read");
        }
        DCERPCHandler.processDCERPCRead(sess, rxPkt, outPkt);
    }

    protected static void procIPCFileReadAndX(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!rxPkt.checkPacketIsValid(10, 0)) {
            sess.sendErrorResponseSMB(64, 2);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)"IPC$ File Read AndX");
        }
        DCERPCHandler.processDCERPCRead(sess, rxPkt, outPkt);
    }

    protected static void procIPCFileWrite(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!rxPkt.checkPacketIsValid(5, 0)) {
            sess.sendErrorResponseSMB(64, 2);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)"IPC$ File Write");
        }
        DCERPCHandler.processDCERPCRequest(sess, rxPkt, outPkt);
    }

    protected static void procIPCFileWriteAndX(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!rxPkt.checkPacketIsValid(12, 0)) {
            sess.sendErrorResponseSMB(64, 2);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)"IPC$ File Write AndX");
        }
        DCERPCHandler.processDCERPCRequest(sess, rxPkt, outPkt);
    }

    protected static void procIPCFileClose(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        if (!rxPkt.checkPacketIsValid(3, 0)) {
            sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = sess.findTreeConnection(rxPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(15, 1);
            return;
        }
        int fid = rxPkt.getParameter(0);
        DCEPipeFile netFile = (DCEPipeFile)conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("IPC$ File close [" + rxPkt.getTreeId() + "] fid=" + fid));
        }
        conn.removeFile(fid, sess);
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        sess.sendResponseSMB(outPkt);
    }

    protected static void procSetNamedPipeHandleState(SMBSrvSession sess, VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        setupBuf.skipBytes(2);
        int fid = setupBuf.getShort();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int state = paramBuf.getShort();
        TreeConnection conn = vc.findTreeConnection(tbuf.getTreeId());
        DCEPipeFile netFile = (DCEPipeFile)conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("  SetNmPHandState pipe=" + netFile.getName() + ", fid=" + fid + ", state=0x" + Integer.toHexString(state)));
        }
        netFile.setPipeState(state);
        SMBSrvTransPacket.initTransactReply(outPkt, 0, 0, 0, 0);
        sess.sendResponseSMB(outPkt);
    }

    protected static void procNTCreateAndX(SMBSrvSession sess, SMBSrvPacket rxPkt, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int pipeType;
        TreeConnection conn = sess.findTreeConnection(rxPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        NTParameterPacker prms = new NTParameterPacker(rxPkt.getBuffer(), 42);
        int nameLen = prms.unpackWord();
        int flags = prms.unpackInt();
        int rootFID = prms.unpackInt();
        int accessMask = prms.unpackInt();
        long allocSize = prms.unpackLong();
        int attrib = prms.unpackInt();
        int shrAccess = prms.unpackInt();
        int createDisp = prms.unpackInt();
        int createOptn = prms.unpackInt();
        int impersonLev = prms.unpackInt();
        int secFlags = prms.unpackByte();
        int pos = DataPacker.wordAlign(rxPkt.getByteOffset());
        String fileName = DataPacker.getUnicodeString(rxPkt.getBuffer(), pos, nameLen);
        if (fileName == null) {
            sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(2048)) {
            logger.debug((Object)("NT Create AndX [" + rxPkt.getTreeId() + "] name=" + fileName + ", flags=0x" + Integer.toHexString(flags) + ", attr=0x" + Integer.toHexString(attrib) + ", allocSize=" + allocSize));
        }
        if (!fileName.startsWith("\\PIPE")) {
            fileName = "\\PIPE" + fileName;
        }
        if ((pipeType = DCEPipeType.getNameAsType(fileName)) == -1) {
            sess.sendErrorResponseSMB(-1073741772, 6);
            return;
        }
        if (DCEPipeHandler.getHandlerForType(pipeType) == null) {
            sess.sendErrorResponseSMB(-1073741790, 6);
            return;
        }
        DCEPipeFile pipeFile = new DCEPipeFile(pipeType);
        pipeFile.setGrantedAccess(2);
        int fid = -1;
        try {
            fid = conn.addFile(pipeFile, sess);
        }
        catch (TooManyFilesException ex) {
            sess.sendErrorResponseSMB(6, 6);
            return;
        }
        outPkt.setParameterCount(34);
        prms.reset(outPkt.getBuffer(), 41);
        prms.packByte(0);
        prms.packWord(fid);
        prms.packInt(1);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packInt(128);
        prms.packLong(4096L);
        prms.packLong(0L);
        prms.packWord(2);
        prms.packByte(255);
        prms.packByte(5);
        prms.packByte(0);
        outPkt.setByteCount(0);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, outPkt.getLength());
        sess.sendResponseSMB(outPkt);
    }
}

