/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cifs.netbios.NetBIOSName;
import org.exoplatform.services.cifs.netbios.NetBIOSNameList;
import org.exoplatform.services.cifs.netbios.NetBIOSSession;
import org.exoplatform.services.cifs.netbios.win32.Win32NetBIOS;
import org.exoplatform.services.cifs.smb.DialectSelector;
import org.exoplatform.services.cifs.util.IPAddress;
import org.exoplatform.services.cifs.util.X64;
import org.exoplatform.services.log.ExoLogger;

public class ServerConfiguration {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs");
    private static final String[] m_sessDbgStr = new String[]{"NETBIOS", "STATE", "NEGOTIATE", "TREE", "SEARCH", "INFO", "FILE", "FILEIO", "TRANSACT", "ECHO", "ERROR", "IPC", "LOCK", "PKTTYPE", "DCERPC", "STATECACHE", "NOTIFY", "STREAMS", "SOCKET"};
    private PlatformType m_platform;
    private boolean m_smbEnable;
    private String m_name;
    private int m_srvType = 3;
    private String m_comment;
    private String m_domain;
    private String m_broadcast;
    private int m_nbNamePort = 137;
    private int m_nbSessPort = 139;
    private int m_nbDatagramPort = 138;
    private int m_tcpSMBPort = 445;
    private boolean m_announce = false;
    private int m_announceInterval = 5;
    private int m_sessDebug;
    private boolean m_netBIOSEnable = true;
    private boolean m_tcpSMBEnable = true;
    private boolean m_win32NBEnable = true;
    private InetAddress m_smbBindAddress = null;
    private InetAddress m_winsPrimary;
    private InetAddress m_winsSecondary;
    private boolean m_macExtensions = false;
    private String m_win32NBName;
    private int m_win32NBLANA = -1;
    private boolean m_win32NBAnnounce = false;
    private int m_win32NBAnnounceInterval = 5;
    private boolean m_win32NBUseWinsock;
    private String m_timeZone;
    private int m_tzOffset;
    private String m_localName;
    private String m_localDomain;
    private String[] workspaceList;
    private String repoName;
    private boolean fromJndi = true;
    private int securityMode;

    public ServerConfiguration(InitParams params) {
        PropertiesParam secur;
        ValueParam wsParam;
        PropertiesParam netBiosJava;
        ValueParam pEnable = params.getValueParam("enable_smb");
        if (pEnable != null) {
            if (!pEnable.getValue().equalsIgnoreCase("true")) {
                if (pEnable.getValue().equalsIgnoreCase("false")) {
                    this.setSMBServerEnabled(false);
                    return;
                }
                logger.error((Object)"Illegal value of parameter enable_smb");
                this.setSMBServerEnabled(false);
                return;
            }
        } else {
            logger.error((Object)"Server is not Enabled!");
            this.setSMBServerEnabled(false);
            return;
        }
        this.setSMBServerEnabled(true);
        this.determinePlatformType();
        ValueParam pmask = params.getValueParam("broadcast_mask");
        if (pmask != null) {
            if (!IPAddress.isNumericAddress(pmask.getValue())) {
                logger.error((Object)"Invalid broadcast mask, must be n.n.n.n format!");
                this.setBroadcastMask("255.255.255.0");
            } else {
                this.setBroadcastMask(pmask.getValue());
            }
        } else {
            this.setBroadcastMask("255.255.255.0");
        }
        ValueParam pHostName = params.getValueParam("host_name");
        if (pHostName == null) {
            logger.error((Object)"Server name is not assigned!!");
            this.setSMBServerEnabled(false);
            return;
        }
        String hostName = pHostName.getValue();
        if (hostName.length() > 15) {
            hostName = hostName.substring(0, 15);
            logger.warn((Object)("CIFS server name is longer than 15 characters, truncated to " + hostName));
        }
        this.setServerName(hostName);
        ValueParam pDomainName = params.getValueParam("workgroup");
        if (pDomainName != null) {
            this.m_localDomain = pDomainName.getValue();
        }
        this.setDomainName(this.getLocalDomainName().toUpperCase());
        ValueParam pComment = params.getValueParam("comment");
        if (pComment != null) {
            this.setComment(pComment.getValue());
        } else {
            this.setComment("Default server coment");
        }
        ValueParam pBindAddress = params.getValueParam("bind_address");
        if (pBindAddress != null) {
            try {
                InetAddress bindAddr = InetAddress.getByName(pBindAddress.getValue());
                this.setSMBBindAddress(bindAddr);
            }
            catch (UnknownHostException e) {
                this.setSMBBindAddress(null);
            }
        }
        if ((netBiosJava = params.getPropertiesParam("netbios_java")) != null && netBiosJava.getProperty("enabled").equals("true")) {
            this.setNetBIOSSMB(true);
            if (netBiosJava.getProperty("session_port") != null) {
                int sessport = Integer.parseInt(netBiosJava.getProperty("session_port"));
                if (sessport < 0 || sessport > 65535) {
                    logger.error((Object)"Illegal value of netbios_java session_port partameter!");
                    this.setNetBIOSSMB(false);
                } else {
                    this.m_nbSessPort = sessport;
                }
            }
            if (netBiosJava.getProperty("datagram_port") != null) {
                int dtgport = Integer.parseInt(netBiosJava.getProperty("datagram_port"));
                if (dtgport < 0 || dtgport > 65535) {
                    logger.error((Object)"Illegal value of netbios_java datagram_port partameter!");
                    this.setNetBIOSSMB(false);
                } else {
                    this.m_nbDatagramPort = dtgport;
                }
            }
            if (netBiosJava.getProperty("name_port") != null) {
                int nmport = Integer.parseInt(netBiosJava.getProperty("name_port"));
                if (nmport < 0 || nmport > 65535) {
                    logger.error((Object)"Illegal value of netbios_java datagram_port partameter!");
                    this.setNetBIOSSMB(false);
                } else {
                    this.m_nbNamePort = nmport;
                }
            }
            if (netBiosJava.getProperty("announce_enabled") != null && netBiosJava.getProperty("announce_enabled").equalsIgnoreCase("true")) {
                this.setHostAnnounce(true);
                if (netBiosJava.getProperty("announce_interval") != null) {
                    int interval = Integer.parseInt(netBiosJava.getProperty("announce_interval"));
                    if (interval > 0) {
                        this.setHostAnnounceInterval(interval);
                    } else {
                        logger.error((Object)"Illegal value of netbios_java host announcer interval partameter!");
                    }
                } else {
                    this.setHostAnnounceInterval(5);
                }
            }
        } else {
            this.setNetBIOSSMB(false);
        }
        this.setTcpipSMB(false);
        PropertiesParam winnbt = params.getPropertiesParam("winnetbios");
        if (winnbt != null && winnbt.getProperty("enabled").equals("true")) {
            block67: {
                String osName;
                String lanaStr;
                String win32Name = winnbt.getProperty("netbiosname");
                if (win32Name != null && win32Name.length() > 0) {
                    if (win32Name.length() > 16) {
                        logger.error((Object)("Invalid Win32 NetBIOS name, " + win32Name));
                    } else {
                        this.setWin32NetBIOSName(win32Name);
                    }
                }
                if ((lanaStr = winnbt.getProperty("lanas")) != null && lanaStr.length() > 0) {
                    this.setWin32LANA(new Integer(lanaStr));
                } else {
                    this.setWin32LANA(-1);
                }
                String nativeAPI = winnbt.getProperty("nativeapi");
                if (nativeAPI != null && nativeAPI.length() > 0) {
                    boolean useWinsock = true;
                    if (nativeAPI.equalsIgnoreCase("netbios")) {
                        useWinsock = false;
                    } else if (!nativeAPI.equalsIgnoreCase("winsock")) {
                        logger.error((Object)"Invalid NetBIOS API type, spefify 'winsock' or 'netbios'");
                        this.setSMBServerEnabled(false);
                        return;
                    }
                    this.setWin32WinsockNetBIOS(useWinsock);
                }
                if (this.useWinsockNetBIOS() && X64.isWindows64()) {
                    logger.warn((Object)"Using older Netbios() API code");
                    this.setWin32WinsockNetBIOS(false);
                }
                if ((osName = System.getProperty("os.name")).startsWith("Windows") && !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME")) {
                    try {
                        if (Win32NetBIOS.LanaEnumerate() != null) {
                            this.setWin32NetBIOS(true);
                            break block67;
                        }
                        logger.warn((Object)"No NetBIOS LANAs available");
                    }
                    catch (UnsatisfiedLinkError e) {
                        logger.error((Object)"Win32NetBIOS.dll not finded!!");
                        this.setWin32NetBIOS(false);
                    }
                } else {
                    this.setWin32NetBIOS(false);
                }
            }
            if (winnbt.getProperty("announce_enabled") != null && winnbt.getProperty("announce_enabled").equalsIgnoreCase("true")) {
                this.setWin32HostAnnouncer(true);
                if (winnbt.getProperty("announce_interval") != null) {
                    int interval = Integer.parseInt(winnbt.getProperty("announce_interval"));
                    if (interval > 0) {
                        this.setWin32HostAnnounceInterval(interval);
                    } else {
                        logger.error((Object)"Illegal value of netbios_java host announcer interval partameter!");
                        this.setWin32HostAnnouncer(false);
                    }
                } else {
                    this.setWin32HostAnnounceInterval(5);
                }
            } else {
                this.setWin32HostAnnouncer(false);
            }
        } else {
            this.setWin32NetBIOS(false);
        }
        if (!(this.hasNetBIOSSMB() || this.hasTcpipSMB() || this.hasWin32NetBIOS())) {
            this.setSMBServerEnabled(false);
        } else {
            this.setSMBServerEnabled(true);
        }
        String flags = "NETBIOS,Negotiate,Socket,Tree,PktType,StateCache,State,Search,Info,File,FileIO,Echo,Error,Notify,IPC,DCERPC,STREAMS";
        int sessDbg = 0;
        if (flags != null) {
            flags = flags.toUpperCase();
            StringTokenizer token = new StringTokenizer(flags, ",");
            while (token.hasMoreTokens()) {
                int idx;
                String dbg = token.nextToken().trim();
                for (idx = 0; idx < m_sessDbgStr.length && !m_sessDbgStr[idx].equalsIgnoreCase(dbg); ++idx) {
                }
                sessDbg += 1 << idx;
            }
        }
        this.setSessionDebugFlags(sessDbg);
        ValueParam repoParam = params.getValueParam("jndi-repository-name");
        if (repoParam == null) {
            this.fromJndi = false;
            repoParam = params.getValueParam("repository-name");
        }
        if (repoParam != null) {
            this.repoName = repoParam.getValue();
        }
        if (this.repoName == null) {
            logger.warn((Object)"Neither jndi-repository-name nor repository-name is set. Default repository will be obtained");
        }
        if ((wsParam = params.getValueParam("workspaces")) != null) {
            this.workspaceList = wsParam.getValue().split(",");
        }
        if ((secur = params.getPropertiesParam("security_param")) != null) {
            this.securityMode = 1;
            String challResp = winnbt.getProperty("challenge_response");
            if (challResp != null && challResp.equalsIgnoreCase("true")) {
                this.securityMode = 3;
            }
        } else {
            this.securityMode = 3;
        }
        this.securityMode = 3;
    }

    public ServerConfiguration() {
        String osName;
        this.determinePlatformType();
        this.setBroadcastMask("255.255.255.0");
        this.setServerName("SMB_SERVER");
        try {
            this.setDomainName(this.getLocalDomainName().toUpperCase());
        }
        catch (UnsatisfiedLinkError e) {
            this.setSMBServerEnabled(false);
            return;
        }
        this.setComment("This server is specific SMB server which works with JCR repository.");
        this.setNetBIOSSMB(true);
        this.setTcpipSMB(false);
        this.setWin32NetBIOSName("SMBWINSERV");
        this.setWin32LANA(-1);
        String nativeAPI = "netbios";
        if (nativeAPI != null && nativeAPI.length() > 0) {
            boolean useWinsock = false;
            if (nativeAPI.equalsIgnoreCase("netbios")) {
                useWinsock = false;
            } else if (!nativeAPI.equalsIgnoreCase("winsock")) {
                this.setSMBServerEnabled(false);
            }
            this.setWin32WinsockNetBIOS(useWinsock);
        }
        if (this.useWinsockNetBIOS() && X64.isWindows64()) {
            logger.warn((Object)"Using older Netbios() API code");
            this.setWin32WinsockNetBIOS(false);
        }
        if ((osName = System.getProperty("os.name")).startsWith("Windows") && !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME")) {
            if (Win32NetBIOS.LanaEnumerate() != null) {
                this.setWin32NetBIOS(true);
            } else {
                logger.warn((Object)"No NetBIOS LANAs available");
            }
        } else {
            this.setWin32NetBIOS(false);
        }
        this.setWin32HostAnnounceInterval(5);
        this.setWin32HostAnnouncer(true);
        if (!(this.hasNetBIOSSMB() || this.hasTcpipSMB() || this.hasWin32NetBIOS())) {
            this.setSMBServerEnabled(false);
        } else {
            this.setSMBServerEnabled(true);
        }
        String flags = "Negotiate,Socket,Tree,PktType,StateCache,State,Search,Info,File,FileIO,Echo,Error,Notify,NETBIOS,IPC,DCERPC,STREAMS";
        int sessDbg = 0;
        if (flags != null) {
            flags = flags.toUpperCase();
            StringTokenizer token = new StringTokenizer(flags, ",");
            while (token.hasMoreTokens()) {
                int idx;
                String dbg = token.nextToken().trim();
                for (idx = 0; idx < m_sessDbgStr.length && !m_sessDbgStr[idx].equalsIgnoreCase(dbg); ++idx) {
                }
                sessDbg += 1 << idx;
            }
        }
        this.setSessionDebugFlags(sessDbg);
    }

    private void setSessionDebugFlags(int sessDbg) {
        this.m_sessDebug = sessDbg;
    }

    private void setWin32HostAnnouncer(boolean b) {
        this.m_win32NBAnnounce = b;
    }

    private void setWin32HostAnnounceInterval(int i) {
        this.m_win32NBAnnounceInterval = i;
    }

    private void setWin32NetBIOS(boolean b) {
        this.m_win32NBEnable = b;
    }

    private void setWin32WinsockNetBIOS(boolean useWinsock) {
        this.m_win32NBUseWinsock = useWinsock;
    }

    private void setWin32LANA(int lana) {
        this.m_win32NBLANA = lana;
    }

    private void setWin32NetBIOSName(String win32Name) {
        this.m_win32NBName = win32Name;
    }

    private void setTcpipSMB(boolean b) {
        this.m_tcpSMBEnable = b;
    }

    private void setNetBIOSSMB(boolean b) {
        this.m_netBIOSEnable = b;
    }

    private void setSMBBindAddress(InetAddress bindAddr) {
        this.m_smbBindAddress = bindAddr;
    }

    private void setComment(String string) {
        this.m_comment = string;
    }

    private void setDomainName(String localDomainName) {
        this.m_domain = localDomainName;
    }

    private void setServerName(String string) {
        this.m_name = string;
    }

    public boolean isSMBServerEnabled() {
        return this.m_smbEnable;
    }

    public String getServerName() {
        return this.m_name;
    }

    public int getSessionDebugFlags() {
        return this.m_sessDebug;
    }

    public String getDomainName() {
        return this.m_domain;
    }

    public String getBroadcastMask() {
        return this.m_broadcast;
    }

    public String getComment() {
        return this.m_comment;
    }

    public String getTimeZone() {
        return this.m_timeZone;
    }

    public int getTimeZoneOffset() {
        return this.m_tzOffset;
    }

    public final boolean hasNetBIOSSMB() {
        return this.m_netBIOSEnable;
    }

    public final boolean hasTcpipSMB() {
        return this.m_tcpSMBEnable;
    }

    public final boolean hasWin32NetBIOS() {
        return this.m_win32NBEnable;
    }

    public final int getWin32LANA() {
        return this.m_win32NBLANA;
    }

    public final boolean hasWin32EnableAnnouncer() {
        return this.m_win32NBAnnounce;
    }

    public final int getWin32HostAnnounceInterval() {
        return this.m_win32NBAnnounceInterval;
    }

    public final String getWin32ServerName() {
        return this.m_win32NBName;
    }

    public final boolean useWinsockNetBIOS() {
        return this.m_win32NBUseWinsock;
    }

    public DialectSelector getEnabledDialects() {
        DialectSelector dialects = new DialectSelector();
        dialects.AddDialect(0);
        dialects.AddDialect(2);
        dialects.AddDialect(4);
        dialects.AddDialect(3);
        dialects.AddDialect(5);
        dialects.AddDialect(6);
        dialects.AddDialect(7);
        return dialects;
    }

    public final boolean hasMacintoshExtensions() {
        return this.m_macExtensions;
    }

    private final void determinePlatformType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.m_platform = PlatformType.WINDOWS;
        } else if (osName.equalsIgnoreCase("Linux")) {
            this.m_platform = PlatformType.LINUX;
        } else if (osName.startsWith("Mac OS X")) {
            this.m_platform = PlatformType.MACOSX;
        } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            this.m_platform = PlatformType.SOLARIS;
        }
    }

    public final String getLocalDomainName() {
        if (this.m_localDomain != null) {
            return this.m_localDomain;
        }
        String domainName = null;
        if (this.getPlatformType() == PlatformType.WINDOWS) {
            if (Win32NetBIOS.isInitialized()) {
                domainName = Win32NetBIOS.GetLocalDomainName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Local domain name is " + domainName + " (via JNI)"));
                }
            } else {
                logger.error((Object)"Win32NetBIOS.dll isnt loaded so can't find local domain name!");
            }
        } else {
            NetBIOSName nbName = null;
            try {
                NetBIOSNameList nbNameList;
                nbName = NetBIOSSession.FindName("\u0001\u0002__MSBROWSE__\u0002", '\u0001', 5000);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found browse master at " + nbName.getIPAddressString(0)));
                }
                if ((nbNameList = NetBIOSSession.FindNamesForAddress(nbName.getIPAddressString(0))) != null && (nbName = nbNameList.findName('\u001d', false)) != null) {
                    domainName = nbName.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_localDomain = domainName;
        return domainName;
    }

    private PlatformType getPlatformType() {
        return this.m_platform;
    }

    public final void setSMBServerEnabled(boolean ena) {
        this.m_smbEnable = ena;
    }

    public final void setBroadcastMask(String mask) {
        this.m_broadcast = mask;
        NetBIOSSession.setSubnetMask(mask);
    }

    public final void setPrimaryWINSServer(InetAddress addr) {
        this.m_winsPrimary = addr;
    }

    public final void setSecondaryWINSServer(InetAddress addr) {
        this.m_winsSecondary = addr;
    }

    public boolean isFromJndi() {
        return this.fromJndi;
    }

    public String[] getWorkspaceList() {
        return this.workspaceList;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public final int getNetBIOSSessionPort() {
        return this.m_nbSessPort;
    }

    public final InetAddress getSMBBindAddress() {
        return this.m_smbBindAddress;
    }

    public final boolean hasEnableAnnouncer() {
        return this.m_announce;
    }

    public final int getNetBIOSDatagramPort() {
        return this.m_nbDatagramPort;
    }

    public final int getHostAnnounceInterval() {
        return this.m_announceInterval;
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final int getTcpipSMBPort() {
        return this.m_tcpSMBPort;
    }

    public final boolean hasSMBBindAddress() {
        return this.m_smbBindAddress != null;
    }

    private void setHostAnnounce(boolean b) {
        this.m_announce = b;
    }

    private void setHostAnnounceInterval(int interval) {
        this.m_announceInterval = interval;
    }

    public int getSecurity() {
        return this.securityMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlatformType {
        Unknown,
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX;

    }
}

