/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.server.filesys.FileExistsException;
import org.exoplatform.services.cifs.server.filesys.FileInfo;
import org.exoplatform.services.cifs.server.filesys.FileOpenParams;
import org.exoplatform.services.cifs.server.filesys.JCRDriver;
import org.exoplatform.services.cifs.server.filesys.JCRNetworkFile;
import org.exoplatform.services.cifs.server.filesys.NameCoder;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.TooManyConnectionsException;
import org.exoplatform.services.cifs.server.filesys.TooManyFilesException;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.smb.SMBDate;
import org.exoplatform.services.cifs.smb.server.ProtocolHandler;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.VirtualCircuit;
import org.exoplatform.services.cifs.util.DataPacker;
import org.exoplatform.services.log.ExoLogger;

class CoreProtocolHandler
extends ProtocolHandler {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.server.CoreProtocolHandler");
    private static final int RESUME_START = 32771;
    private static final int RESUME_DOT = 32770;
    private static final int RESUME_DOTDOT = 32769;
    private static final int MaxWordValue = 65535;
    private static final String InvalidFileNameChars = ":|<>*?";
    private static final String InvalidFileNameCharsSearch = ":|<>";
    protected SMBSrvPacket m_smbPkt;

    protected CoreProtocolHandler() {
    }

    protected CoreProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "Core Protocol";
    }

    protected void procCheckDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procCheckDirectory");
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Check [" + treeId + "] name=" + dirName));
        }
        if (dirName.equals("")) {
            dirName = "/";
        } else {
            StringBuffer path = new StringBuffer(dirName);
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '\\') continue;
                path.setCharAt(i, '/');
            }
            dirName = NameCoder.DecodeName(path.toString());
        }
        try {
            Node node = (Node)conn.getSession().getItem(dirName);
            if (node.isNodeType("nt:file")) {
                this.m_sess.sendErrorResponseSMB(3, 1);
            }
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(3, 1);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCloseFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procCloseFile");
        if (!this.m_smbPkt.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int ftime = this.m_smbPkt.getParameter(1);
        int fdate = this.m_smbPkt.getParameter(2);
        NetworkFile netFile = conn.findFile(fid);
        try {
            ((JCRNetworkFile)netFile).saveChanges();
        }
        catch (Exception e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File close [" + treeId + "] fid=" + fid));
        }
        netFile.setClosed(true);
        conn.removeFile(fid, this.getSession());
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCreateDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procCreateDirectory");
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Create [" + treeId + "] name=" + dirName));
        }
        if (dirName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(dirName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        dirName = NameCoder.DecodeName(path.toString());
        try {
            if (conn.getSession().itemExists(dirName)) {
                this.m_sess.sendErrorResponseSMB(-1073741771, 80, 1);
                return;
            }
            JCRDriver.createNode(conn.getSession(), dirName, false);
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 15, 1);
            return;
        }
        catch (LockException e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCreateFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        logger.debug((Object)":procCreateFile");
        if (!this.m_smbPkt.checkPacketIsValid(3, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (fileName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(fileName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        fileName = NameCoder.DecodeName(path.toString());
        int attr = this.m_smbPkt.getParameter(0);
        int ftime = this.m_smbPkt.getParameter(1);
        int fdate = this.m_smbPkt.getParameter(2);
        FileOpenParams params = new FileOpenParams(fileName, 16, 2, attr);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Create [" + treeId + "] params=" + params));
        }
        NetworkFile netFile = null;
        try {
            netFile = JCRDriver.createFile(conn, params);
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(80, 1);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        outPkt.setParameterCount(1);
        outPkt.setParameter(0, fid);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procCreateTemporaryFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procCreateTemporaryFile EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procDeleteDirectory(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procDeleteDirectory");
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Directory Delete [" + treeId + "] name=" + dirName));
        }
        if (dirName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        StringBuffer path = new StringBuffer(dirName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        dirName = NameCoder.DecodeName(path.toString());
        try {
            Session sess = conn.getSession();
            Node node = (Node)sess.getItem(dirName);
            node.remove();
            sess.save();
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (LockException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procDeleteFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procDeleteFile");
        if (!this.m_smbPkt.checkPacketIsValid(1, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Delete tid[" + treeId + "] name= [" + fileName + "]"));
        }
        if (fileName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        StringBuffer path = new StringBuffer(fileName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        fileName = NameCoder.DecodeName(path.toString());
        try {
            Session sess = conn.getSession();
            Node node = (Node)sess.getItem(fileName);
            node.remove();
            sess.save();
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (LockException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (RepositoryException ex) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procDiskAttributes(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procDiskAttributes EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procEcho(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"\nCoreProtocolHandler::procEcho");
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int echoCnt = this.m_smbPkt.getParameter(0);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(512)) {
            logger.debug((Object)("Echo - Count = " + echoCnt));
        }
        int echoSeq = 1;
        while (echoCnt > 0) {
            outPkt.setParameter(0, echoSeq++);
            this.m_sess.sendResponseSMB(outPkt);
            --echoCnt;
            if (!logger.isDebugEnabled() || !this.m_sess.hasDebug(512)) continue;
            logger.debug((Object)("Echo Packet, Seq = " + echoSeq));
        }
    }

    protected void procFlushFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procFlushFile");
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Flush [" + netFile.getFileId() + "]"));
        }
        try {
            if (!(netFile instanceof JCRNetworkFile)) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
            ((JCRNetworkFile)netFile).flush();
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
                logger.debug((Object)("File Flush Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(29, 3);
            return;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procGetFileAttributes(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procGetFileAttributes");
        if (!this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Get File Information tid[" + treeId + "] name= [" + fileName + "]"));
        }
        try {
            if (fileName.equals("")) {
                fileName = "/";
            } else {
                StringBuffer path = new StringBuffer(fileName);
                for (int i = 0; i < path.length(); ++i) {
                    if (path.charAt(i) != '\\') continue;
                    path.setCharAt(i, '/');
                }
                fileName = path.toString();
            }
            String name = NameCoder.DecodeName(fileName);
            Node n = (Node)conn.getSession().getItem(name);
            FileInfo finfo = JCRDriver.getFileInformation(n);
            if (finfo != null) {
                if (conn.getSharedDevice().isReadOnly() && !finfo.isReadOnly()) {
                    finfo.setFileAttributes(finfo.getFileAttributes() + 1);
                }
                outPkt.setParameterCount(10);
                outPkt.setParameter(0, finfo.getFileAttributes());
                if (finfo.getModifyDateTime() != 0L) {
                    SMBDate dateTime = new SMBDate(finfo.getModifyDateTime());
                    outPkt.setParameter(1, dateTime.asSMBTime());
                    outPkt.setParameter(2, dateTime.asSMBDate());
                } else {
                    outPkt.setParameter(1, 0);
                    outPkt.setParameter(2, 0);
                }
                outPkt.setParameter(3, (int)finfo.getSize() & 0xFFFF);
                outPkt.setParameter(4, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                for (int i = 5; i < 10; ++i) {
                    outPkt.setParameter(i, 0);
                }
                outPkt.setByteCount(0);
                this.m_sess.sendResponseSMB(outPkt);
                return;
            }
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        this.m_sess.sendErrorResponseSMB(2, 1);
    }

    protected void procGetFileInformation(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procGetFileInformation");
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Get File Information 2 [" + netFile.getFileId() + "]"));
        }
        try {
            FileInfo finfo = JCRDriver.getFileInformation(((JCRNetworkFile)netFile).getNodeRef());
            if (finfo != null) {
                if (conn.getSharedDevice().isReadOnly() && !finfo.isReadOnly()) {
                    finfo.setFileAttributes(finfo.getFileAttributes() + 1);
                }
                outPkt.setParameterCount(11);
                outPkt.setByteCount(0);
                SMBDate dateTime = new SMBDate(0);
                if (finfo.getCreationDateTime() != 0L) {
                    dateTime.setTime(finfo.getCreationDateTime());
                    outPkt.setParameter(0, dateTime.asSMBDate());
                    outPkt.setParameter(1, dateTime.asSMBTime());
                } else {
                    outPkt.setParameter(0, 0);
                    outPkt.setParameter(1, 0);
                }
                if (finfo.getAccessDateTime() != 0L) {
                    dateTime.setTime(finfo.getAccessDateTime());
                    outPkt.setParameter(2, dateTime.asSMBDate());
                    outPkt.setParameter(3, dateTime.asSMBTime());
                } else {
                    outPkt.setParameter(2, 0);
                    outPkt.setParameter(3, 0);
                }
                if (finfo.getModifyDateTime() != 0L) {
                    dateTime.setTime(finfo.getModifyDateTime());
                    outPkt.setParameter(4, dateTime.asSMBDate());
                    outPkt.setParameter(5, dateTime.asSMBTime());
                } else {
                    outPkt.setParameter(4, 0);
                    outPkt.setParameter(5, 0);
                }
                outPkt.setParameter(6, (int)finfo.getSize() & 0xFFFF);
                outPkt.setParameter(7, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                outPkt.setParameter(8, (int)finfo.getSize() & 0xFFFF);
                outPkt.setParameter(9, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                outPkt.setParameter(10, finfo.getFileAttributes());
                this.m_sess.sendResponseSMB(outPkt);
                return;
            }
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        this.m_sess.sendErrorResponseSMB(2, 1);
    }

    protected void procLockFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procLockFile EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procOpenFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int fid;
        logger.debug((Object)":procOpenFile");
        if (!this.m_smbPkt.checkPacketIsValid(2, 2)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (fileName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(fileName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        fileName = NameCoder.DecodeName(path.toString());
        int mode = this.m_smbPkt.getParameter(0);
        int attr = this.m_smbPkt.getParameter(1);
        FileOpenParams params = new FileOpenParams(fileName, mode, 2, attr);
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Open [" + treeId + "] params=" + params));
        }
        NetworkFile netFile = null;
        try {
            netFile = JCRDriver.openFile(conn, params);
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (Exception e) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(7);
        outPkt.setParameter(0, fid);
        outPkt.setParameter(1, 0);
        if (netFile.hasModifyDate()) {
            outPkt.setParameterLong(2, (int)(netFile.getModifyDate() / 1000L));
        } else {
            outPkt.setParameterLong(2, 0);
        }
        outPkt.setParameterLong(4, netFile.getFileSizeInt());
        outPkt.setParameter(6, netFile.getGrantedAccess());
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procProcessExit(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procExit");
        if (!this.m_smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Process Exit - Open files = " + conn.openFileCount()));
        }
        if (conn.openFileCount() > 0) {
            conn.closeConnection(this.getSession());
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procReadFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procReadFile");
        if (!this.m_smbPkt.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int reqcnt = this.m_smbPkt.getParameter(1);
        int reqoff = this.m_smbPkt.getParameter(2) + (this.m_smbPkt.getParameter(3) << 16);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Read [" + netFile.getFileId() + "] : Size=" + reqcnt + " ,Pos=" + reqoff));
        }
        byte[] buf = outPkt.getBuffer();
        int rdlen = 0;
        try {
            int dataOff = outPkt.getByteOffset() + 3;
            int availCnt = buf.length - dataOff;
            if (!this.m_sess.hasClientCapability(16384)) {
                availCnt = this.m_sess.getClientMaximumBufferSize() - dataOff;
            }
            if (availCnt < reqcnt) {
                reqcnt = availCnt;
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                    logger.debug((Object)("File Read [" + netFile.getFileId() + "] Limited to " + availCnt));
                }
            }
            rdlen = ((JCRNetworkFile)netFile).read(buf, outPkt.getByteOffset() + 3, reqcnt, reqoff);
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int bytOff = outPkt.getByteOffset();
        buf[bytOff] = 1;
        DataPacker.putIntelShort(rdlen, buf, bytOff + 1);
        outPkt.setByteCount(rdlen + 3);
        outPkt.setParameter(0, rdlen);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procRenameFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procRenameFile EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected final void procSearch(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procSearch EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected final void procSearchVolumeLabel(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procSearchVolumeLabel EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected final void procSeekFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procSeekFile EMPTY");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procSessionSetup(SMBSrvPacket outPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        logger.debug((Object)"\nCoreProtocolHandler::procSessionSetup");
        outPkt.setParameterCount(3);
        outPkt.setParameter(0, 0);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 8192);
        outPkt.setByteCount(0);
        outPkt.setTreeId(0);
        outPkt.setUserId(0);
        int pos = outPkt.getByteOffset();
        byte[] buf = outPkt.getBuffer();
        pos = DataPacker.putString("Java", buf, pos, true);
        pos = DataPacker.putString("JLAN Server " + this.m_sess.getServer().isVersion(), buf, pos, true);
        pos = DataPacker.putString(this.m_sess.getServer().getConfiguration().getDomainName(), buf, pos, true);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
        this.m_sess.setState(3);
    }

    protected void procSetFileAttributes(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procSetFileAttributes");
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (fileName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(fileName);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        fileName = NameCoder.DecodeName(path.toString());
        int fattr = this.m_smbPkt.getParameter(0);
        int setFlags = 4;
        FileInfo finfo = new FileInfo(fileName, 0L, fattr);
        int fdate = this.m_smbPkt.getParameter(1);
        int ftime = this.m_smbPkt.getParameter(2);
        if (fdate != 0 && ftime != 0) {
            finfo.setModifyDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 8;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Set File Attributes [" + treeId + "] name=" + fileName + ", attr=0x" + Integer.toHexString(fattr) + ", fdate=" + fdate + ", ftime=" + ftime));
        }
        try {
            finfo.setFileInformationFlags(setFlags);
            JCRDriver.setFileInformation(this.m_sess, conn, fileName, finfo);
        }
        catch (Exception ex) {
            // empty catch block
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void procSetFileInformation(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procSetFileInformation");
        if (!this.m_smbPkt.checkPacketIsValid(7, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        int setFlags = 0;
        FileInfo finfo = new FileInfo(netFile.getName(), 0L, 0);
        int fdate = this.m_smbPkt.getParameter(1);
        int ftime = this.m_smbPkt.getParameter(2);
        if (fdate != 0 && ftime != 0) {
            finfo.setCreationDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 16;
        }
        fdate = this.m_smbPkt.getParameter(3);
        ftime = this.m_smbPkt.getParameter(4);
        if (fdate != 0 && ftime != 0) {
            finfo.setAccessDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 32;
        }
        fdate = this.m_smbPkt.getParameter(5);
        ftime = this.m_smbPkt.getParameter(6);
        if (fdate != 0 && ftime != 0) {
            finfo.setModifyDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 8;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("Set File Information 2 [" + netFile.getFileId() + "] " + finfo.toString()));
        }
        try {
            finfo.setFileInformationFlags(setFlags);
            if (finfo.hasSetFlag(1024) && !finfo.hasDeleteOnClose()) {
                // empty if block
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procTreeConnect(SMBSrvPacket outPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        logger.debug((Object)"\nCoreProtocolHandler::procTreeConnect");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procTreeDisconnect(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"procTreeDisconnect");
        if (!this.m_smbPkt.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 1, 2);
            return;
        }
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = vc.findTreeConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree disconnect - " + treeId + ", " + conn.toString()));
        }
        vc.removeConnection(treeId, this.m_sess);
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procUnLockFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"\nCoreProtocolHandler::procUnLockDirectory");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected final void procUnsupported(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    protected void procWriteFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procWriteFile");
        if (!this.m_smbPkt.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(0);
        int wrtcnt = this.m_smbPkt.getParameter(1);
        long wrtoff = (long)(this.m_smbPkt.getParameter(2) + (this.m_smbPkt.getParameter(3) << 16)) & 0xFFFFFFFFL;
        int cleft = this.m_smbPkt.getParameter(4);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write [" + netFile.getFileId() + "] : Size=" + wrtcnt + " ,Pos=" + wrtoff + " , CountLeft=" + cleft));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int pos = this.m_smbPkt.getByteOffset();
        int wrtlen = 0;
        if (buf[pos] != 1) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        try {
            pos += 3;
            if (wrtcnt == 0) {
                ((JCRNetworkFile)netFile).truncateFile(wrtoff);
            } else {
                ((JCRNetworkFile)netFile).updateFile(new ByteArrayInputStream(buf, pos, wrtcnt), wrtcnt, wrtoff);
                wrtlen = wrtcnt;
            }
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(29, 3);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(1);
        outPkt.setParameter(0, wrtlen);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procWriteAndCloseFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)"\nCoreProtocolHandler::procWriteAndCloseFile");
        this.m_sess.sendErrorResponseSMB(65535, 2);
    }

    public boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException {
        logger.debug((Object)":runProtocol()");
        if (this.m_smbPkt == null) {
            this.m_smbPkt = new SMBSrvPacket(this.m_sess.getBuffer());
        }
        boolean handledOK = true;
        SMBSrvPacket outPkt = this.m_smbPkt;
        switch (this.m_smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(outPkt);
                break;
            }
            case 112: {
                this.procTreeConnect(outPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(outPkt);
                break;
            }
            case 129: {
                this.procSearch(outPkt);
                break;
            }
            case 128: {
                this.procDiskAttributes(outPkt);
                break;
            }
            case 8: {
                this.procGetFileAttributes(outPkt);
                break;
            }
            case 9: {
                this.procSetFileAttributes(outPkt);
                break;
            }
            case 35: {
                this.procGetFileInformation(outPkt);
                break;
            }
            case 34: {
                this.procSetFileInformation(outPkt);
                break;
            }
            case 2: {
                this.procOpenFile(outPkt);
                break;
            }
            case 10: {
                this.procReadFile(outPkt);
                break;
            }
            case 18: {
                this.procSeekFile(outPkt);
                break;
            }
            case 4: {
                this.procCloseFile(outPkt);
                break;
            }
            case 3: 
            case 15: {
                this.procCreateFile(outPkt);
                break;
            }
            case 11: {
                this.procWriteFile(outPkt);
                break;
            }
            case 44: {
                this.procWriteAndCloseFile(outPkt);
                break;
            }
            case 5: {
                this.procFlushFile(outPkt);
                break;
            }
            case 7: {
                this.procRenameFile(outPkt);
                break;
            }
            case 6: {
                this.procDeleteFile(outPkt);
                break;
            }
            case 0: {
                this.procCreateDirectory(outPkt);
                break;
            }
            case 1: {
                this.procDeleteDirectory(outPkt);
                break;
            }
            case 16: {
                this.procCheckDirectory(outPkt);
                break;
            }
            case 39: {
                this.procUnsupported(outPkt);
                break;
            }
            case 43: {
                this.procEcho(outPkt);
                break;
            }
            case 17: {
                this.procProcessExit(outPkt);
                break;
            }
            case 14: {
                this.procCreateTemporaryFile(outPkt);
                break;
            }
            case 12: {
                this.procLockFile(outPkt);
                break;
            }
            case 13: {
                this.procUnLockFile(outPkt);
                break;
            }
            default: {
                handledOK = false;
            }
        }
        return handledOK;
    }

    protected boolean isValidPath(String path) {
        for (int i = 0; i < InvalidFileNameChars.length(); ++i) {
            if (path.indexOf(InvalidFileNameChars.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    protected String unpackUnicode(byte[] byt, int pos, int maxlen) {
        char curChar;
        if (maxlen == 0) {
            return "";
        }
        int maxpos = pos + maxlen * 2;
        int endpos = pos;
        char[] chars = new char[maxlen];
        int cpos = 0;
        do {
            curChar = (char)(((byt[endpos] & 0xFF) << 8) + (byt[endpos + 1] & 0xFF));
            chars[cpos++] = curChar;
        } while (curChar != '\u0000' && (endpos += 2) < maxpos);
        if (endpos <= maxpos) {
            if (curChar == '\u0000') {
                --cpos;
            }
            return new String(chars, 0, cpos);
        }
        return null;
    }
}

