/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;
import java.util.Vector;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.ServerConfiguration;
import org.exoplatform.services.cifs.netbios.NetworkSettings;
import org.exoplatform.services.cifs.server.NetworkServer;
import org.exoplatform.services.cifs.server.SrvSessionList;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.smb.mailslot.HostAnnouncer;
import org.exoplatform.services.cifs.smb.server.NetBIOSSessionSocketHandler;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.SessionSocketHandler;
import org.exoplatform.services.cifs.smb.server.TcpipSMBSessionSocketHandler;
import org.exoplatform.services.cifs.smb.server.win32.Win32NetBIOSLanaMonitor;
import org.exoplatform.services.cifs.smb.server.win32.Win32NetBIOSSessionSocketHandler;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;

public class SMBServer
extends NetworkServer
implements Runnable {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.CIFS.smb.server.SMBServer");
    private static final String ServerVersion = "1.0.1";
    private Thread m_srvThread;
    private Vector<SessionSocketHandler> m_sessionHandlers;
    private Vector<HostAnnouncer> m_hostAnnouncers;
    private SrvSessionList m_sessions;
    private int m_srvType = 4099;
    private UUID m_serverGUID;
    private RepositoryService repositoryService;
    private OrganizationService organizationService;

    public SMBServer(ServerConfiguration config, RepositoryService repositoryService, OrganizationService organizationService) throws IOException {
        super(config);
        this.repositoryService = repositoryService;
        this.organizationService = organizationService;
        this.setVersion(ServerVersion);
        this.m_sessionHandlers = new Vector();
        this.m_sessions = new SrvSessionList();
        NetworkSettings.setDomain(this.getConfiguration().getDomainName());
        NetworkSettings.setBroadcastMask(this.getConfiguration().getBroadcastMask());
    }

    public final void addSessionHandler(SessionSocketHandler handler) {
        if (this.m_sessionHandlers == null) {
            this.m_sessionHandlers = new Vector();
        }
        this.m_sessionHandlers.addElement(handler);
    }

    public final void addHostAnnouncer(HostAnnouncer announcer) {
        if (this.m_hostAnnouncers == null) {
            this.m_hostAnnouncers = new Vector();
        }
        this.m_hostAnnouncers.addElement(announcer);
    }

    public final void addSession(SMBSrvSession sess) {
        this.m_sessions.addSession(sess);
        sess.setDebug(this.getConfiguration().getSessionDebugFlags());
    }

    protected void closeHostAnnouncers() {
        if (this.m_hostAnnouncers != null) {
            for (int i = 0; i < this.m_hostAnnouncers.size(); ++i) {
                HostAnnouncer announcer = this.m_hostAnnouncers.elementAt(i);
                announcer.shutdownAnnouncer();
            }
        }
    }

    protected void closeSessionHandlers() {
        for (SessionSocketHandler handler : this.m_sessionHandlers) {
            handler.shutdownRequest();
        }
        this.m_sessionHandlers.removeAllElements();
    }

    public final String getComment() {
        return this.getConfiguration().getComment();
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final int getSessionDebug() {
        return this.getConfiguration().getSessionDebugFlags();
    }

    public final SrvSessionList getSessions() {
        return this.m_sessions;
    }

    public void run() {
        boolean isWindows;
        block17: {
            this.setActive(true);
            isWindows = this.isWindowsNTOnwards();
            this.m_serverGUID = UUID.nameUUIDFromBytes(this.getServerName().getBytes());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SMB Server " + this.getServerName() + " starting"));
                logger.info((Object)("GUID " + this.m_serverGUID));
                if (this.getConfiguration().getTimeZone() != null) {
                    logger.info((Object)("Server timezone " + this.getConfiguration().getTimeZone() + ", offset from UTC = " + this.getConfiguration().getTimeZoneOffset() / 60 + "hrs"));
                } else {
                    logger.info((Object)("Server timezone offset = " + this.getConfiguration().getTimeZoneOffset() / 60 + "hrs"));
                }
            }
            try {
                SharedDevice adminpipe = new SharedDevice("IPC$", 3);
                adminpipe.setAttributes(3);
                this.getShares().addShare(adminpipe);
                this.setShutdown(false);
                this.getServerIPAddresses();
                boolean sockDbg = false;
                if ((this.getSessionDebug() & 0x40000) != 0) {
                    sockDbg = true;
                }
                if (this.getConfiguration().hasNetBIOSSMB()) {
                    NetBIOSSessionSocketHandler.createSessionHandlers(this, sockDbg);
                }
                if (this.getConfiguration().hasTcpipSMB()) {
                    TcpipSMBSessionSocketHandler.createSessionHandlers(this, sockDbg);
                }
                if (this.getConfiguration().hasWin32NetBIOS() && isWindows) {
                    Win32NetBIOSSessionSocketHandler.createSessionHandlers(this, sockDbg);
                }
                if (this.m_sessionHandlers.size() > 0 || this.getConfiguration().hasWin32NetBIOS()) {
                    while (!this.hasShutdown()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {}
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)"No valid session handlers, server closing");
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block17;
                logger.error((Object)"Server error : ", (Throwable)ex);
                this.setException(ex);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SMB Server shutting down ...");
        }
        this.closeHostAnnouncers();
        this.closeSessionHandlers();
        if (isWindows && Win32NetBIOSLanaMonitor.getLanaMonitor() != null) {
            Win32NetBIOSLanaMonitor.getLanaMonitor().shutdownRequest();
        }
        this.setActive(false);
    }

    protected final void sessionClosed(SMBSrvSession sess) {
        this.m_sessions.removeSession(sess);
    }

    protected final void sessionLoggedOn(SMBSrvSession sess) {
    }

    protected final void sessionOpened(SMBSrvSession sess) {
    }

    public final void shutdownServer(boolean immediate) {
        this.setShutdown(true);
        try {
            this.closeSessionHandlers();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Enumeration<Integer> enm = this.m_sessions.enumerate();
        while (enm.hasMoreElements()) {
            Integer sessId = enm.nextElement();
            SMBSrvSession sess = (SMBSrvSession)this.m_sessions.findSession(sessId);
            sess.closeSession();
        }
        if (this.m_srvThread != null) {
            try {
                this.m_srvThread.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("SMB Server");
        this.m_srvThread.setDaemon(true);
        this.m_srvThread.start();
    }

    private final boolean isWindowsNTOnwards() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME");
        }
        return false;
    }

    private final void getServerIPAddresses() {
        try {
            Enumeration<NetworkInterface> enm = NetworkInterface.getNetworkInterfaces();
            Vector<InetAddress> addrList = new Vector<InetAddress>();
            while (enm.hasMoreElements()) {
                NetworkInterface ni = enm.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    addrList.add(addrs.nextElement());
                }
            }
            if (addrList.size() > 0) {
                InetAddress[] inetAddrs = new InetAddress[addrList.size()];
                for (int i = 0; i < addrList.size(); ++i) {
                    inetAddrs[i] = (InetAddress)addrList.elementAt(i);
                }
                this.setServerAddresses(inetAddrs);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting local IP addresses", (Throwable)ex);
        }
    }

    public final UUID getServerGUID() {
        return this.m_serverGUID;
    }

    public String[] getWorkspaceList() {
        Repository repo;
        String[] wsList = this.getConfiguration().getWorkspaceList();
        try {
            repo = this.getRepository();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (repo instanceof ManageableRepository) {
            return ((ManageableRepository)repo).getWorkspaceNames();
        }
        if (wsList != null) {
            return wsList;
        }
        throw new RuntimeException("Non-eXo JCR does not support dynamic workspace list. Please set 'workspaces' parameter with comma delimited workspace names available to browsing.");
    }

    public Repository getRepository() throws RepositoryConfigurationException, RepositoryException, NamingException {
        String repoName = this.getConfiguration().getRepoName();
        boolean isJndi = this.getConfiguration().isFromJndi();
        if (repoName == null) {
            return this.repositoryService.getDefaultRepository();
        }
        return isJndi ? (Repository)new InitialContext().lookup(repoName) : this.repositoryService.getRepository(repoName);
    }

    public OrganizationService getOrgainzationService() {
        return this.organizationService;
    }
}

